<?php
add_action('vc_build_admin_page', 'modus_shortcode_product_single');
add_action( 'vc_before_init', 'modus_shortcode_product_single' );

function modus_shortcode_product_single() {
	/**
	 * @shortcode product
	 * @description Show a single product by ID or SKU.
	 *
	 * @param id integer
	 * @param sku string
	 * If the product isn’t showing, make sure it isn’t set to Hidden in the Catalog Visibility.
	 * To find the Product ID, go to the Product > Edit screen and look in the URL for the postid= .
	 */
    wp_reset_postdata();
    vc_map( array(
        'name' => esc_html__( '[Modus] Single Product', 'modus_sc' ),
        'base' => 'modus_single_product',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'Modus single product', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( '', 'modus_sc' ),
                'admin_label' => true,
            ),
			array(
				'type' => 'autocomplete',
				'heading' => __( 'Select identificator', 'modus_sc' ),
				'param_name' => 'id',
				'description' => __( 'Input product ID or product SKU or product title to see suggestions', 'modus_sc' ),
			),
			array(
				'type' => 'hidden',
				// This will not show on render, but will be used when defining value for autocomplete
				'param_name' => 'sku',
			),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}
/**
 * Suggester for autocomplete by id/name/title/sku
 * @since 4.4
 *
 * @param $query
 *
 * @return array - id's from products with title/sku.
 */
function productIdAutocompleteSuggester( $query ) {
	global $wpdb;
	$product_id = (int) $query;
	$post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT a.ID AS id, a.post_title AS title, b.meta_value AS sku
				FROM {$wpdb->posts} AS a
				LEFT JOIN ( SELECT meta_value, post_id  FROM {$wpdb->postmeta} WHERE `meta_key` = '_sku' ) AS b ON b.post_id = a.ID
				WHERE a.post_type = 'product' AND ( a.ID = '%d' OR b.meta_value LIKE '%%%s%%' OR a.post_title LIKE '%%%s%%' )", $product_id > 0 ? $product_id : - 1, stripslashes( $query ), stripslashes( $query ) ), ARRAY_A );

	$results = array();
	if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
		foreach ( $post_meta_infos as $value ) {
			$data = array();
			$data['value'] = $value['id'];
			$data['label'] = __( 'Id', 'modus_sc' ) . ': ' . $value['id'] . ( ( strlen( $value['title'] ) > 0 ) ? ' - ' . __( 'Title', 'modus_sc' ) . ': ' . $value['title'] : '' ) . ( ( strlen( $value['sku'] ) > 0 ) ? ' - ' . __( 'Sku', 'modus_sc' ) . ': ' . $value['sku'] : '' );
			$results[] = $data;
		}
	}

	return $results;
}
/**
 * Find product by id
 * @since 4.4
 *
 * @param $query
 *
 * @return bool|array
 */
function productIdAutocompleteRender( $query ) {
	$query = trim( $query['value'] ); // get value from requested
	if ( ! empty( $query ) ) {
		// get product
		$product_object = wc_get_product( (int) $query );
		if ( is_object( $product_object ) ) {
			$product_sku = $product_object->get_sku();
			$product_title = $product_object->get_title();
			$product_id = $product_object->get_id();

			$product_sku_display = '';
			if ( ! empty( $product_sku ) ) {
				$product_sku_display = ' - ' . __( 'Sku', 'modus_sc' ) . ': ' . $product_sku;
			}

			$product_title_display = '';
			if ( ! empty( $product_title ) ) {
				$product_title_display = ' - ' . __( 'Title', 'modus_sc' ) . ': ' . $product_title;
			}

			$product_id_display = __( 'Id', 'modus_sc' ) . ': ' . $product_id;

			$data = array();
			$data['value'] = $product_id;
			$data['label'] = $product_id_display . $product_title_display . $product_sku_display;

			return ! empty( $data ) ? $data : false;
		}

		return false;
	}

	return false;
}
/**
	 * Replace single product sku to id.
	 * @since 4.4
	 *
	 * @param $current_value
	 * @param $param_settings
	 * @param $map_settings
	 * @param $atts
	 *
	 * @return bool|string
	 */
function productIdDefaultValue( $current_value, $param_settings, $map_settings, $atts ) {
	$value = trim( $current_value );
	if ( strlen( trim( $current_value ) ) === 0 && isset( $atts['sku'] ) && strlen( $atts['sku'] ) > 0 ) {
		$value = $this->productIdDefaultValueFromSkuToId( $atts['sku'] );
	}

	return $value;
}
/**
 * Return ID of product by provided SKU of product.
 * @since 4.4
 *
 * @param $query
 *
 * @return bool
 */
function productIdDefaultValueFromSkuToId( $query ) {
	$result = $this->productIdAutocompleteSuggesterExactSku( $query );

	return isset( $result['value'] ) ? $result['value'] : false;
}
/**
 * Find product by SKU
 * @since 4.4
 *
 * @param $query
 *
 * @return bool|array
 */
function productIdAutocompleteSuggesterExactSku( $query ) {
	global $wpdb;
	$query = trim( $query );
	$product_id = $wpdb->get_var( $wpdb->prepare( "SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key='_sku' AND meta_value='%s' LIMIT 1", stripslashes( $query ) ) );
	$product_data = get_post( $product_id );
	if ( 'product' !== $product_data->post_type ) {
		return '';
	}

	$product_object = wc_get_product( $product_data );
	if ( is_object( $product_object ) ) {

		$product_sku = $product_object->get_sku();
		$product_title = $product_object->get_title();
		$product_id = $product_object->get_id();

		$product_sku_display = '';
		if ( ! empty( $product_sku ) ) {
			$product_sku_display = ' - ' . __( 'Sku', 'js_composer' ) . ': ' . $product_sku;
		}

		$product_title_display = '';
		if ( ! empty( $product_title ) ) {
			$product_title_display = ' - ' . __( 'Title', 'js_composer' ) . ': ' . $product_title;
		}

		$product_id_display = __( 'Id', 'js_composer' ) . ': ' . $product_id;

		$data = array();
		$data['value'] = $product_id;
		$data['label'] = $product_id_display . $product_title_display . $product_sku_display;

		return ! empty( $data ) ? $data : false;
	}

	return false;
}
add_filter( 'vc_autocomplete_modus_single_product_id_callback', 'productIdAutocompleteSuggester', 10, 1 ); 
add_filter( 'vc_autocomplete_modus_single_product_id_render', 'productIdAutocompleteRender', 10, 1 ); 
add_filter( 'vc_form_fields_render_field_modus_single_product_id_param_value', 'productIdDefaultValue', 10, 4 );