<?php
add_action('vc_build_admin_page', 'modus_shortcode_product_masonry');
add_action( 'vc_before_init', 'modus_shortcode_product_masonry' );

function modus_shortcode_product_masonry() {
    $layout = array( esc_html__( 'All Links', 'modus-sc' ) => '' );
    $link_cats = get_terms( 'product_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $layout[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        'name' => esc_html__( '[Modus] Product Masonry', 'modus-sc' ),
        'base' => 'modus_product_masonry',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'List item(s) product', 'modus-sc' ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Product Show', 'modus-sc' ),
                'param_name' => 'type_product',
                'value' => array(
                    esc_html__( 'New Product', 'modus-sc' ) => 'new-product',
                    esc_html__( 'Sale Product', 'modus-sc' ) => 'sale-product',
                    esc_html__( 'Featured Product', 'modus-sc' ) => 'feature-product',
                    esc_html__( 'Top Rated Product', 'modus-sc' ) => 'top-rated-product',
                    esc_html__( 'Bestselling Product', 'modus-sc' ) => 'bestselling-product',
                ),
                'description' => esc_html__( 'Type product show.ex:porpular,best sale...', 'modus-sc' ),
            ),

            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout for type grid', 'modus-sc' ),
                'param_name' => 'typecss',
                'value' => array(
                    esc_html__( 'Type 1', 'modus-sc' ) => 'type1',
                    esc_html__( 'Type 2', 'modus-sc' ) => 'type2',
                    esc_html__( 'Type 3', 'modus-sc' ) => 'type3',
                    esc_html__( 'Type 4', 'modus-sc' ) => 'type4',
                    esc_html__( 'Type 5', 'modus-sc' ) => 'type5',
                    esc_html__( 'Type 6', 'modus-sc' ) => 'type6',
                    esc_html__( 'Type 7', 'modus-sc' ) => 'type7',
                    esc_html__( 'Type 8', 'modus-sc' ) => 'type8',
                ),
                'description' => esc_html__( 'Select type css item product.', 'modus-sc' ),
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Category", "modus-sc"),
                "param_name" => "cat_product",
                "value" => $layout,
                'description' => esc_html__( 'Select taxonomy layout you would like to use', 'modus-sc' ),
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", "modus-sc"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "modus"),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus-sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus-sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus-sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus-sc' ),
            ),
        )
    ) );
}