<?php
add_action('vc_build_admin_page', 'modus_shortcode_product');
add_action( 'vc_before_init', 'modus_shortcode_product' );

function modus_shortcode_product() {
    $layout = array( esc_html__( 'All Links', 'modus_sc' ) => '' );
    $link_cats = get_terms( 'product_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $layout[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        'name' => esc_html__( '[Modus] Product', 'modus_sc' ),
        'base' => 'modus_product',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'List item(s) product', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'modus_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type Heading Title', 'modus_sc' ),
                'param_name' => 'type_heading',
                'group' => esc_html__( 'Other Setting', 'modus_sc' ),
                'value' => array(
                    esc_html__( 'Type Heading Title 1', 'modus_sc' ) => 'type1',
                    esc_html__( 'Type Heading Title 2', 'modus_sc' ) => 'type2',
                    esc_html__( 'Type Heading Title 3', 'modus_sc' ) => 'type3',
                    esc_html__( 'Type Heading Title 4', 'modus_sc' ) => 'type4',
                    esc_html__( 'Type Heading Title 5', 'modus_sc' ) => 'type5',
                    esc_html__( 'Type Heading Title 6', 'modus_sc' ) => 'type6',
                ),
                'description' => esc_html__( 'Select type for heading title shortcode.', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Sub Title', 'modus_sc' ),
                'param_name' => 'sub_title',
                'group' => esc_html__( 'Other Setting', 'modus_sc' ),
                'description' => esc_html__( 'Widget Sub Title.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'type_heading',
                    'value' => 'type3'
                ),
            ),
            array(
                'type' => 'textarea',
                'heading' => esc_html__( 'Description', 'modus_sc' ),
                'param_name' => 'desc_title',
                'group' => esc_html__( 'Other Setting', 'modus_sc' ),
                'description' => esc_html__( 'Text description.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'type_heading',
                    'value' => 'type3'
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Product Show', 'modus_sc' ),
                'param_name' => 'type_product',
                'value' => array(
                    esc_html__( 'New Product', 'modus_sc' ) => 'new-product',
                    esc_html__( 'Sale Product', 'modus_sc' ) => 'sale-product',
                    esc_html__( 'Featured Product', 'modus_sc' ) => 'feature-product',
                    esc_html__( 'Top Rated Product', 'modus_sc' ) => 'top-rated-product',
                    esc_html__( 'Bestselling Product', 'modus_sc' ) => 'bestselling-product',
                    esc_html__( 'Featured Product Load More', 'modus_sc' ) => 'feature-product-more',
                ),
                'description' => esc_html__( 'Type product show.ex:porpular,best sale...', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type', 'modus_sc' ),
                'param_name' => 'type_layout',
                'value' => array(
                    esc_html__( 'Slide type grid', 'modus_sc' ) => 'grid',
                    esc_html__( 'Slide type list', 'modus_sc' ) => 'list',
                ),
                'description' => esc_html__( 'Select type show item product. Default type is slider.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'type_product',
                    'value' => array('new-product','sale-product','feature-product','top-rated-product')
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout for type grid', 'modus_sc' ),
                'param_name' => 'typecss',
                'value' => array( 
                    esc_html__( 'Type 1', 'modus-sc' ) => 'type1',
                    esc_html__( 'Type 2', 'modus-sc' ) => 'type2',
                    esc_html__( 'Type 3', 'modus-sc' ) => 'type3',
                    esc_html__( 'Type 4', 'modus-sc' ) => 'type4',
                    esc_html__( 'Type 5', 'modus-sc' ) => 'type5',
                    esc_html__( 'Type 6', 'modus-sc' ) => 'type6',
                    esc_html__( 'Type 7', 'modus-sc' ) => 'type7',
                    esc_html__( 'Type 8', 'modus-sc' ) => 'type8', 
                    esc_html__( 'Type 9', 'modus-sc' ) => 'type9', 
                ),
                'description' => esc_html__( 'Select type css item product.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'type_layout',
                    'value' => 'grid',
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout for type list', 'modus_sc' ),
                'param_name' => 'typelist',
                'value' => array(
                    esc_html__( 'Type 1', 'modus_sc' ) => 'type1',
                    esc_html__( 'Type 2', 'modus_sc' ) => 'type2',
                ),
                'description' => esc_html__( 'Select type css item product.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'type_layout',
                    'value' => 'list',
                ),
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Category", "modus_sc"),
                "param_name" => "cat_product",
                "value" => $layout,
                'description' => esc_html__( 'Select taxonomy layout you would like to use', 'modus_sc' ),
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", "modus_sc"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "modus"),
            ),
            array(
				'type' => 'number',
				'heading' => esc_html__( 'Column', 'modus_sc' ),
				'param_name' => 'column',
				'value' => 1,
                'min'   => 1,
                'max'   => 6,
				'dependency' => array(
					'element' => 'type_product',
					'value' => array('new-product','sale-product','feature-product','top-rated-product','bestselling-product','feature-product-more')
				),
				'description' => esc_html__( 'Layout column product.', 'modus_sc' ),
            ),
            array(
                'type' => 'number',
                'heading' => esc_html__( 'Row', 'modus_sc' ),
                'param_name' => 'row',
                'value' => 1,
                'min'   => 1,
                'max'   => 6,
                'dependency' => array(
                    'element' => 'type_product',
                    'value' => array('new-product','sale-product','feature-product','top-rated-product','bestselling-product')
                ),
                'description' => esc_html__( 'Layout row slide product.', 'modus_sc' ),
            ),
            array(
                "type" => "ult_switch",
                "heading" => esc_html__( "Custom Slide Navigation Button", "modus_sc" ),
                "param_name" => "custom_slide",
                'value' => '',
                'options' => array(
                    'enable_custom_slide' => array(
                        'label' => '',
                        'on' => esc_html__('Yes','ultimate_vc'),
                        'off' => esc_html__('No','ultimate_vc')
                    )
                ),
                'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
                'description' =>esc_html__( 'if enable, Custom button next, prev the slider','modus_sc' ),
            ),
            array(
                "type" => "ult_switch",
                "heading" => esc_html__( "Show Text Banner Left", "modus_sc" ),
                "param_name" => "show_txtbanner",
                'value' => '',
                'options' => array(
                    'enable_show_txtbanner' => array(
                        'label' => '',
                        'on' => esc_html__('Yes','ultimate_vc'),
                        'off' => esc_html__('No','ultimate_vc')
                    )
                ),
                'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
                'description' =>esc_html__( 'if enable, show nav button next, prev.','modus_sc' ),
                'dependency' => array(
                    'element' => 'type_product',
                    'value' => array('new-product','sale-product','feature-product')
                )
            ),
            array(
                "type" => "textarea_html",
                "heading" => esc_html__( "Description", "modus" ),
                "param_name" => "content",
                "value" => esc_html__( "", "modus" ),
                "description" => esc_html__( "Enter your content.", "modus" ),
                'dependency' => array(
                    'element' => 'show_txtbanner',
                    'value' => 'enable_show_txtbanner',
                )
            ),
            array(
				'type' => 'ult_switch',
				"heading" => esc_html__( "Show Navigation", "modus" ),
				"param_name" => "show_nav",
				'value' => '',
				'options' => array(
					'enable_show_nav' => array(
						'label' => '',
						'on' => esc_html__('Yes','ultimate_vc'),
						'off' => esc_html__('No','ultimate_vc')
					)
				),
				'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
				'description' =>esc_html__( 'if enable, show navigation.','modus_sc' ),
				'dependency' => array(
					'element' => 'type_product',
					'value' => array('new-product','sale-product','feature-product','top-rated-product','bestselling-product')
				)
            ),
            array(
				"type" => "ult_switch",
				"heading" => esc_html__( "Show Navigation Button", "modus_sc" ),
				"param_name" => "show_navbt",
				'value' => '',
				'options' => array(
					'enable_show_navbt' => array(
						'label' => '',
						'on' => esc_html__('Yes','ultimate_vc'),
						'off' => esc_html__('No','ultimate_vc')
					)
				),
				'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
				'description' =>esc_html__( 'if enable, show nav button next, prev.','modus_sc' ),
				'dependency' => array(
					'element' => 'type_product',
					'value' => array('new-product','sale-product','feature-product','top-rated-product','bestselling-product')
				)
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}