<?php
/**
 * Portfolio Tab
 */
add_action( 'vc_before_init', 'modus_shortcode_portfolio_tab' );

function modus_shortcode_portfolio_tab() {
    $link_category = array( esc_html__( 'Select...', 'modus_sc' ) => '' );
    $link_cats = get_terms( 'portfolio_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $link_category[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        "name" => esc_html__( "[Modus] Portfolio Tabs", 'modus_sc' ),
        "base" => "modus_portfolio_tab",
        'icon' => 'modus_vc_icon',
        "category" => "Modus",
        "description" => esc_html__( 'Show item portfolio.','modus_sc' ),
        "params" => array(
             array(
                'type' => 'textfield',
                'param_name' => 'title',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'description' => esc_html__( 'Enter text heading title.', 'modus_sc' ),
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'modus_sc' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter icon, title and color.', 'modus_sc' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'title' => esc_html__( 'Tab 1', 'modus_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Tab 2', 'modus_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Tab 3', 'modus_sc' ),
                    ),
                ) ) ),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'modus_sc' ),
                        'param_name' => 'title',
                        'description' => esc_html__( 'Title tab.', 'modus_sc' ),
                        'admin_label' => true,
                    ),
                    array(
                        "type" => "dropdown",
                        "heading" => esc_html__("Categories", 'modus_sc'),
                        "param_name" => "portfolio_cat",
                        "value" => $link_category,
                        'description' => esc_html__( 'Select category would like to use', 'modus_sc' ),
                    ),
                ),
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", 'modus_sc'),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("Select item show. note: value -1 if show all item.", 'modus_sc'),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Column', 'modus_sc' ),
                'param_name' => 'column',
                'value' => array(
                    esc_html__( '1 Column', 'modus_sc' ) => '1',
                    esc_html__( '2 Column', 'modus_sc' ) => '2',
                    esc_html__( '3 Column', 'modus_sc' ) => '3',
                    esc_html__( '4 Column', 'modus_sc' ) => '4',
                    esc_html__( '6 Column', 'modus_sc' ) => '6',
                ),
                'description' => esc_html__( 'Select column show item.', 'modus_sc' ),
            ),
             array(
                  "type"        => "checkbox",
                  "heading"     => __("No Padding"),
                  "param_name"  => "no_padding",
                  "admin_label" => true,
                  "value"       => array(
                        esc_html__( 'Yes', 'modus_sc' ) => 'no_padding',
                                    ),                  
                  "description" => __("Select no padding item")
            ),  
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' )
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','modus_sc' ),
            )
        )
    ));
}