<?php
add_action('vc_build_admin_page', 'modus_shortcode_portfolio');
add_action( 'vc_before_init', 'modus_shortcode_portfolio' );

function modus_shortcode_portfolio() {
    $link_category = array( esc_html__( 'All Links', 'modus_sc' ) => '' );
    $link_cats = get_terms( 'portfolio_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $link_category[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        'name' => esc_html__( '[Modus] Portfolio', 'modus_sc' ),
        'base' => 'modus_portfolio',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'List item(s) Portfolio', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'modus_sc' ),
                'admin_label' => true,
            ), 
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Category", "modus_sc"),
                "param_name" => "cat_portfolio",
                "value" => $link_category,
                'description' => esc_html__( 'Select taxonomy layout you would like to use', 'modus_sc' ),
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", "modus_sc"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "modus"),
            ),
            array(
				'type' => 'number',
				'heading' => esc_html__( 'Column', 'modus_sc' ),
				'param_name' => 'column',
				'value' => 1,
                'min'   => 1,
                'max'   => 6,				
				'description' => esc_html__( 'Layout column portfolio.', 'modus_sc' ),
            ),
            array(
                'type' => 'number',
                'heading' => esc_html__( 'Row', 'modus_sc' ),
                'param_name' => 'row',
                'value' => 1,
                'min'   => 1,
                'max'   => 6,                
                'description' => esc_html__( 'Layout row slide portfolio.', 'modus_sc' ),
            ),
            array(
                'type' => 'ult_switch',
                "heading" => esc_html__( "Show Navigation", "modus" ),
                "param_name" => "show_nav",
                'value' => '',
                'options' => array(
                    'enable_show_nav' => array(
                        'label' => '',
                        'on' => esc_html__('Yes','ultimate_vc'),
                        'off' => esc_html__('No','ultimate_vc')
                    )
                ),
                'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
                'description' =>esc_html__( 'if enable, show navigation.','modus_sc' ),                
            ),
            array(
                "type" => "ult_switch",
                "heading" => esc_html__( "Show Navigation Button", "modus_sc" ),
                "param_name" => "show_navbt",
                'value' => '',
                'options' => array(
                    'enable_show_navbt' => array(
                        'label' => '',
                        'on' => esc_html__('Yes','ultimate_vc'),
                        'off' => esc_html__('No','ultimate_vc')
                    )
                ),
                'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
                'description' =>esc_html__( 'if enable, show nav button next, prev.','modus_sc' ),                
            ),  
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}