<?php
/**
 * Latest project
 */

add_action( 'vc_before_init', 'modus_shortcode_menuitem' );
function modus_shortcode_menuitem(){ 
    vc_map( array(
        "name" => esc_html__( "[Modus] Menu Item", 'modus_sc' ),
        "base" => "modus_menuitem",
        "icon" => "modus_vc_icon",
        "category" => "Modus",
        "description" => esc_html__( 'List item blog','modus_sc' ),
        "params" => array( 
            array(
                'type' => 'number',
                'param_name' => 'img_width',
                'heading' => esc_html__( 'Picture Width', 'modus_sc' ),
                'description' => esc_html__( 'Enter picture width.', 'modus_sc' ),
            ),
            array(
                'type' => 'number',
                'param_name' => 'lb_width',
                'heading' => esc_html__( 'Label Width(%)', 'modus_sc' ),
                'description' => esc_html__( 'Enter Label width.', 'modus_sc' ),
            ),
            array(
                'type' => 'number',
                'param_name' => 'lb_columns',
                'heading' => esc_html__( 'Label columns(%)', 'modus_sc' ),
                'description' => esc_html__( 'Enter Label columns number.', 'modus_sc' ),
            ), 
			array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Menu Items', 'modus_sc' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter title, link and Feature Image.', 'modus_sc' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'title' => esc_html__( 'Item 1', 'modus_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Item 2', 'modus_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Item 3', 'modus_sc' ),
                    ),
                ) ) ),
                'params' => array(
					 array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'modus_sc' ),
                        'param_name' => 'title',
                        'description' => esc_html__( 'Title tab.', 'modus_sc' ),
                        'admin_label' => true,
                    ),
                    array(
						'type' => 'vc_link',
						'heading' => esc_html__( 'Title and URL (Link)', 'modus_sc' ),
						'param_name' => 'link',
						'description' => esc_html__( 'Add link for Menu Item', 'modus_sc' ),
					),
                    array(
						'type' => 'attach_image',
						'heading' => esc_html__( 'Image', 'modus_sc' ),
						'param_name' => 'image',
						'description' => esc_html__( 'Select image from media library.', 'modus_sc' ), 
					),
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' )
            ),

        ),
    ));
}