<?php
add_action('vc_build_admin_page', 'modus_shortcode_map');
add_action( 'vc_before_init', 'modus_shortcode_map' );

function modus_shortcode_map() {
    vc_map(
        array(
           "name" => esc_html__("[Modus] Map","modus"),
           "base" => "modus_map",
           "class" => "modus_map",
           "icon" => "modus_vc_icon",
           "category" => "Modus",
           "description" => esc_html__("Google map.","modus"),
           "params" => array(
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Layout map', 'modus_sc' ),
                    'param_name' => 'google_map',
                    'value' => array(
                        esc_html__( 'Normal', 'modus_sc' ) => 'normal',
                        esc_html__( 'Map with Latitude and Longitude', 'modus_sc' ) => 'other'
                    ),
                    'description' => esc_html__( 'Select type map.', 'modus_sc' ),
                ),
                array(
                    "type" => "textarea_html",
                    "holder" => "div",
                    "class" => "",
                    "heading" => esc_html__( "Iframe", "modus" ),
                    "param_name" => "content",
                    "value" => esc_html__( "", "modus" ),
                    "description" => esc_html__( "Enter iframe map google.", "modus" ),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'normal',
                    ),
                ),
                array(
                    "type" => "number",
                    "class" => "",
                    "heading" => esc_html__("Latitude", "modus"),
                    "param_name" => "latitude",
                    "value" => 0,
                    "min" => 0,
                    "suffix" => "",
                    "description" => esc_html__("Enter value latitude.", "modus"),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    "type" => "number",
                    "class" => "",
                    "heading" => esc_html__("Longitude", "modus"),
                    "param_name" => "longitude",
                    "value" => 0,
                    "min" => 0,
                    "suffix" => "",
                    "description" => esc_html__("Enter value longitude.", "modus"),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    "type" => "attach_image",
                    "class" => "",
                    "heading" => esc_html__("Image",  "modus"),
                    "param_name" => "image",
                    "value" => "",
                    "description" => esc_html__("Image marker.",  "modus"),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    "heading" => esc_html__("Name",  "modus"),
                    "param_name" => "name",
                    "value" => "",
                    "description" => esc_html__("Name map .", "modus"),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    "type" => "textfield",
                    "holder" => "div",
                    "class" => "",
                    "heading" => esc_html__( "Description", "modus" ),
                    "param_name" => "content2",
                    "value" => esc_html__( "", "modus" ),
                    "description" => esc_html__( "Enter your content.", "modus" ),
                    'dependency' => array(
                        'element' => 'google_map',
                        'value' => 'other',
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                    'param_name' => 'el_class',
                    'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' )
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                    'param_name' => 'css',
                    'group' => esc_html__( 'Design Options', 'modus_sc' ),
                ),
            )
        )
    );
}
