<?php
add_action('vc_build_admin_page', 'modus_shortcode_list_category');
add_action( 'vc_before_init', 'modus_shortcode_list_category' );

function modus_shortcode_list_category() {
    $layout = array( esc_html__( 'Select category', 'modus_sc' ) => '' );
    $link_cats = get_terms( 'product_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $layout[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        'name' => esc_html__( '[Modus] List Category', 'modus_sc' ),
        'base' => 'modus_list_category',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'List category', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'modus_sc' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter icon, title and color.', 'modus_sc' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'title' => esc_html__( 'Title 1', 'modus_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Title 2', 'modus_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Title 3', 'modus_sc' ),
                    ),
                ) ) ),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'modus_sc' ),
                        'param_name' => 'title',
                        'description' => esc_html__( 'Title item if you do not want to show name category.', 'modus_sc' ),
                        'admin_label' => true,
                    ),
                    array(
                        "type" => "dropdown",
                        "heading" => esc_html__("Group", 'modus_sc'),
                        "param_name" => "cat_product",
                        "value" => $layout,
                        'description' => esc_html__( 'Select taxonomy layout you would like to use', 'modus_sc' ),
                    ),
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Image', 'modus_sc' ),
                        'param_name' => 'image',
                        'description' => esc_html__( 'Select image from media library, requred size: 585 x 509 pixels.', 'modus_sc' ),
                        'dependency' => array(
                            'element' => 'type',
                            'value'   => 'default'
                        )
                    ),
                    array(
                        "type" => "textarea",
                        "heading" => esc_html__( "Description", 'modus_sc' ),
                        "param_name" => "content",
                        "value" => esc_html__( "", 'modus_sc' ),
                        "description" => esc_html__( "Add description.", 'modus_sc' ),
                    ),
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}