<?php
/**
 * Icon
 */
add_action( 'vc_before_init', 'modus_shortcode_icon' );

function modus_shortcode_icon() {
    vc_map( array(
        "name" => esc_html__( "[Modus] Icon", 'modus_sc' ),
        "base" => "modus_icon",
        "class" => "",
        'icon' => 'modus_vc_icon',
        "category" => 'Modus',
        "description" => esc_html__( 'Advanced design icon','modus_sc' ),
        "params" => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout', 'modus_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Icon Default', 'modus_sc' ) => 'layout1',
                    esc_html__( 'List Icon', 'modus_sc' ) => 'layout2',
                    esc_html__( 'List Icon Type 2', 'modus_sc' ) => 'layout3',
                ),
                'description' => esc_html__( 'Select layout for blog.', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Title slide carousel', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => 'layout1',
                )
            ),
            array(
                "type" => "textarea_html",
                "heading" => esc_html__( "Description", 'modus_sc' ),
                "param_name" => "content",
                "value" => esc_html__( "", 'modus_sc' ),
                "description" => esc_html__( "add content.", 'modus_sc' ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout1')
                ),
            ),
            array(
                "type" => "icon_manager",
                "class" => "",
                "heading" => esc_html__("Select Icon ","ultimate_vc"),
                "param_name" => "icon_font",
                "value" => "",
                "description" => esc_html__("Click and select icon of your choice. If you can't find the one that suits for your purpose","ultimate_vc").", ".__("you can","ultimate_vc")." <a href='admin.php?page=bsf-font-icon-manager' target='_blank'>".__("add new here","ultimate_vc")."</a>.",
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout1')
                ),
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'modus_sc' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter icon, title and color.', 'modus_sc' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'title' => esc_html__( 'Icon 1', 'modus_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Icon 2', 'modus_sc' ),
                    ),
                    array(
                        'title' => esc_html__( 'Icon 3', 'modus_sc' ),
                    ),
                ) ) ),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'modus_sc' ),
                        'param_name' => 'title',
                        'description' => esc_html__( 'Title item if you do not want to show name category.', 'modus_sc' ),
                        'admin_label' => true,
                    ),
                    array(
                        "type" => "textarea",
                        "heading" => esc_html__( "Description", 'modus_sc' ),
                        "param_name" => "content",
                        "value" => esc_html__( "", 'modus_sc' ),
                        "description" => esc_html__( "Add description.", 'modus_sc' ),
                    ),
                    array(
                        "type" => "icon_manager",
                        "class" => "",
                        "heading" => esc_html__("Select Icon ","ultimate_vc"),
                        "param_name" => "icon_font",
                        "value" => "",
                        "description" => esc_html__("Click and select icon of your choice. If you can't find the one that suits for your purpose","ultimate_vc").", ".__("you can","ultimate_vc")." <a href='admin.php?page=bsf-font-icon-manager' target='_blank'>".__("add new here","ultimate_vc")."</a>.",
                    ),
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Icon Image ', 'modus_sc' ),
                        'param_name' => 'image_2',
                        'description' => esc_html__( 'Select image from media library.', 'modus_sc' ),
                    ),
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Image', 'modus_sc' ),
                        'param_name' => 'image',
                        'description' => esc_html__( 'Select image from media library. image will be show background box icon', 'modus_sc' ),
                    ),
					array(
						"type" => "textfield",
						"heading" => esc_html__("Link", 'arrowpress-core'),
						"param_name" => "text_link"           
					),
                ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout2','layout3')
                )
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Column", 'modus_sc'),
                "param_name" => "column",
                "value" => 1,
                'min' => 1,
                'max' => 6,
                "description" => esc_html__("select column layout.", 'modus_sc'),
                'dependency' => array(
                    'element' => 'layout',
                    'value' =>array('layout2','layout3')
                )
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Size', 'modus_sc' ),
                'param_name' => 'size',
                'value' => array_merge( getVcShared( 'sizes' ), array( 'Extra Large' => 'xl' ) ),
                'std' => 'md',
                'description' => esc_html__( 'Icon size.', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Icon alignment', 'modus_sc' ),
                'param_name' => 'align',
                'value' => array(
                    esc_html__( 'Left', 'modus_sc' ) => 'left',
                    esc_html__( 'Right', 'modus_sc' ) => 'right',
                    esc_html__( 'Center', 'modus_sc' ) => 'center',
                ),
                'description' => esc_html__( 'Select icon alignment.', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ));
}