<?php
add_action('vc_build_admin_page', 'modus_shortcode_pagetitle');
add_action( 'vc_before_init', 'modus_shortcode_pagetitle' );

function modus_shortcode_pagetitle() {

    vc_map( array(
        'name' => esc_html__( '[Modus] Heading title', 'modus_sc' ),
        'base' => 'modus_pagetitle',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'Heading title.', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type', 'modus_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Default', 'modus_sc' ) => 'default',
                    esc_html__( 'Heading Title 1', 'modus_sc' ) => 'head-1',
                    esc_html__( 'Heading Title 2', 'modus_sc' ) => 'head-2',
                    esc_html__( 'Heading Title 3', 'modus_sc' ) => 'head-3',
                    esc_html__( 'Heading Title 4', 'modus_sc' ) => 'head-4',
                ),
                'description' => esc_html__( 'Select type for box.', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'param_name' => 'title',
                "holder" => "div",
                "class" => "",
                'heading' => esc_html__( 'Label', 'modus_sc' ),
                'description' => esc_html__( 'Enter text used as widget title.', 'modus_sc' ),
            ),
             array(
                'type' => 'textfield',
                'param_name' => 'sub_title',
                'heading' => esc_html__( 'Sub Title', 'modus_sc' ),
                'description' => esc_html__( 'Enter text used as widget title.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('head-2')
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Size', 'modus_sc' ),
                'param_name' => 'size',
                'value' => array_merge( getVcShared( 'sizes' ), array( 'Extra Large' => 'xl' ) ),
                'std' => 'md',
                'description' => esc_html__( 'Text size.', 'wedding-sc' ),
                 'dependency' => array(
                    'element' => 'layout',
                    'value' => array('default','head-1','head-2','head-3')
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Text align', 'modus_sc' ),
                'param_name' => 'align',
                'value' => array(
                    esc_html__( 'Left', 'modus_sc' ) => 'left',
                    esc_html__( 'Center', 'modus_sc' ) => 'center',
                    esc_html__( 'Right', 'modus_sc' ) => 'right',
                ),
                'description' => esc_html__( 'Select align heading title.', 'modus_sc' ),
            ),
            array(
                "type" => "textarea_html",
                "heading" => esc_html__( "Description", "modus" ),
                "param_name" => "content",
                "value" => esc_html__( "", "modus" ),
                "description" => esc_html__( "Enter your content.", "modus" )
            ),
            array(
                "type" => "ult_switch",
                "heading" => esc_html__( "Show line bellow description title", "modus_sc" ),
                "param_name" => "show_line",
                'value' => '',
                'options' => array(
                    'enable_show_line' => array(
                        'label' => '',
                        'on' => esc_html__('Yes','ultimate_vc'),
                        'off' => esc_html__('No','ultimate_vc')
                    )
                ),
                'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
                'description' =>esc_html__( 'if enable, show line bellow description title.','modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}