<?php
add_action('vc_build_admin_page', 'modus_shortcode_counter');
add_action( 'vc_before_init', 'modus_shortcode_counter' );

function modus_shortcode_counter() {
    vc_map(
        array(
           "name" => esc_html__("[Modus] Counter",'modus_sc'),
           "base" => "modus_start_counter",
           "class" => "modus_stats_counter",
           "icon" => "modus_vc_icon",
           "category" => 'Modus',
           "description" => esc_html__("Your milestones, achievements, etc.",'modus_sc'),
           "params" => array(
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Layout', 'modus_sc' ),
                    'param_name' => 'layout',
                    'value' => array(
                        esc_html__( 'One Counter', 'modus_sc' ) => 'one-counter',
                        esc_html__( 'List Counter', 'modus_sc' ) => 'list-counter',
                        esc_html__( 'List Counter Style-2', 'modus_sc' ) => 'list-counter-2',
                    ),
                    'description' => esc_html__( 'Select layout.', 'modus_sc' ),
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    "heading" => esc_html__("Title ", 'modus_sc'),
                    "param_name" => "title",
                    "admin_label" => true,
                    "value" => "",
                    "description" => esc_html__("Enter title for stats counter block", 'modus_sc'),
                    'dependency' => array(
                        'element' => 'layout',
                        'value' => 'one-counter'
                    )
                ),
                array(
                    "type" => "icon_manager",
                    "class" => "",
                    "heading" => esc_html__("Select Icon ","ultimate_vc"),
                    "param_name" => "icon_font",
                    "value" => "",
                    "description" => esc_html__("Click and select icon of your choice. If you can't find the one that suits for your purpose","ultimate_vc").", ".__("you can","ultimate_vc")." <a href='admin.php?page=bsf-font-icon-manager' target='_blank'>".__("add new here","ultimate_vc")."</a>.",
                    'dependency' => array(
                        'element' => 'layout',
                        'value' => 'one-counter'
                    )
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    "heading" => esc_html__("Counter Value", 'modus_sc'),
                    "param_name" => "counter_value",
                    "value" => "1250",
                    "description" => esc_html__("Enter number for counter without any special character. You may enter a decimal number. Eg 1250", 'modus_sc'),
                    'dependency' => array(
                        'element' => 'layout',
                        'value' => 'one-counter'
                    )
                ),
                // params group
                array(
                    'type' => 'param_group',
                    'value' => '',
                    'param_name' => 'values',
                    // Note params is mapped inside param-group:
                    'params' => array(
                        array(
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => esc_html__('Enter your title', 'modus_sc'),
                            'param_name' => 'title',
                            "admin_label" => true,
                        ),
                        array(
                            "type" => "icon_manager",
                            "class" => "",
                            "heading" => esc_html__("Select Icon ","ultimate_vc"),
                            "param_name" => "icon_font",
                            "value" => "",
                            "description" => esc_html__("Click and select icon of your choice. If you can't find the one that suits for your purpose","ultimate_vc").", ".__("you can","ultimate_vc")." <a href='admin.php?page=bsf-font-icon-manager' target='_blank'>".__("add new here","ultimate_vc")."</a>.",
                        ),
                        array(
                            'type' => 'attach_image',
                            'heading' => esc_html__( 'Icon Image ', 'modus_sc' ),
                            'param_name' => 'image',
                            'description' => esc_html__( 'Select image from media library.', 'modus_sc' ),
                        ),
                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Counter Value", 'modus_sc'),
                            "param_name" => "counter_value",
                            "value" => "1250",
                            "description" => esc_html__("Enter number for counter without any special character. You may enter a decimal number. Eg 1250", 'modus_sc'),
                        ),
                    ),
                    'dependency' => array(
                        'element' => 'layout',
                        'value' => array(
                            'list-counter',
                            'list-counter-2',
                        ),
                    )
                ),


                array(
                    "type" => "textfield",
                    "class" => "",
                    "heading" => esc_html__("Thousands Separator", 'modus_sc'),
                    "param_name" => "counter_sep",
                    "value" => ",",
                    "description" => esc_html__("Enter character for thousanda separator. e.g. ',' will separate 125000 into 125,000", 'modus_sc')
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    "heading" => esc_html__("Replace Decimal Point With", 'modus_sc'),
                    "param_name" => "counter_decimal",
                    "value" => ".",
                    "description" => esc_html__("Did you enter a decimal number (Eg - 12.76) The decimal point '.' will be replaced with value that you will enter above.", 'modus_sc'),
                ),
                array(
                    "type" => "number",
                    "class" => "",
                    "heading" => esc_html__("Counter rolling time", 'modus_sc'),
                    "param_name" => "speed",
                    "value" => 3,
                    "min" => 1,
                    "max" => 10,
                    "suffix" => "seconds",
                    "description" => esc_html__("How many seconds the counter should roll?", 'modus_sc')
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    "heading" => esc_html__("Extra Class",  'modus_sc'),
                    "param_name" => "el_class",
                    "value" => "",
                    "description" => esc_html__("Add extra class name that will be applied to the icon process, and you can use this class for your customizations.",  'modus_sc'),
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                    'param_name' => 'css',
                    'group' => esc_html__( 'Design Options', 'modus_sc' )
                ),
            ),
        )
    );
}
