<?php
add_action('vc_before_init', 'modus_shortcode_countdown');

function modus_shortcode_countdown(){
    vc_map( array(
      "name" => esc_html__( "[Modus] Countdown", "modus_sc" ),
      "base" => "modus_countdown",
      "icon" => "modus_vc_icon",
      "category" => esc_html__( "Modus", "modus_sc"),
      'description' => 'Modus countdown',
      "params" => array(
        array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => esc_html__( "Title", "modus_sc" ),
        "param_name" => "title",
        "value" => '',
        ),
        array(
            "type" => "datetimepicker",
            "class" => "",
            "heading" => esc_html__("Target Time For Countdown", "modus_sc"),
            "param_name" => "datetime",
            "value" => "",
            "description" => esc_html__("Date and time format (yyyy/mm/dd hh:mm:ss).", "modus_sc"),
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Countdown Timer Depends on", "modus_sc"),
            "param_name" => "ult_tz",
            "value" => array(
                    esc_html__("WordPress Defined Timezone","modus_sc") => "ult-wptz",
                    esc_html__("User System Timezone","modus_sc") => "ult-usrtz",
                ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' )
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'CSS box', 'modus_sc' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design Options', 'modus_sc' ),
        )
      )
    ) );
}