<?php
add_action('vc_build_admin_page', 'modus_shortcode_contactinfo');
add_action( 'vc_before_init', 'modus_shortcode_contactinfo' );

function modus_shortcode_contactinfo() {
    vc_map( array(
        'name' => esc_html__( '[Modus] Contact Info', 'modus_sc' ),
        'base' => 'modus_contactinfo',
        "icon" => "modus_vc_icon",
        'category' => 'Modus',
        'description' => esc_html__( 'Collapsible content panels', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Name title.', 'modus_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Align text heading', 'modus_sc' ),
                'param_name' => 'align_heading',
                'value' => array(
                    esc_html__( 'Left', 'modus_sc' ) => 'text-left',
                    esc_html__( 'Right', 'modus_sc' ) => 'text-right',
                    esc_html__( 'Center', 'modus_sc' ) => 'text-center',
                ),
                'description' => esc_html__( 'Select type align for text heading.', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Address', 'modus_sc' ),
                'param_name' => 'address',
                'description' => esc_html__( 'Enter address.', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Phone', 'modus_sc' ),
                'param_name' => 'phone',
                'description' => esc_html__( 'Enter phone number.', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Email', 'modus_sc' ),
                'param_name' => 'email',
                'description' => esc_html__( 'Enter address email.', 'modus_sc' ),
            ),
            vc_map_add_css_animation(),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        ),
    ) );
}