<?php
add_action('vc_build_admin_page', 'modus_shortcode_client');
add_action( 'vc_before_init', 'modus_shortcode_client' );

function modus_shortcode_client() {
    $layout = array( esc_html__( 'Select category', 'modus_sc' ) => '' );
    $link_cats = get_terms( 'client_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $layout[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        'name' => esc_html__( '[Modus] Client', 'modus_sc' ),
        'base' => 'modus_client',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'List item client', 'modus_sc' ),
        'params' => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Taxonomy Layout", "modus"),
                "param_name" => "taxonomy_layout",
                "value" => $layout,
                'description' => esc_html__( 'Select taxonomy layout you would like to use', 'modus_sc' ),
            ),
            array(
                "type" => "number",
                "class" => "",
                "heading" => esc_html__("Number item", "modus"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "modus"),
            ),
            array(
                'type' => 'number',
                'heading' => esc_html__( 'Column', 'modus_sc' ),
                'param_name' => 'column',
                'value' => 1,
                'min'   => 1,
                'max'   => 6,
            ),
             array(
                'type' => 'number',
                'heading' => esc_html__( 'Row', 'modus_sc' ),
                'param_name' => 'row',
                'value' => 1,
                'min'   => 1,
                'max'   => 6,
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}