<?php
add_action('vc_build_admin_page', 'modus_shortcode_advanced_image');
add_action( 'vc_before_init', 'modus_shortcode_advanced_image' );

function modus_shortcode_advanced_image() {
    vc_map( array(
        'name' => esc_html__( '[Modus] Advanced Box', 'modus_sc' ),
        'base' => 'modus_box',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'modus advanced with images is background for box', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout Box', 'modus_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Box with Banner', 'modus_sc' ) => 'layout1',
                    esc_html__( 'Box with Banner Background', 'modus_sc' ) => 'layout2',
                    esc_html__( 'Box badges', 'modus_sc' ) => 'layout4',
                    esc_html__( 'Box Text', 'modus_sc' ) => 'layout3',
                ),
                'description' => esc_html__( 'Select type for box.', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type', 'modus_sc' ),
                'param_name' => 'type',
                'value' => array(
                    esc_html__( 'Type 1', 'modus_sc' ) => 'style1',
                    esc_html__( 'Type 2', 'modus_sc' ) => 'style2',
                    esc_html__( 'Type 3', 'modus_sc' ) => 'style3', 
                    esc_html__( 'Type 4', 'modus_sc' ) => 'style4', 
                ),
                'description' => esc_html__( 'Select type for box.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout1','layout3')
                )
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                  "holder" => "div",
                   "class" => "",
                'param_name' => 'title',
                'description' => esc_html__( '', 'modus_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Sub Title', 'modus_sc' ),
                 "holder" => "div",
                  "class" => "",
                'param_name' => 'sub_title',
                'description' => esc_html__( '', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout1','layout2','layout4')
                )
            ), 
            array(
                "type" => "textarea_html",
                "heading" => esc_html__( "Description", 'modus_sc' ),
                "param_name" => "content",
                "value" => esc_html__( "", 'modus_sc' ),
                "description" => esc_html__( "add content.", 'modus_sc' ),
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout1','layout2','layout3')
                )
            ), 
            array(
                "type" => "textfield",
                "heading" => esc_html__( "Badges line 1", 'modus_sc' ),
                "param_name" => "badges_ct1",
                "value" => esc_html__( "", 'modus_sc' ), 
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout4')
                )
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__( "Badges line 2", 'modus_sc' ),
                "param_name" => "badges_ct2",
                "value" => esc_html__( "", 'modus_sc' ), 
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout4')
                )
            ),
            array(
                'type' => 'attach_image',
                'heading' => esc_html__( 'Image', 'modus_sc' ),
                'param_name' => 'image',
                'description' => esc_html__( 'Select image from media library.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout1','layout2','layout4')
                )
            ),
            array(
                'type' => 'vc_link',
                'heading' => esc_html__( 'URL (Link)', 'modus_sc' ),
                'param_name' => 'link',
                'description' => esc_html__( 'Add link to button..', 'modus_sc' ),
            ),
			array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Button link', 'modus_sc' ),
                'param_name' => 'bt_link_show',
                'value' => array(
                    esc_html__( 'Show Button', 'modus_sc' ) => 'show',
                    esc_html__( 'Hidden Button', 'modus_sc' ) => 'hidden', 
                ), 
				'dependency' => array(
                    'element' => 'type',
                    'value' => array('style2')
                )
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}