<?php
/**
 * Latest project
 */

add_action( 'vc_before_init', 'modus_shortcode_blog' );
function modus_shortcode_blog(){
    $link_category = array( esc_html__( 'Select...', 'modus_sc' ) => '' );
    $link_cats = get_terms( 'post_layout' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $link_category[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        "name" => esc_html__( "[Modus] Blog", 'modus_sc' ),
        "base" => "modus_blog",
        "icon" => "modus_vc_icon",
        "category" => "Modus",
        "description" => esc_html__( 'List item blog','modus_sc' ),
        "params" => array(
            array(
                'type' => 'textfield',
                'param_name' => 'title',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'modus_sc' ),
            ),
			array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout', 'modus_sc' ),
                'param_name' => 'layout_blog',
                'value' => array(
                    esc_html__( 'Layout Blog List', 'modus_sc' ) => 'list',
                    esc_html__( 'Layout Blog Slide', 'modus_sc' ) => 'slide',
                ),
                'description' => esc_html__( 'Select layout for blog.', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type List Style', 'modus_sc' ),
                'param_name' => 'type_list',
                'value' => array(
                    esc_html__( 'Type 1', 'modus_sc' ) => 'type1',
                    esc_html__( 'Type 2', 'modus_sc' ) => 'type2',
                    esc_html__( 'Type 3', 'modus_sc' ) => 'type3',
                    esc_html__( 'Type 4', 'modus_sc' ) => 'type4',
                    esc_html__( 'Type 5', 'modus_sc' ) => 'type5',
                    esc_html__( 'Type 6', 'modus_sc' ) => 'type6',
                    esc_html__( 'Type 7', 'modus_sc' ) => 'type7',
                    esc_html__( 'Type 8', 'modus_sc' ) => 'type8',
                    esc_html__( 'Type 9', 'modus_sc' ) => 'type9',
                    esc_html__( 'Type 10', 'modus_sc' ) => 'type10',
                    esc_html__( 'Type 11', 'modus_sc' ) => 'type11',
                ),
                'description' => esc_html__( 'Select type style for layout list.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'layout_blog',
                    'value' => 'list',
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Group", 'modus_sc'),
                "param_name" => "category",
                "value" => $link_category,
                'description' => esc_html__( 'Select group would like to use', 'modus_sc' ),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Button Text", 'modus_sc'),
                'value' => esc_html__('See More','modus_sc'),
                "param_name" => "button_text",              
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Button Link", 'modus_sc'),
                "param_name" => "button_link",              
            ),  
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", 'modus_sc'),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", 'modus_sc'),
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Slide Column", 'modus_sc'),
                "param_name" => "columns",
                "value" => 2,
                'min' => 1,
                'max' => 5,
                "description" => esc_html__("select column item on slide.", 'modus_sc'),
                'dependency' => array(
                    'element' => 'layout_blog',
                    'value' => array('slide','grid')
                )
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Slide Row(s)", 'modus_sc'),
                "param_name" => "rows",
                "value" => 1,
                'min' => 1,
                'max' => 5,
                "description" => esc_html__("select number row slide.", 'modus_sc'),
                'dependency' => array(
                    'element' => 'layout_blog',
                    'value' => 'slide',
                )
            ),
            array(
                'type' => 'number',
                'heading' => esc_html__( 'Column', 'modus_sc' ),
                'param_name' => 'column',
                'value' => 1,
                'min'   => 1,
                'max'   => 4,
                'dependency' => array(
                    'element' => 'type_list',
                    'value' => array('type5','type6','type7','type8','type9','type10','type11')
                ),
                'description' => esc_html__( 'Layout column item blog.', 'modus_sc' ),
            ),
            array(
                "type" => "ult_switch",
                "heading" => esc_html__( "Show View More Button", "modus_sc" ),
                "param_name" => "show_viewmore",
                'value' => '',
                'options' => array(
                    'enable_show_viewmore' => array(
                        'label' => '',
                        'on' => esc_html__('Yes','ultimate_vc'),
                        'off' => esc_html__('No','ultimate_vc')
                    )
                ),
                'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
                'description' =>esc_html__( 'if enable, show button more item ajax.','modus_sc' ),
                'dependency' => array(
                    'element' => 'layout_blog',
                    'value' => array('list'),
                )
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' )
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','modus_sc'),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','modus_sc' ),
            )

        ),
    ));
}