<?php
/*
Plugin Name: Modus Shortcodes
Plugin URI:
Description: Shortcodes for modus Theme.
Version: 1.0
Author: AHT
Author URI:
Text Domain: modus_sc
*/

// don't load directly
if (!defined('ABSPATH'))
    die('-1');

define('MODUS_SHORTCODES_URL', plugin_dir_url(__FILE__));
define('MODUS_SHORTCODES_PATH', dirname(__FILE__) . '/shortcodes/');
define('MODUS_SHORTCODES_LIB', dirname(__FILE__) . '/lib/');
define('MODUS_SHORTCODES_TEMPLATES', dirname(__FILE__) . '/templates/');


add_action( 'vc_after_init', 'add_button_super_color' );
function add_button_super_color() {
  $param = WPBMap::getParam( 'vc_btn', 'color' );
  $param['value'][esc_html__( 'Default color', 'modus_sc' )] = 'default';
  vc_update_shortcode_param( 'vc_btn', $param );
}

class ModusShortcodesClass {
    private $shortcodes = array('modus_icon','modus_product_tabs','modus_headingtitle','modus_countdown','modus_client','modus_testimonial','modus_blog','modus_product','modus_map','modus_contactinfo','modus_counter','modus_team','modus_box','modus_list_category','modus_product_single_image','modus_social','modus_services','modus_timeline','modus_product_single','modus_portfolio_tab','modus_menu_item','modus_product_masonry','modus_portfolio');
    function __construct() {

        // Load text domain
        add_action( 'plugins_loaded', array( $this, 'loadTextDomain' ) );

        // Init plugins
        add_action( 'init', array( $this, 'initPlugin' ) );

        $this->addShortcodes();

        add_filter( 'the_content', array( $this, 'formatShortcodes' ) );
        add_filter( 'widget_text', array( $this, 'formatShortcodes' ) );
		add_filter( 'load_textdomain_mofile', array( $this, 'overload_textdomain_mofile' ), 10, 2 );
    }

    // Init plugins
    function initPlugin() {
        $this->addTinyMCEButtons();
    }
	function overload_textdomain_mofile( $mofile, $domain ) {
		if ( 'modus_sc' === $domain && ! file_exists($mofile)) {
			$mofile = WP_LANG_DIR . '/plugins/modus_sc-' . get_locale() . '.mo';
		}
		return $mofile;
	}
    // load plugin text domain
    function loadTextDomain() {
        load_plugin_textdomain( 'modus_sc', false, dirname( __FILE__ ) . '/languages/' );
    }

    // Add buttons to tinyMCE
    function addTinyMCEButtons() {
        if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
            return;

        if ( get_user_option('rich_editing') == 'true' ) {
            add_filter( 'mce_buttons', array(&$this, 'registerTinyMCEButtons') );
        }
    }

    function registerTinyMCEButtons($buttons) {
        array_push($buttons, "modus_shortcodes_button");
        return $buttons;
    }

    // Add shortcodes
    function addShortcodes() {
        require_once(MODUS_SHORTCODES_LIB . 'functions.php');
        require_once(MODUS_SHORTCODES_PATH . 'modus_params.php');
        require_once(MODUS_SHORTCODES_PATH . 'modus_static_block.php');
        require_once(MODUS_SHORTCODES_TEMPLATES . 'modus_compare.php');
        foreach ($this->shortcodes as $shortcode) {
            require_once(MODUS_SHORTCODES_PATH . $shortcode . '.php');
            require_once(MODUS_SHORTCODES_TEMPLATES . $shortcode . '.php');
        }
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
    }

    // Format shortcodes content
    function formatShortcodes($content) {
        $block = join("|", $this->shortcodes);
        // opening tag
        $content = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]", $content);
        // closing tag
        $content = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)/","[/$2]", $content);

        return $content;
    }

}

// Finally initialize code
new ModusShortcodesClass();