(function($){
    "use strict";
    var portfolio_metabox = {
        initialized: false,
        container: null,
        child_box: null,
        imgPreviews: null,

        init: function() {
            if ( this.initialized ) return;
            this.initialized = true;
            this.container = $('#portfolio-metabox-content');
            this.child_box = $('.portfolio-metabox-child');
            this.imgPreviews = $('#portfolio-metabox-content ul.images-list').first();
            this.portfolio_metabox_gallery();
            this.image_upload();
        },
        //-- Manage image gallery portfolio
        portfolio_metabox_gallery: function() {
            var self = this;

            $('#portfolio-metabox-content').on('click', 'a.button.add-images', function(e){
                e.preventDefault();
                var _imgPreviews = $(this).closest('.portfolio-metabox-child').find('ul.images-list');
                if ( self.imgSelectFrame ) self.imgSelectFrame.close();

                self.imgSelectFrame = wp.media.frames.imgSelectFrame = wp.media({
                    title: $(this).data('uploader-title'),
                    button: {
                        text: $(this).data('uploader-button-text'),
                    },
                    multiple: true
                });

                self.imgSelectFrame.on('select', function() {
                    var listIndex = _imgPreviews.children('li:last').index(),
                        selection = self.imgSelectFrame.state().get('selection');

                    selection.map(function(attachment, i) {
                        attachment = attachment.toJSON();

                        if ( 'undefined' == typeof attachment.sizes ) {
                            alert( "Not supported type" );
                            return;
                        }
                        var index                   = listIndex + (i + 1),
                            attachmentThumbnailObj  = attachment.sizes.thumbnail;

                        if ( attachmentThumbnailObj == undefined ) {
                            attachmentThumbnailObj = attachment.sizes.full;
                        }
                        _imgPreviews.append('<li>'
                            + '<input type="hidden" name="portfolio_gallery_id[' + index + ']" value="' + attachment.id + '"/>'
                            + '<img class="image-preview" src="' + attachmentThumbnailObj.url + '"/>'
                            + '<a class="change-image" href="#" data-uploader-title="Change image" data-uploader-button-text="Change image"><i class="dashicons dashicons-edit"></i></a>'
                            + '<a class="remove-image" href="#"><i class="dashicons dashicons-no"></i></a>'
                        + '</li>');
                    });
                });

                self.make_sortable();

                self.imgSelectFrame.open();
            });
            $('#portfolio-metabox-content').on('click', 'a.change-image', function(e) {
                e.preventDefault();

                var _this = $(this);

                if ( self.imgSelectFrame ) self.imgSelectFrame.close();

                self.imgSelectFrame = wp.media.frames.imgSelectFrame = wp.media({
                    title: $(this).data('uploader-title'),
                    button: {
                        text: $(this).data('uploader-button-text'),
                    },
                    multiple: false
                });

                self.imgSelectFrame.on( 'select', function() {
                    var attachment              = self.imgSelectFrame.state().get('selection').first().toJSON(),
                        attachmentThumbnailObj  = attachment.sizes.thumbnail;

                    if ( attachmentThumbnailObj == undefined ) {
                        attachmentThumbnailObj = attachment.sizes.full;
                    }

                    var selection = self.imgSelectFrame.state().get('selection');

                    _this.parent().find('input:hidden').attr('value', attachment.id);
                    _this.parent().find('img.image-preview').attr('src', attachmentThumbnailObj.url);
                });

                self.imgSelectFrame.on( 'open', function(){
                    var selected = wp.media.attachment( _this.parent().find('input:hidden').attr('value') );
                    var selection = self.imgSelectFrame.state().get('selection');
                    selection.add( selected ? [selected] : [] );
                });

                self.imgSelectFrame.open();

            });
            $('#portfolio-metabox-content').on('click', 'a.remove-image', function(e) {
                e.preventDefault();

                $(this).parents('li').animate({ opacity: 0 }, 200, function() {
                    $(this).remove();
                    self.reset_index();
                });
            });

        },
        //-- Reset index after sort
        reset_index: function() {
            this.imgPreviews.children('li').each(function(i) {
                $(this).find('input:hidden').attr('name', 'portfolio_gallery_id[' + i + ']');
            });
        },

        //-- Make image gallery sortable
        make_sortable: function() {
            this.imgPreviews.sortable({
                opacity: 0.6,
                stop: function() {
                    self.reset_index();
                }
            });
        },
        //-- Image upload
        image_upload: function() {

        }
    };

    $(document).ready(function(){
        portfolio_metabox.init();
        portfolio_metabox.make_sortable();
    });
})(jQuery);