<?php
/*
  Plugin Name: Modus Post Types
  Plugin URI:
  Description: Register Post Types for Modus Theme.
  Version: 1.0.0
  Author: AHT
  Author URI:
  Text Domain: modus-pt
 */
function modus_sidebars()
{
    global $wp_registered_sidebars;

    $sidebar_options = array();
    $sidebar_options['default'] = esc_html__('Default sidebar', 'modus-pt');
    if (!empty($wp_registered_sidebars)) {
        foreach ($wp_registered_sidebars as $sidebar) {
            $sidebar_options[$sidebar['id']] = $sidebar['name'];
        }
    }
    return $sidebar_options;
}

function modus_default_meta_data() {
    $modus_custom_css = modus_custom_css();

    $modus_sidebar_position = array(
        'default' => esc_html__('Default Position', 'modus-pt'),
        'left-sidebar' => esc_html__('Left', 'modus-pt'),
        'right-sidebar' => esc_html__('Right', 'modus-pt'),
        'none' => esc_html__('None', 'modus-pt')
    );
    $modus_sidebars = modus_sidebars();
    $modus_skin = array('awesome', 'bleu-de-france','bleu-de-france2','bleu-de-france3', 'light-taupe',   'orange', 'pastel-red', 'orange-2', 'orange-3' ,'granite-color');
    $modus_background = array();
    $modus_background['white'] = 'White';
    $modus_background['dark'] = 'Dark';
    $modus_background['black'] = 'Black';
    if(get_terms( 'nav_menu', array( 'hide_empty' => true ) )):
        $menus =  get_terms('nav_menu');
        foreach ( $menus as $menu ) {
            $modus_menu[$menu -> slug]= $menu -> name;
        }
    endif;
    return array(
        'page_fullwidth' => array(
            'name' => 'page_fullwidth',
            'title' => esc_html__('Full Width', 'modus-pt'),
            'desc' => esc_html__('Page Full Width', 'modus-pt'),
            'type' => 'checkbox'
        ),
        'page_background' => array(
            'name' => 'page_background',
            'title' => esc_html__('Background page', 'modus-pt'),
            'desc' => esc_html__('Background page', 'modus-pt'),
            'type' => 'select',
            'options' => array('white'=>'White','grey'=>'Grey'),
            'default' => 'white'
        ),
        'special_skin' => array(
            'name' => 'special_skin',
            'title' => esc_html__('Special Skin', 'modus-pt'),
            'desc' => esc_html__('Select Skin for this page', 'modus-pt'),
            'type' => 'checkbox'
        ),
        'skin' => array(
            'name' => 'skin',
            'title' => esc_html__('Skin', 'modus-pt'),
            'desc' => esc_html__('Select Skin', 'modus-pt'),
            'type' => 'skin',
            'default'=> 'awesome',
            'options'=> $modus_skin
        ),
        'show_breadcrumb' => array(
            'name' => 'show_breadcrumb',
            'title' => esc_html__('Breadcrumb', 'modus-pt'),
            'desc' => esc_html__('Show or Hide breadcrumb', 'modus-pt'),
            'type' => 'select',
            'options' => array('default' => 'Default','show' =>'Show Breadcrumb','hide' =>'Hide Breadcrumb'),
            'default'=> 'default',
        ),
        "breadcrumbs_bg"=> array(
            "name" => "breadcrumbs_bg",
            "title" => esc_html__("Breadcrumbs Background", 'modus-pt'),
            'desc' => esc_html__("Upload breadcrumbs background", 'modus-pt'),
            "type" => "upload"
        ),
        'show_title_page' => array(
            'name' => 'show_title_page',
            'title' => esc_html__('Title', 'modus-pt'),
            'desc' => esc_html__('Show or Hide Title', 'modus-pt'),
            'type' => 'select',
            'options' => array('show' =>'Show title','hide' =>'Hide title'),
            'default'=> 'show',
        ),
        'header_fixed' => array(
            'name' => 'header_fixed',
            'title' => esc_html__('Header fixed', 'modus-pt'),
            'desc' => esc_html__('Header fixed when scroll', 'modus-pt'),
            'type' => 'checkbox'
        ),
        'header_over' => array(
            'name' => 'header_over',
            'title' => esc_html__('Header over', 'modus-pt'),
            'desc' => esc_html__('Header over when scroll', 'modus-pt'),
            'type' => 'checkbox'
        ),
        'hidden_header' => array(
            'name' => 'hidden_header',
            'title' => esc_html__('Hidden header', 'modus-pt'),
            'desc' => esc_html__('Hidden header page', 'modus-pt'),
            'type' => 'checkbox'
        ),
        'hidden_footer' => array(
            'name' => 'hidden_footer',
            'title' => esc_html__('Hidden footer', 'modus-pt'),
            'desc' => esc_html__('Hidden footer page', 'modus-pt'),
            'type' => 'checkbox'
        ),
        'no_padding_top' => array(
            'name' => 'no_padding_top',
            'title' => esc_html__('No Padding Top', 'modus-pt'),
            'desc' => esc_html__('No Padding Top Default', 'modus-pt'),
            'type' => 'checkbox'
        ),
        'no_padding_bottom' => array(
            'name' => 'no_padding_bottom',
            'title' => esc_html__('No Padding Bottom', 'modus-pt'),
            'desc' => esc_html__('No Padding Bottom Default', 'modus-pt'),
            'type' => 'checkbox'
        ),
        'content_width' => array(
            'name' => 'content_width',
            'title' => esc_html__('Content width', 'modus-pt'),
            'desc' => esc_html__('Content full container', 'modus-pt'),
            'type' => 'checkbox'
        ),
        'is_home_page' => array(
            'name' => 'is_home_page',
            'title' => esc_html__('Is Home Page', 'modus-pt'),
            'desc' => esc_html__('Select if this is home page', 'modus-pt'),
            'type' => 'checkbox'
        ),
        //sidebar position
        'sidebar_position' => array(
            'name' => 'sidebar_position',
            'type' => 'select',
            'title' => esc_html__('Sidebar Position', 'modus-pt'),
            'options' => $modus_sidebar_position,
            'default' => 'default'
        ),
        //sidebar
        'sidebar' => array(
            'name' => 'sidebar',
            'type' => 'select',
            'title' => esc_html__('Sidebar', 'modus-pt'),
            'options' => $modus_sidebars,
            'default' => 'default'
        ),
    );
}

// don't load directly
if (!defined('ABSPATH'))
    die('-1');
define('MODUS_URL', plugin_dir_url(__FILE__));

// Display Fields
add_action( 'woocommerce_product_options_general_product_data', 'modus_woo_add_custom_general_fields' );

// Save Fields
add_action( 'woocommerce_process_product_meta', 'modus_woo_add_custom_general_fields_save' );
function modus_woo_add_custom_general_fields() {

  global $woocommerce, $post;
  echo '<div class="options_group">';  
    woocommerce_wp_text_input( 
        array( 
            'id'          => '_unit_price', 
            'label'       => esc_html__( 'Unit Price', 'modus-pt' ),
            'placeholder' => esc_html__('Enter Unit Price','modus-pt'),
            'desc_tip'    => 'true',
        )
    );  
  echo '</div>';
    
}
function modus_woo_add_custom_general_fields_save( $post_id ){   
    // Text Field
    $woocommerce_text_field = $_POST['_unit_price'];
    if( !empty( $woocommerce_text_field ) )
        update_post_meta( $post_id, '_unit_price', esc_attr( $woocommerce_text_field ) );   
}
// Add Metabox
add_action( 'add_meta_boxes', 'modus_add_meta_box' );
if ( ! function_exists( 'modus_add_meta_box' ) ) {
	/**
	 * Add meta box to page screen
	 *
	 * This function handles the addition of variuos meta boxes to your page or post screens.
	 * You can add as many meta boxes as you want, but as a rule of thumb it's better to add
	 * only what you need. If you can logically fit everything in a single metabox then add
	 * it in a single meta box, rather than putting each control in a separate meta box.
	 *
	 * @since 1.0.0
	 */
	function modus_add_meta_box() {
		add_meta_box( 'additional-page-metabox-options', esc_html__( 'Layout Options', 'modus-pt' ), 'modus_metabox_controls', 'page', 'side', 'low' );
		add_meta_box( 'view-header-boxes', esc_html__( 'Header Footer Options', 'modus-pt' ), 'modus_metabox_header_footer', 'page', 'normal', 'low' );
		add_meta_box( 'view-post-boxes', esc_html__( 'Post Options', 'modus-pt' ), 'modus_metabox_post', 'post', 'normal', 'low' );
		add_meta_box( 'view-portfolio-boxes', esc_html__( 'Portfolio Options', 'modus-pt' ), 'modus_metabox_portfolio', 'portfolio', 'normal', 'low' );
		add_meta_box( 'view-product-boxes', esc_html__( 'Product Options', 'modus-pt' ), 'modus_metabox_product', 'product', 'normal', 'low' );
	}
}

/* Product Option */
if ( ! function_exists( 'modus_metabox_product' ) ) {
	function modus_metabox_product( $post ) {
		$meta = get_post_meta( $post->ID );
		wp_nonce_field( 'modus_product_meta_box', 'modus_product_meta_box_nonce' ); // Always add nonce to your meta boxes!
        $product_column_width = (isset($meta['product_column_width'][0]) && '1' === $meta['product_column_width'][0]) ? 1 : 0;
        $banner_link_title = ( isset( $meta['banner_link_title'][0] ) && '' !== $meta['banner_link_title'][0] ) ? $meta['banner_link_title'][0] : '';
        $banner_link_url = ( isset( $meta['banner_link_url'][0] ) && '' !== $meta['banner_link_url'][0] ) ? $meta['banner_link_url'][0] : '';
		?>
		<div class="modus_option_product" id="product-metabox">
			<div class="product-metabox-child product-metabox-link" data-product-format="link">
				<p><label for="product_column_width"><strong><?php esc_html_e( 'Width column masonry', 'modus-pt' ); ?></strong></label></p>
				<p><label><?php esc_html_e( 'Width 2x column: ', 'modus-pt' ); ?></label><input type="checkbox" name="product_column_width" class="widefat" value="1" <?php checked($product_column_width, 1); ?>/>
				</p>
                <p><label for="banner_link_title"><strong><?php esc_html_e( 'Add title Banner', 'modus-pt' ); ?></strong></label></p>
                <p><input type="text" name="banner_link_title" class="widefat" value="<?php echo esc_attr( $banner_link_title ); ?>"/>
                </p>
                <p><label for="banner_link_url"><strong><?php esc_html_e( 'Add url Banner', 'modus-pt' ); ?></strong></label></p>
                <p><input type="text" name="banner_link_url" class="widefat" value="<?php echo esc_url($banner_link_url); ?>"/></p>
			</div>
		</div>
		<?php
	}
}
add_action( 'save_post', 'modus_save_product_metaboxes' );
 
if ( ! function_exists( 'modus_save_product_metaboxes' ) ) {
	/**
	 * Save controls from the meta boxes
	 *
	 * @param  int $post_id Current post id.
	 * @since 1.0.0
	 */
	function modus_save_product_metaboxes( $post_id ) {
		/*
		 * We need to verify this came from the our screen and with proper authorization,
		 * because save_post can be triggered at other times. Add as many nonces, as you
		 * have metaboxes.
		 */
		if ( ! isset( $_POST['modus_product_meta_box_nonce'] ) || ! wp_verify_nonce( sanitize_key( $_POST['modus_product_meta_box_nonce'] ), 'modus_product_meta_box' ) ) { // Input var okay.
			return $post_id;
		}
 
		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'product' === $_POST['post_type'] ) { // Input var okay.
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return $post_id;
			}
		}
 
		/*
		 * If this is an autosave, our form has not been submitted,
		 * so we don't want to do anything.
		 */
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}
		 $product_column_width = (isset($_POST['product_column_width']) && '1' === $_POST['product_column_width']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'product_column_width', esc_attr($product_column_width));
        if ( isset( $_POST['banner_link_title'] )){
            $value = sanitize_text_field( $_POST['banner_link_title'] );
            update_post_meta( $post_id, 'banner_link_title', $value );
        }
        if ( isset( $_POST['banner_link_url'] )){
            $value = sanitize_text_field( $_POST['banner_link_url'] );
            update_post_meta( $post_id, 'banner_link_url', $value );
        }
	}
}

/* Portfolio Option */
if ( ! function_exists( 'modus_metabox_portfolio' ) ) {
	function modus_metabox_portfolio( $post ) {
		$meta = get_post_meta( $post->ID );
		$portfolio_gallery_id = ( isset( $meta['portfolio_gallery_id'][0] ) && '' !== $meta['portfolio_gallery_id'][0] ) ? $meta['portfolio_gallery_id'][0] : '';
		wp_nonce_field( 'modus_portfolio_meta_box', 'modus_portfolio_meta_box_nonce' ); // Always add nonce to your meta boxes!
		
		?>
		<div class="modus_option_post" id="portfolio-metabox-content">
			<div class="portfolio-metabox-child portfolio-metabox-gallery">
				<a href="#" class="button add-images" title="<?php esc_attr_e( 'Add image(s)','modus-pt'); ?>" data-uploader-tittle="<?php esc_attr_e( 'Add image (s)','modus-pt'); ?>" data-uploader-button-text="<?php esc_attr_e( 'Add image(s)','modus-pt'); ?>"><?php esc_attr_e( 'Add image (s)','modus-pt'); ?></a>
				<ul class="images-list">
					<?php
					$portfolio_gallery_id = get_post_meta($post->ID, 'portfolio_gallery_id', true);
					$portfolio_gallery_id = explode (',',$portfolio_gallery_id);
					if ( is_array($portfolio_gallery_id) && count($portfolio_gallery_id) > 0 && $portfolio_gallery_id[0] != '' ):
						foreach( $portfolio_gallery_id as $key => $value ) :
							$image = wp_get_attachment_image_src( (int)$value ); ?>
							<li>
								<input type="hidden" name="portfolio_gallery_id[<?php echo esc_attr($key); ?>]" value="<?php echo esc_attr( $value ); ?>"/>
								<img class="image-preview" src="<?php echo esc_url( $image[0] ); ?>"/>
								<a href="#" class="change-image"
									title="<?php esc_attr_e( 'Change image', 'modus-pt' ); ?>"
									data-uploader-title="<?php esc_attr_e( 'Change image', 'modus-pt' ); ?>"
									data-uploader-button-text="<?php esc_attr_e( 'Change image', 'modus-pt' ); ?>"><i class="dashicons dashicons-edit"></i></a>
								<a href="#" class="remove-image" title="<?php esc_attr_e( 'Remove Image', 'modus-pt' ); ?>"><i class="dashicons dashicons-no"></i></a>
							</li>
							<?php
						endforeach;
					endif; ?>
				</ul>
			</div>
		</div>
		<?php
	}
	function modus_meta_portfolio_assets(){
		if ( isset( $GLOBALS['post_type'] ) && in_array( $GLOBALS['post_type'], array('portfolio') ) ) {
			wp_enqueue_script( 'jquery-ui-core',  MODUS_URL . 'metaboxes/js/jquery-ui.min.js', array( 'jquery' ), '', true );
			wp_enqueue_script( 'modus-metabox-page',  MODUS_URL . 'metaboxes/js/metabox.js', array( ), '1.0');
			wp_enqueue_script( 'modus-page-metabox',  MODUS_URL . 'metaboxes/js/portfolio.metabox.js', array( ), '1.0');
			wp_enqueue_style("modus-page-metabox-style",  MODUS_URL .'metaboxes/css/metabox.css', array(), '1.0');
			wp_enqueue_script( 'jquery-iris',  MODUS_URL . 'metaboxes/js/iris.min.js', array( ), '', true );
		}
	}
}
add_action('admin_enqueue_scripts', 'modus_meta_portfolio_assets' );
add_action( 'save_post', 'modus_save_portfolio_metaboxes' );
 
if ( ! function_exists( 'modus_save_portfolio_metaboxes' ) ) {
	/**
	 * Save controls from the meta boxes
	 *
	 * @param  int $post_id Current post id.
	 * @since 1.0.0
	 */
	function modus_save_portfolio_metaboxes( $post_id ) {
		/*
		 * We need to verify this came from the our screen and with proper authorization,
		 * because save_post can be triggered at other times. Add as many nonces, as you
		 * have metaboxes.
		 */
		if ( ! isset( $_POST['modus_portfolio_meta_box_nonce'] ) || ! wp_verify_nonce( sanitize_key( $_POST['modus_portfolio_meta_box_nonce'] ), 'modus_portfolio_meta_box' ) ) { // Input var okay.
			return $post_id;
		}
 
		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'portfolio' === $_POST['post_type'] ) { // Input var okay.
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return $post_id;
			}
		}
 
		/*
		 * If this is an autosave, our form has not been submitted,
		 * so we don't want to do anything.
		 */
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}
		
		if ( isset( $_POST['portfolio_gallery_id'] ) && is_array($_POST['portfolio_gallery_id']) ) {
			update_post_meta( $post_id, 'portfolio_gallery_id', implode(',', $_POST['portfolio_gallery_id'] )); // Input var okay.
		}
	}
}

/* Post Option */
if ( ! function_exists( 'modus_metabox_post' ) ) {
	function modus_metabox_post( $post ) {
		$meta = get_post_meta( $post->ID );
		$post_link_title = ( isset( $meta['post_link_title'][0] ) && '' !== $meta['post_link_title'][0] ) ? $meta['post_link_title'][0] : '';
		$post_link_url = ( isset( $meta['post_link_url'][0] ) && '' !== $meta['post_link_url'][0] ) ? $meta['post_link_url'][0] : '';
		$post_quote_content = ( isset( $meta['post_quote_content'][0] ) && '' !== $meta['post_quote_content'][0] ) ? $meta['post_quote_content'][0] : '';
		$post_quote_by = ( isset( $meta['post_quote_by'][0] ) && '' !== $meta['post_quote_by'][0] ) ? $meta['post_quote_by'][0] : '';
		$post_video_url = ( isset( $meta['post_video_url'][0] ) && '' !== $meta['post_video_url'][0] ) ? $meta['post_video_url'][0] : '';
		$post_audio_url = ( isset( $meta['post_audio_url'][0] ) && '' !== $meta['post_audio_url'][0] ) ? $meta['post_audio_url'][0] : '';
		$post_gallery_id = ( isset( $meta['post_gallery_id'][0] ) && '' !== $meta['post_gallery_id'][0] ) ? $meta['post_gallery_id'][0] : '';
		wp_nonce_field( 'modus_post_meta_box', 'modus_post_meta_box_nonce' ); // Always add nonce to your meta boxes!
		
		?>
		<div class="modus_option_post" id="post-metabox">
			<label><strong><?php esc_html_e( 'Post Options', 'modus-pt');?></strong></label>
			<!-- Add link -->
			<div class="post-metabox-child post-metabox-link" data-post-format="link">
				<p><label for="post_link_title"><strong><?php esc_html_e( 'Add title', 'modus-pt' ); ?></strong></label></p>
				<p><input type="text" name="post_link_title" class="widefat" value="<?php echo esc_attr( $post_link_title ); ?>"/>
				</p>
				<p><label for="post_link_url"><strong><?php esc_html_e( 'Add url', 'modus-pt' ); ?></strong></label></p>
				<p><input type="text" name="post_link_url" class="widefat" value="<?php echo esc_url($post_link_url); ?>"/></p>
				<p class="howto"><?php esc_html_e( 'Add a link to this post, it will show up at the top of the post', 'modus-pt' ); ?></p>
			</div>
			<!-- Add Image -->
			<div class="post-metabox-child post-metabox-image" data-post-format="image">
			</div>
			<!-- Add gallery -->
			<div class="post-metabox-child post-metabox-gallery" data-post-format="gallery">
				<a href="#" class="button add-images" title="<?php esc_attr_e( 'Add image(s)','modus-pt'); ?>" data-uploader-tittle="<?php esc_attr_e( 'Add image (s)','modus-pt'); ?>" data-uploader-button-text="<?php esc_attr_e( 'Add image(s)','modus-pt'); ?>"><?php esc_attr_e( 'Add image (s)','modus-pt'); ?></a>
				<ul class="images-list">
					<?php
					$post_gallery_id = get_post_meta($post->ID, 'post_gallery_id', true);
					$post_gallery_id = explode (',',$post_gallery_id);
					
					if ( is_array($post_gallery_id) && count($post_gallery_id) > 0 ):
						foreach( $post_gallery_id as $key => $value ) : 
						$image = wp_get_attachment_image_src( (int)$value ); ?>
						<li>
							<input type="hidden" id="post_gallery_id[<?php echo esc_attr($key); ?>]" name="post_gallery_id[<?php echo esc_attr($key); ?>]" value="<?php echo esc_attr( $value ); ?>"/>
							<img class="image-preview" src="<?php echo esc_url( $image[0] ); ?>"/>
							<a href="#" class="change-image"
								title="<?php esc_attr_e( 'Change image', 'modus-pt' ); ?>"
								data-uploader-title="<?php esc_attr_e( 'Change image', 'modus-pt' ); ?>"
								data-uploader-button-text="<?php esc_attr_e( 'Change image', 'modus-pt' ); ?>"><i class="dashicons dashicons-edit"></i></a>
							<a href="#" class="remove-image" title="<?php esc_attr_e( 'Remove Image', 'modus-pt' ); ?>"><i class="dashicons dashicons-no"></i></a>
						</li>
					<?php
						endforeach;
					endif; ?>
				</ul>
			</div>
			<!-- Add Quote -->
		   <div class="post-metabox-child post-metabox-quote" data-post-format="quote">
				<p><label for="post_quote_content"><strong><?php esc_html_e( 'Quote content', 'modus-pt' ); ?></strong></label></p>
				<p><textarea class="widefat" name="post_quote_content" id="post_quote_content" cols="30" rows="10"><?php echo esc_attr($post_quote_content); ?></textarea></p>
				<p><label for="post_quote_by"><strong><?php esc_html_e( 'Quote by', 'modus-pt' ); ?></strong></label></p>
				<p><input type="text" name="post_quote_by" class="widefat" value="<?php echo esc_attr($post_quote_by); ?>"/></p>
			</div>
			<!-- Add Video -->
			<div class="post-metabox-child post-metabox-video" data-post-format="video">
				<p><label for="post_video_url"><strong><?php esc_html_e( 'Add video url or upload', 'modus-pt' ); ?></strong></label></p> 
				<p><textarea class="widefat" name="post_video_url" id="post_video_url" cols="30" rows="10"><?php echo esc_attr($post_video_url); ?></textarea></p>

			</div>
			<!-- Add audio -->
			<div class="post-metabox-child post-metabox-audio" data-post-format="audio">
				<p><label for="post_audio_url"><strong><?php esc_html_e( 'Add audio url or upload', 'modus-pt' ); ?></strong></label></p> 
				<p><textarea class="widefat" name="post_audio_url" id="post_audio_url" cols="30" rows="10"><?php echo esc_attr($post_audio_url); ?></textarea></p>
				<p class="howto"><?php esc_html_e( 'Supports: soundcloud and self hosted audios', 'modus-pt' ); ?></p>
			</div>
			
		</div>
		<?php
	}
	function modus_meta_post_assets(){
		if ( isset( $GLOBALS['post_type'] ) && in_array( $GLOBALS['post_type'], array('post') ) ) {
			wp_enqueue_script( 'modus-metabox-post', MODUS_URL . 'metaboxes/js/metabox.js', array( 'jquery' ), '1.0');
			wp_enqueue_script( 'modus-post-metabox', MODUS_URL . 'metaboxes/js/post.metabox.js', array( 'jquery' ), '1.0');
			wp_enqueue_script( 'jquery-ui-core', MODUS_URL . 'metaboxes/js/jquery-ui.min.js', array( 'jquery' ), '', true );
			wp_enqueue_style("modus-page-metabox-style", MODUS_URL .'metaboxes/css/metabox.css', array(), '1.0');
			wp_enqueue_style("modus-post-metabox-style", MODUS_URL .'metaboxes/css/post.metabox.css', array(), '1.0');
		}
	}
}
add_action('admin_enqueue_scripts', 'modus_meta_post_assets' );
add_action( 'save_post', 'modus_save_post_metaboxes' );
 
if ( ! function_exists( 'modus_save_post_metaboxes' ) ) {
	/**
	 * Save controls from the meta boxes
	 *
	 * @param  int $post_id Current post id.
	 * @since 1.0.0
	 */
	function modus_save_post_metaboxes( $post_id ) {
		/*
		 * We need to verify this came from the our screen and with proper authorization,
		 * because save_post can be triggered at other times. Add as many nonces, as you
		 * have metaboxes.
		 */
		if ( ! isset( $_POST['modus_post_meta_box_nonce'] ) || ! wp_verify_nonce( sanitize_key( $_POST['modus_post_meta_box_nonce'] ), 'modus_post_meta_box' ) ) { // Input var okay.
			return $post_id;
		}
 
		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'post' === $_POST['post_type'] ) { // Input var okay.
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return $post_id;
			}
		}
 
		/*
		 * If this is an autosave, our form has not been submitted,
		 * so we don't want to do anything.
		 */
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}
		
		
		if ( isset( $_POST['post_link_title'] ) ) { // Input var okay.
			update_post_meta( $post_id, 'post_link_title', sanitize_text_field( wp_unslash( $_POST['post_link_title'] ) ) ); // Input var okay.
		}
		if ( isset( $_POST['post_link_url'] ) ) { // Input var okay.
			update_post_meta( $post_id, 'post_link_url', sanitize_text_field( wp_unslash( $_POST['post_link_url'] ) ) ); // Input var okay.
		}
		if ( isset( $_POST['post_quote_content'] ) ) { // Input var okay.
			update_post_meta( $post_id, 'post_quote_content', sanitize_text_field( wp_unslash( $_POST['post_quote_content'] ) ) ); // Input var okay.
		}
		if ( isset( $_POST['post_quote_by'] ) ) { // Input var okay.
			update_post_meta( $post_id, 'post_quote_by', sanitize_text_field( wp_unslash( $_POST['post_quote_by'] ) ) ); // Input var okay.
		}
		if ( isset( $_POST['post_video_url'] ) ) { // Input var okay.
			update_post_meta( $post_id, 'post_video_url', sanitize_text_field( wp_unslash( $_POST['post_video_url'] ) ) ); // Input var okay.
		}
		if ( isset( $_POST['post_audio_url'] ) ) { // Input var okay.
			update_post_meta( $post_id, 'post_audio_url', sanitize_text_field( wp_unslash( $_POST['post_audio_url'] ) ) ); // Input var okay.
		}
		
		if ( isset( $_POST['post_gallery_id'] ) && is_array($_POST['post_gallery_id']) ) {
			update_post_meta( $post_id, 'post_gallery_id', implode(',', $_POST['post_gallery_id'] )); // Input var okay.
		}
	}
}

/* Page Option */
if ( ! function_exists( 'modus_metabox_header_footer' ) ) {
	function modus_metabox_header_footer( $post ) {
		$modus_header_layouts = array('Header Layout 1'=>'header_1', 'Header Layout 2'=>'header_2', 'Header Layout 3'=>'header_3','Header Layout 4'=>'header_4','Header Layout 5'=>'header_5','Header Layout 6'=>'header_6','Header Layout 7'=>'header_7','Header Layout 8'=>'header_8','Header Layout 9'=>'header_9','Header Layout 10'=>'header_10','Header Layout 11'=>'header_11');
		$modus_footer_layouts = array('Footer Layout 1'=>'footer_1', 'Footer Layout 2'=>'footer_2', 'Footer Layout 3'=>'footer_3', 'Footer Layout 4'=>'footer_4', 'Footer Layout 5'=>'footer_5','Footer Layout 6'=>'footer_6','Footer Layout 7'=>'footer_7','Footer Layout 8'=>'footer_8','Footer Layout 9'=>'footer_9','Footer Layout 10'=>'footer_10','Footer Layout 11'=>'footer_11');
		$meta = get_post_meta( $post->ID );
		$header_layout = ( isset( $meta['header_layout'][0] ) && '' !== $meta['header_layout'][0] ) ? $meta['header_layout'][0] : '';
		$footer_layout = ( isset( $meta['footer_layout'][0] ) && '' !== $meta['footer_layout'][0] ) ? $meta['footer_layout'][0] : '';
		wp_nonce_field( 'modus_header_footer_meta_box', 'modus_header_footer_meta_box_nonce' ); // Always add nonce to your meta boxes!
		?>
		<div class="modus_header_layout">
			<label><strong><?php esc_html_e( 'Header layout', 'modus-pt');?></strong></label>
			<div>
				<select name="header_layout" class="header_layout">
					<?php if(get_post_meta($post->ID, 'header_layout', true))
						$modus_selected = get_post_meta($post->ID, 'header_layout', true);
						else $modus_selected='';
					?>
					<option value="default" <?php selected( $modus_selected, 'default');?>>
						<?php esc_html_e( 'Header Layout Default', 'modus-pt' );?>
					</option>
					<?php foreach ($modus_header_layouts as $modus_header_layout => $value){ ?>
					<option value="<?php echo esc_attr($value); ?>" <?php selected( $modus_selected, $value);?>><?php echo esc_attr($modus_header_layout); ?></option>
					<?php } ?>
				</select>
				<p class="description"><label></label><?php esc_html_e( 'Choose header layout', 'modus-pt');?></p>
			</div>
		</div>
		<?php // Layout footer ?>
		<div class="modus_footer_layout">
			<label><strong><?php esc_html_e( 'Footer layout', 'modus-pt');?></strong></label>
			<div>
				<select name="footer_layout">
					<?php if(get_post_meta($post->ID, 'footer_layout', true))
						$modus_selected = get_post_meta($post->ID, 'footer_layout', true);
						else $modus_selected='';
					?>
					<option value="default" <?php selected( $modus_selected, 'default');?>>
						<?php esc_html_e( 'Footer Layout Default', 'modus-pt' );?>
					</option>
					<?php foreach ($modus_footer_layouts as $modus_footer_layout => $value){ ?>
					<option value="<?php echo esc_attr($value); ?>" <?php selected( $modus_selected, $value);?>><?php echo esc_attr($modus_footer_layout); ?></option>
					<?php } ?>
				</select>
				<p class="description"><?php esc_html_e( 'Choose footer layout', 'modus-pt');?></p>
			</div>
		</div>
		<?php
	}
}

add_action( 'save_post', 'modus_save_header_footer_metaboxes' );
 
if ( ! function_exists( 'modus_save_header_footer_metaboxes' ) ) {
	/**
	 * Save controls from the meta boxes
	 *
	 * @param  int $post_id Current post id.
	 * @since 1.0.0
	 */
	function modus_save_header_footer_metaboxes( $post_id ) {
		/*
		 * We need to verify this came from the our screen and with proper authorization,
		 * because save_post can be triggered at other times. Add as many nonces, as you
		 * have metaboxes.
		 */
		if ( ! isset( $_POST['modus_header_footer_meta_box_nonce'] ) || ! wp_verify_nonce( sanitize_key( $_POST['modus_header_footer_meta_box_nonce'] ), 'modus_header_footer_meta_box' ) ) { // Input var okay.
			return $post_id;
		}
 
		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'page' === $_POST['post_type'] ) { // Input var okay.
			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return $post_id;
			}
		} else {
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return $post_id;
			}
		}
 
		/*
		 * If this is an autosave, our form has not been submitted,
		 * so we don't want to do anything.
		 */
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}
		if ( isset( $_POST['header_layout'] )){
			$value = sanitize_text_field( $_POST['header_layout'] );
			update_post_meta( $post_id, 'header_layout', $value );
		}

		if ( isset( $_POST['footer_layout'] )){
			$value = sanitize_text_field( $_POST['footer_layout'] );
			update_post_meta( $post_id, 'footer_layout', $value );
		}
	}
}

/* Layout Option */
if (!function_exists('modus_metabox_controls')) {
    /**
     * Meta box render function
     *
     * @param  object $post Post object.
     * @since  1.0.0
     */
    function skin_color(){
        return array(
                'awesome', 'bleu-de-france','bleu-de-france2','bleu-de-france3', 'light-taupe',   'orange', 'pastel-red', 'orange-2', 'orange-3', 'granite-color'
        );
    }
    function modus_metabox_controls($post)
    {
        $meta = get_post_meta($post->ID);
        $page_background = (isset($meta['page_background'][0]) && '' !== $meta['page_background'][0]) ? $meta['page_background'][0] : '';
        $page_fullwidth = (isset($meta['page_fullwidth'][0]) && '1' === $meta['page_fullwidth'][0]) ? 1 : 0;
        $special_skin = (isset($meta['special_skin'][0]) && '1' === $meta['special_skin'][0]) ? 1 : 0;

        $skin = (isset($meta['skin'][0]) && '' !== $meta['skin'][0]) ? $meta['skin'][0] : '';
        $show_breadcrumb = (isset($meta['show_breadcrumb'][0]) && '' !== $meta['show_breadcrumb'][0]) ? $meta['show_breadcrumb'][0] : '';
        $show_title_page = (isset($meta['show_title_page'][0]) && '' !== $meta['show_title_page'][0]) ? $meta['show_title_page'][0] : '';
        $header_fixed = (isset($meta['header_fixed'][0]) && '1' === $meta['header_fixed'][0]) ? 1 : 0;
        $header_over = (isset($meta['header_over'][0]) && '1' === $meta['header_over'][0]) ? 1 : 0;
        $hidden_header = (isset($meta['hidden_header'][0]) && '1' === $meta['hidden_header'][0]) ? 1 : 0;
        $hidden_footer = (isset($meta['hidden_footer'][0]) && '1' === $meta['hidden_footer'][0]) ? 1 : 0;
        $no_padding_top = (isset($meta['no_padding_top'][0]) && '1' === $meta['no_padding_top'][0]) ? 1 : 0;
        $no_padding_bottom = (isset($meta['no_padding_bottom'][0]) && '1' === $meta['no_padding_bottom'][0]) ? 1 : 0;
        $content_width = (isset($meta['content_width'][0]) && '1' === $meta['content_width'][0]) ? 1 : 0;
        $is_home_page = (isset($meta['is_home_page'][0]) && '1' === $meta['is_home_page'][0]) ? 1 : 0;
        $sidebar_position = (isset($meta['sidebar_position'][0]) && '' !== $meta['sidebar_position'][0]) ? $meta['sidebar_position'][0] : '';
        $sidebar = (isset($meta['sidebar'][0]) && '' !== $meta['sidebar'][0]) ? $meta['sidebar'][0] : '';
        wp_nonce_field('modus_control_meta_box', 'modus_control_meta_box_nonce'); // Always add nonce to your meta boxes!

        ?>
        <div class="post_meta_extras">
            <div>
                <h3><?php esc_attr_e('Full Width', 'modus-pt'); ?></h3>
                <label><input type="checkbox" name="page_fullwidth"
                              value="1" <?php checked($page_fullwidth, 1); ?> /><?php esc_attr_e('Page Full Width', 'modus-pt'); ?>
                </label>
            </div>
            <!--./ Full Width-->
            <div>
                <h3><?php esc_attr_e('Background Page', 'modus-pt'); ?></h3>
                <?php $value = get_post_meta($post->ID, 'page_background', true); ?>
                <select id="page_background" name="page_background">
                    <option value="white" <?php selected($value, 'white'); ?>><?php _e('White', 'modus-pt'); ?></option>
                    <option value="grey" <?php selected($value, 'grey'); ?>><?php _e('Grey', 'modus-pt'); ?></option>
                </select>
            </div>
            <!--./ Background Page-->
            <div class="metabox  " data-name="special_skin">
                <h3><?php esc_attr_e('Special Skin', 'modus-pt'); ?></h3>
                <div class="metainner">
                    <div class="box-option checkbox">
                        <label>
                            <input type="checkbox" name="special_skin"
                                      value="1" <?php checked($special_skin, 1); ?> /><?php esc_attr_e('Select Skin for this page', 'modus-pt'); ?>
                        </label>
                    </div>
                </div>
            </div>
            <!--./ Special Skin-->
            <div class="metabox skin-color" data-name= "skin" >
                <h3><?php esc_attr_e('Skin', 'modus-pt'); ?></h3>
                <div class="metainner">
                    <div class="box-option skin">
                        <ul class="list-inline list-color">
                            <?php foreach (skin_color() as $k => $v){ ?>
                                <li class="<?php echo esc_attr($v); ?>" data-name="<?php echo esc_attr($v); ?>">
                                    <a href="#"></a>
                                </li>
                            <?php } ?>
                        </ul>
                        <input type="hidden" name="skin" value="<?php echo get_post_meta($post->ID, 'skin', true)?>">
                    </div>
                </div>
            </div>
            <!--./ Skin-->
            <div>
                <h3><?php esc_attr_e('Breadcrumb', 'modus-pt'); ?></h3>
                <?php $value = get_post_meta($post->ID, 'show_breadcrumb', true); ?>
                <select id="show_breadcrumb" name="show_breadcrumb">
                    <option value="default" <?php selected($value, 'default'); ?>><?php _e('Default', 'modus-pt'); ?></option>
                    <option value="show" <?php selected($value, 'show'); ?>><?php _e('Show Breadcrumb', 'modus-pt'); ?></option>
                    <option value="hide" <?php selected($value, 'hide'); ?>><?php _e('Hide Breadcrumb', 'modus-pt'); ?></option>
                </select>
            </div>
            <!--./ Breadcrumb-->
            <div class="metabox" >
                <h3><?php esc_attr_e('Breadcrumbs Background', 'modus-pt'); ?></h3>
                <div class="metainner">
                    <div class="box-option">
                        <label for="upload_image">
                            <input value="<?php echo get_post_meta($post->ID, "breadcrumbs_bg", true); ?>" type="text" name="breadcrumbs_bg"  id="breadcrumbs_bg" />
                            <br/>
                        </label>
                    </div>
                </div>
            </div>
            <!--./ Special Skin-->
            <div>
                <h3><?php esc_attr_e('Title', 'modus-pt'); ?></h3>
                <?php $value = get_post_meta($post->ID, 'show_title_page', true); ?>
                <select id="show_title_page" name="show_title_page">
                    <option value="show" <?php selected($value, 'show'); ?>><?php _e('Show title', 'modus-pt'); ?></option>
                    <option value="hide" <?php selected($value, 'hide'); ?>><?php _e('Hide title', 'modus-pt'); ?></option>
                    <?php

                    ?>
                </select>
            </div>
            <!--./ Show Title-->
            <div>
                <h3><?php esc_attr_e('Header fix', 'modus-pt'); ?></h3>
                <label><input type="checkbox" name="header_fixed"
                              value="1" <?php checked($header_fixed, 1); ?> /><?php esc_attr_e('Header fixed when scroll', 'modus-pt'); ?>
                </label>
            </div>
            <!--./ Header Fix-->
            <div>
                <h3><?php esc_attr_e('Header over', 'modus-pt'); ?></h3>
                <label><input type="checkbox" name="header_over"
                              value="1" <?php checked($header_over, 1); ?> /><?php esc_attr_e('Header over when scroll', 'modus-pt'); ?>
                </label>
            </div>
            <!--./ Header Over-->
            <div>
                <h3><?php esc_attr_e('Hidden header', 'modus-pt'); ?></h3>
                <label><input type="checkbox" name="hidden_header"
                              value="1" <?php checked($hidden_header, 1); ?> /><?php esc_attr_e('Hidden header page', 'modus-pt'); ?>
                </label>
            </div>
            <!--./ Hidden Header-->
            <div>
                <h3><?php esc_attr_e('Hidden footer', 'modus-pt'); ?></h3>
                <label><input type="checkbox" name="hidden_footer"
                              value="1" <?php checked($hidden_footer, 1); ?> /><?php esc_attr_e('Hidden footer page', 'modus-pt'); ?>
                </label>
            </div>
            <!--./ Hidden Footer-->
            <div>
                <h3><?php esc_attr_e('No Padding Top', 'modus-pt'); ?></h3>
                <label><input type="checkbox" name="no_padding_top"
                              value="1" <?php checked($no_padding_top, 1); ?> /><?php esc_attr_e('No Padding Top Default', 'modus-pt'); ?>
                </label>
            </div>
            <!--./ No Padding Top-->
            <div>
                <h3><?php esc_attr_e('No Padding Bottom', 'modus-pt'); ?></h3>
                <label><input type="checkbox" name="no_padding_bottom"
                              value="1" <?php checked($no_padding_bottom, 1); ?> /><?php esc_attr_e('No Padding Bottom Default', 'modus-pt'); ?>
                </label>
            </div>
            <!--./ No Padding Bottom-->
            <div>
                <h3><?php esc_attr_e('Content width', 'modus-pt'); ?></h3>
                <label><input type="checkbox" name="content_width"
                              value="1" <?php checked($content_width, 1); ?> /><?php esc_attr_e('Content full container', 'modus-pt'); ?>
                </label>
            </div>
            <!--./ Content Width-->
            <div>
                <h3><?php esc_attr_e('Is Home Page', 'modus-pt'); ?></h3>
                <label><input type="checkbox" name="is_home_page"
                              value="1" <?php checked($is_home_page, 1); ?> /><?php esc_attr_e('Select if this is home page', 'modus-pt'); ?>
                </label>
            </div>
            <!--./ Is home page -->
            <div>
                <h3><?php esc_attr_e('Sidebar Position', 'modus-pt'); ?></h3>
                <?php $value = get_post_meta($post->ID, 'sidebar_position', true); ?>
                <select id="sidebar_position" name="sidebar_position">
                    <option value="" <?php selected($value, 'default'); ?>><?php _e('Default Position', 'modus-pt'); ?></option>
                    <option value="left-sidebar" <?php selected($value, 'left-sidebar'); ?>><?php _e('Left', 'modus-pt'); ?></option>
                    <option value="right-sidebar" <?php selected($value, 'right-sidebar'); ?>><?php _e('Right', 'modus-pt'); ?></option>

                </select>
            </div>
            <!--./ Sidebar Position -->
            <div>
                <h3><?php esc_attr_e('Sidebar', 'modus-pt'); ?></h3>
                <?php $modus_selected = get_post_meta($post->ID, 'sidebar', true); ?>
                <select id="sidebar" name="sidebar">
                    <?php foreach (modus_sidebars() as $modus_sidebar => $value){ ?>
                        <option value="<?php echo esc_attr($modus_sidebar); ?>" <?php selected( $modus_selected, $modus_sidebar);?>><?php echo esc_attr($value); ?></option>
                    <?php } ?>
                </select>
            </div>
            <!--./ Sidebar Position -->
        </div>
        <?php
    }
    function modus_meta_page_assets(){
        if ( isset( $GLOBALS['post_type'] ) && in_array( $GLOBALS['post_type'], array('page') ) ) {
            wp_enqueue_script( 'modus-metabox-post', MODUS_URL . 'metaboxes/js/metabox.js', array( 'jquery' ), '1.0');
            wp_enqueue_script( 'modus-post-metabox', MODUS_URL . 'metaboxes/js/page.metabox.js', array( 'jquery' ), '1.0');
            wp_enqueue_script( 'jquery-ui-core', MODUS_URL . 'metaboxes/js/jquery-ui.min.js', array( 'jquery' ), '', true );
            wp_enqueue_style("modus-page-metabox-style", MODUS_URL .'metaboxes/css/metabox.css', array(), '1.0');
            wp_enqueue_script( 'jquery-iris',  MODUS_URL . 'metaboxes/js/iris.min.js', array( ), '', true );
        }
    }
}
add_action('admin_enqueue_scripts', 'modus_meta_page_assets' );
add_action('save_post', 'modus_save_metaboxes');

if (!function_exists('modus_save_metaboxes')) {
    /**
     * Save controls from the meta boxes
     *
     * @param  int $post_id Current post id.
     * @since 1.0.0
     */
    function modus_save_metaboxes($post_id)
    {
        /*
         * We need to verify this came from the our screen and with proper authorization,
         * because save_post can be triggered at other times. Add as many nonces, as you
         * have metaboxes.
         */
        if (!isset($_POST['modus_control_meta_box_nonce']) || !wp_verify_nonce(sanitize_key($_POST['modus_control_meta_box_nonce']), 'modus_control_meta_box')) { // Input var okay.
            return $post_id;
        }

        // Check the user's permissions.
        if (isset($_POST['post_type']) && 'page' === $_POST['post_type']) { // Input var okay.
            if (!current_user_can('edit_page', $post_id)) {
                return $post_id;
            }
        } else {
            if (!current_user_can('edit_post', $post_id)) {
                return $post_id;
            }
        }

        /*
         * If this is an autosave, our form has not been submitted,
         * so we don't want to do anything.
         */
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }

        /* Ok to save */

        if (isset($_POST['modus_input_field'])) { // Input var okay.
            update_post_meta($post_id, 'modus_input_field', sanitize_text_field(wp_unslash($_POST['modus_input_field']))); // Input var okay.
        }

        $page_fullwidth = (isset($_POST['page_fullwidth']) && '1' === $_POST['page_fullwidth']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'page_fullwidth', esc_attr($page_fullwidth));

        if (isset($_POST['page_background'])) {
            $value = sanitize_text_field($_POST['page_background']);
            update_post_meta($post_id, 'page_background', $value);
        }

        $special_skin = (isset($_POST['special_skin']) && '1' === $_POST['special_skin']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'special_skin', esc_attr($special_skin));
        if (isset($_POST['skin'])) {
            $value = sanitize_text_field($_POST['skin']);
            update_post_meta($post_id, 'skin', $value);
        }

        if (isset($_POST['show_breadcrumb'])) {
            $value = sanitize_text_field($_POST['show_breadcrumb']);
            update_post_meta($post_id, 'show_breadcrumb', $value);
        }
        if (isset($_POST['breadcrumbs_bg'])) {
            $value = sanitize_text_field($_POST['breadcrumbs_bg']);
            update_post_meta($post_id, 'breadcrumbs_bg', $value);
        }
        if (isset($_POST['show_title_page'])) {
            $value = sanitize_text_field($_POST['show_title_page']);
            update_post_meta($post_id, 'show_title_page', $value);
        }

        $header_fixed = (isset($_POST['header_fixed']) && '1' === $_POST['header_fixed']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'header_fixed', esc_attr($header_fixed));

        $header_over = (isset($_POST['header_over']) && '1' === $_POST['header_over']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'header_over', esc_attr($header_over));

        $hidden_header = (isset($_POST['hidden_header']) && '1' === $_POST['hidden_header']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'hidden_header', esc_attr($hidden_header));

        $hidden_footer = (isset($_POST['hidden_footer']) && '1' === $_POST['hidden_footer']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'hidden_footer', esc_attr($hidden_footer));

        $no_padding_top = (isset($_POST['no_padding_top']) && '1' === $_POST['no_padding_top']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'no_padding_top', esc_attr($no_padding_top));

        $no_padding_bottom = (isset($_POST['no_padding_bottom']) && '1' === $_POST['no_padding_bottom']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'no_padding_bottom', esc_attr($no_padding_bottom));

        $content_width = (isset($_POST['content_width']) && '1' === $_POST['content_width']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'content_width', esc_attr($content_width));

        $is_home_page = (isset($_POST['is_home_page']) && '1' === $_POST['is_home_page']) ? 1 : 0; // Input var okay.
        update_post_meta($post_id, 'is_home_page', esc_attr($is_home_page));

        if (isset($_POST['sidebar_position'])) {
            $value = sanitize_text_field($_POST['sidebar_position']);
            update_post_meta($post_id, 'sidebar_position', $value);
        }

        if (isset($_POST['sidebar'])) {
            $value = sanitize_text_field($_POST['sidebar']);
            update_post_meta($post_id, 'sidebar', $value);
        }

    }
}

class ModusPostTypes
{
    function __construct()
    {
        // Load text domain
        add_action('plugins_loaded', array($this, 'loadTextDomain'));
        // Register post types
        add_action('init', array($this, 'modus_addPostPostType'), 0);
        add_action('init', array($this, 'modus_addProductPostType'), 0);
        add_action('init', array($this, 'modus_addBlockPostType'));
        add_action('init', array($this, 'modus_testimonialPostType'), 0);
        add_action('init', array($this, 'modus_addClientPostType'), 0);
        add_action('init', array($this, 'modus_addTeamPostType'), 0);
        add_action('init', array($this, 'modus_addServicePostType'), 0);
        add_action('init', array($this, 'modus_addPortfolioPostType'), 0);
        add_action('add_meta_boxes', array($this, 'add_metabox_admin'));
        add_action('save_post', array($this, 'save_metabox_team'));
        add_action('show_user_profile', array($this, 'modus_show_extra_profile_fields'), 0);
        add_action('edit_user_profile', array($this, 'modus_show_extra_profile_fields'), 0);
        add_action('personal_options_update', array($this, 'modus_save_extra_profile_fields'), 0);
        add_action('edit_user_profile_update', array($this, 'modus_save_extra_profile_fields'), 0);
    }

    // Init plugins
    function initPlugin()
    {
    }

    function modus_show_extra_profile_fields($user)
    { ?>
        <h3><?php esc_html_e('Extra profile information', 'modus-pt') ?></h3>
        <table class="form-table">
            <?php
            $user_extra_profiles = array('job', 'facebook', 'twitter', 'dribbble', 'google_plus');
            foreach ($user_extra_profiles as $user_extra_profile) {
                ?>
                <tr>
                    <th>
                        <label for="<?php echo esc_attr($user_extra_profile); ?>"><?php echo esc_html($user_extra_profile) ?></label>
                    </th>
                    <td>
                        <input type="text" name="<?php echo esc_attr($user_extra_profile); ?>"
                               id="<?php echo esc_attr($user_extra_profile); ?>"
                               value="<?php echo esc_attr(get_the_author_meta($user_extra_profile, $user->ID)); ?>"
                               class="regular-text"/><br/>
                        <span class="description"><?php echo esc_html__('Please enter your ', 'modus-pt') . esc_html($user_extra_profile); ?></span>
                    </td>
                </tr>
            <?php } ?>
        </table>
    <?php }

    function modus_save_extra_profile_fields($user_id)
    {
        if (!current_user_can('edit_user', $user_id))
            return false;
        update_usermeta($user_id, 'job', $_POST['job']);
        update_usermeta($user_id, 'facebook', $_POST['facebook']);
        update_usermeta($user_id, 'twitter', $_POST['twitter']);
        update_usermeta($user_id, 'dribbble', $_POST['dribbble']);
        update_usermeta($user_id, 'google_plus', $_POST['google_plus']);
    }

    // Register static block post type
    function modus_addBlockPostType()
    {
        register_post_type(
            'block', array(
                'labels' => $this->getLabels(esc_html__('Static Block', 'modus-pt'), esc_html__('Static Block', 'modus-pt')),
                'exclude_from_search' => true,
                'has_archive' => false,
                'publicly_queryable' => false,
                'public' => true,
                'rewrite' => array('slug' => 'block'),
                'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
                'can_export' => true
            )
        );
        register_post_type(
            'arr_megamenu', array(
                'labels' => $this->getLabels(esc_html__('Mega menu [Arrow theme]', 'modus-pt'), esc_html__('Mega menu [Arrow theme]', 'modus-pt')),
                'exclude_from_search' => true,
                'has_archive' => false,
                'publicly_queryable' => false,
                'public' => true,
                'rewrite' => array('slug' => 'arr_megamenu'),
                'supports' => array('title', 'editor'),
                'can_export' => true
            )
        );
    }

    // Register static block post type
    function modus_addPostPostType()
    {
        register_taxonomy(
            'post_layout', 'post', array(
                'hierarchical' => true,
                'has_archive' => true,  // it shouldn't have archive page
                'labels' => $this->getLabels(esc_html__('Group', 'modus-pt'), esc_html__('Group', 'modus-pt')),

            )
        );
    }

    // Register static block post type
    function modus_addProductPostType()
    {
        register_taxonomy(
            'product_filter', 'product', array(
                'hierarchical' => true,
                'has_archive' => true,
                'public' => false,  // it's not public, it shouldn't have it's own permalink, and so on
                'publicly_queriable' => true,  // you should be able to query it
                'show_ui' => true,  // you should be able to edit it in wp-admin
                'exclude_from_search' => true,  // you should exclude it from search results
                'show_in_nav_menus' => false,  // you shouldn't be able to add it to menus
                'has_archive' => false,  // it shouldn't have archive page
                'rewrite' => false,  // it shouldn't have rewrite rules
                'labels' => $this->getLabels(esc_html__('Filter', 'modus-pt'), esc_html__('Filter', 'modus-pt')),
                'query_var' => true,
                'rewrite' => true
            )
        );
    }

    // Register client post type
    function modus_addClientPostType()
    {
        register_post_type(
            'client', array(
                'labels' => $this->getLabels(esc_html__('Client', 'modus-pt'), esc_html__('Client', 'modus-pt')),
                'exclude_from_search' => true,
                'has_archive' => false,
                'publicly_queryable' => false,
                'public' => true,
                'rewrite' => array('slug' => 'client'),
                'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
                'can_export' => true
            )
        );
        $labels_format = array(
            'name' => __('Client Category', 'modus-pt'),
            'singular_name' => __('Client Category', 'modus-pt'),
            'search_items' => __('Search Client Category', 'modus-pt'),
            'all_items' => __('All Client Category', 'modus-pt'),
            'parent_item' => __('Parent Client Category', 'modus-pt'),
            'parent_item_colon' => __('Parent Client Category:', 'modus-pt'),
            'edit_item' => __('Edit Client Category', 'modus-pt'),
            'update_item' => __('Update Client Category', 'modus-pt'),
            'add_new_item' => __('Add New Client Category', 'modus-pt'),
            'new_item_name' => __('New Client Category', 'modus-pt'),
            'menu_name' => __('Client Category', 'modus-pt'),
        );
        $args_format = array(
            'labels' => $labels_format,
            'hierarchical' => true,
            'has_archive' => true,
        );
        register_taxonomy('client_cat', 'client', $args_format);
    }

    // Register client post type
    function modus_addServicePostType()
    {
        register_post_type(
            'services', array(
                'labels' => $this->getLabels(esc_html__('Our Services', 'modus-pt'), esc_html__('Our Services', 'modus-pt')),
                'exclude_from_search' => true,
                'has_archive' => false,
                'publicly_queryable' => true,
                'public' => true,
                'rewrite' => array('slug' => 'services'),
                'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
                'can_export' => true
            )
        );
        $labels_format = array(
            'name' => __('Our Services Category', 'modus-pt'),
            'singular_name' => __('Our Services Category', 'modus-pt'),
            'search_items' => __('Search Our Services Category', 'modus-pt'),
            'all_items' => __('All Our Services Category', 'modus-pt'),
            'parent_item' => __('Parent Our Services Category', 'modus-pt'),
            'parent_item_colon' => __('Parent Our Services Category:', 'modus-pt'),
            'edit_item' => __('Edit Our Services Category', 'modus-pt'),
            'update_item' => __('Update Our Services Category', 'modus-pt'),
            'add_new_item' => __('Add New Our Services Category', 'modus-pt'),
            'new_item_name' => __('New Our Services Category', 'modus-pt'),
            'menu_name' => __('Our Services Category', 'modus-pt'),
        );
        $args_format = array(
            'labels' => $labels_format,
            'hierarchical' => true,
            'has_archive' => true,
        );
        register_taxonomy('services_cat', 'services', $args_format);
    }

    // Register team post type
    function modus_addTeamPostType()
    {
        register_post_type(
            'team', array(
                'labels' => $this->getLabels(esc_html__('Team', 'modus-pt'), esc_html__('Team', 'modus-pt')),
                'exclude_from_search' => false,
                'has_archive' => true,
                'public' => true,
                'rewrite' => array('slug' => 'team'),
                'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
                'can_export' => true
            )
        );
        $labels_format = array(
            'name' => __('Team Business', 'modus-pt'),
            'singular_name' => __('Team Business', 'modus-pt'),
            'search_items' => __('Search Team Business', 'modus-pt'),
            'all_items' => __('All Team Business', 'modus-pt'),
            'parent_item' => __('Parent Team Business', 'modus-pt'),
            'parent_item_colon' => __('Parent Team Business:', 'modus-pt'),
            'edit_item' => __('Edit Team Business', 'modus-pt'),
            'update_item' => __('Update Team Business', 'modus-pt'),
            'add_new_item' => __('Add New Team Business', 'modus-pt'),
            'new_item_name' => __('New Team Business', 'modus-pt'),
            'menu_name' => __('Team Business', 'modus-pt'),
        );
        $args_format = array(
            'labels' => $labels_format,
            'hierarchical' => true,
            'has_archive' => true,
        );
        register_taxonomy('team_cat', 'team', $args_format);
        $labels_format_group = array(
            'name' => __('Team Group', 'modus-pt'),
            'singular_name' => __('Team Group', 'modus-pt'),
            'search_items' => __('Search Team Group', 'modus-pt'),
            'all_items' => __('All Team Group', 'modus-pt'),
            'parent_item' => __('Parent Team Group', 'modus-pt'),
            'parent_item_colon' => __('Parent Team Group:', 'modus-pt'),
            'edit_item' => __('Edit Team Group', 'modus-pt'),
            'update_item' => __('Update Team Group', 'modus-pt'),
            'add_new_item' => __('Add New Team Group', 'modus-pt'),
            'new_item_name' => __('New Team Group', 'modus-pt'),
            'menu_name' => __('Team Group', 'modus-pt'),
        );
        $args_format_group = array(
            'labels' => $labels_format_group,
            'hierarchical' => true,
            'has_archive' => true,
        );
        register_taxonomy('team_group', 'team', $args_format_group);
    }

    // Register testimonial
    function modus_testimonialPostType()
    {
        $labels = array(
            'name' => esc_html__('All Testimonial', 'modus-pt'),
            'singular_name' => esc_html__('All Testimonial', 'modus-pt'),
            'add_new' => esc_html__('Add New', 'modus-pt'),
            'add_new_item' => esc_html__('Add New Testimonial', 'modus-pt'),
            'edit_item' => esc_html__('Edit Testimonial', 'modus-pt'),
            'new_item' => esc_html__('New Testimonial', 'modus-pt'),
            'all_items' => esc_html__('All Testimonial', 'modus-pt'),
            'view_item' => esc_html__('View Testimonial', 'modus-pt'),
            'search_items' => esc_html__('Search Testimonial', 'modus-pt'),
            'not_found' => esc_html__('No Testimonial found', 'modus-pt'),
            'not_found_in_trash' => esc_html__('No Testimonial found in the Trash', 'modus-pt'),
            'parent_item_colon' => '',
            'menu_name' => 'Testimonial'
        );
        $args = array(
            'labels' => $labels,
            'description' => 'Holds our testimonial specific data',
            'public' => true,
            'menu_position' => 5,
            'supports' => array('title', 'editor', 'thumbnail', 'excerpt', 'comments'),
            'has_archive' => true,
            'public' => false,  // it's not public, it shouldn't have it's own permalink, and so on
            'publicly_queriable' => true,  // you should be able to query it
            'show_ui' => true,  // you should be able to edit it in wp-admin
            'exclude_from_search' => true,  // you should exclude it from search results
            'show_in_nav_menus' => false,  // you shouldn't be able to add it to menus
            'has_archive' => false,  // it shouldn't have archive page
            'rewrite' => false,  // it shouldn't have rewrite rules
        );
        register_post_type('testimonial', $args);
    }

    // Register portfolio post type
    function modus_addPortfolioPostType()
    {
        register_post_type(
            'portfolio', array(
                'labels' => $this->getLabels(esc_html__('Portfolio', 'modus-pt'), esc_html__('Portfolio', 'modus-pt')),
                'exclude_from_search' => false,
                'has_archive' => false,
                'public' => true,
                'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
                'can_export' => true
            )
        );
        $labels_format = array(
            'name' => __('Portfolio Category', 'modus-pt'),
            'singular_name' => __('Portfolio Category', 'modus-pt'),
            'search_items' => __('Search Portfolio Category', 'modus-pt'),
            'all_items' => __('All Portfolio Category', 'modus-pt'),
            'parent_item' => __('Parent Portfolio Category', 'modus-pt'),
            'parent_item_colon' => __('Parent Portfolio Category:', 'modus-pt'),
            'edit_item' => __('Edit Portfolio Category', 'modus-pt'),
            'update_item' => __('Update Portfolio Category', 'modus-pt'),
            'add_new_item' => __('Add New Portfolio Category', 'modus-pt'),
            'new_item_name' => __('New Portfolio Category', 'modus-pt'),
            'menu_name' => __('Portfolio Category', 'modus-pt'),
        );
        $args_format = array(
            'labels' => $labels_format,
            'hierarchical' => true,
            'has_archive' => true,
        );
        register_taxonomy('portfolio_cat', 'portfolio', $args_format);

    }

    // load plugin text domain
    function loadTextDomain()
    {
        load_plugin_textdomain('modus-pt', false, dirname(__FILE__) . '/languages/');
    }

    // Get content type labels
    function getLabels($singular_name, $name, $title = FALSE)
    {
        if (!$title)
            $title = $name;

        return array(
            "name" => $title,
            "singular_name" => $singular_name,
            "add_new" => esc_html__("Add New", 'modus-pt'),
            "add_new_item" => sprintf(esc_html__("Add New %s", 'modus-pt'), $singular_name),
            "edit_item" => sprintf(esc_html__("Edit %s", 'modus-pt'), $singular_name),
            "new_item" => sprintf(esc_html__("New %s", 'modus-pt'), $singular_name),
            "view_item" => sprintf(esc_html__("View %s", 'modus-pt'), $singular_name),
            "search_items" => sprintf(esc_html__("Search %s", 'modus-pt'), $name),
            "not_found" => sprintf(esc_html__("No %s found", 'modus-pt'), $name),
            "not_found_in_trash" => sprintf(esc_html__("No %s found in Trash", 'modus-pt'), $name),
            "parent_item_colon" => ""
        );
    }

    /*Metabox Postype Testimonial*/
    function add_metabox_admin()
    {
        if (isset($GLOBALS['post_type']) && in_array($GLOBALS['post_type'], array('testimonial'))) {
            add_meta_box(
                'field_testimonial',
                'Info',
                array($this, 'render_content_testimonial'),
                'testimonial',
                'normal',
                'high'
            );
        }
        if (isset($GLOBALS['post_type']) && in_array($GLOBALS['post_type'], array('team'))) {
            add_meta_box(
                'field_team',
                'Info',
                array($this, 'render_content_team'),
                'team',
                'normal',
                'high'
            );
        }
        if (isset($GLOBALS['post_type']) && in_array($GLOBALS['post_type'], array('portfolio'))) {
            add_meta_box(
                'field_portfolio',
                'Info',
                array($this, 'render_content_portfolio'),
                'portfolio',
                'normal',
                'high'
            );
        }

    }

    /*Metabox Testimonial*/
    function render_content_testimonial()
    {
        global $post;
        $business = get_post_meta($post->ID, 'business', true);
        $title_testi = get_post_meta($post->ID, 'testimonial-title', true);
        ?>
        <div class="inside">
            <div class="setting_text" id="slide_template_title"><?php esc_html_e('Title', 'modus-pt'); ?></div>
            <input type="text" name="txttitle" value="<?php echo esc_attr($title_testi); ?>">
        </div>
        <div class="inside">
            <div class="setting_text" id="slide_template_text"><?php esc_html_e('Business', 'modus-pt'); ?></div>
            <input type="text" name="txtbusiness" value="<?php echo esc_attr($business); ?>">
        </div>
        <?php
    }

    /*Metabox Team*/
    function render_content_team()
    {
        global $post;
        $facebook = get_post_meta($post->ID, 'facebook', true);
        $twitter = get_post_meta($post->ID, 'twitter', true);
        $instagram = get_post_meta($post->ID, 'instagram', true);
        $gpl = get_post_meta($post->ID, 'googleplus', true);
        ?>
        <div class="inside">
            <div class="setting_text" id="slide_template_text"><?php esc_html_e('Facebook', 'modus-pt'); ?></div>
            <input type="text" name="txtfacebook" value="<?php echo esc_attr($facebook); ?>">
        </div>
        <div class="inside">
            <div class="setting_text" id="slide_template_text"><?php esc_html_e('Twitter', 'modus-pt'); ?></div>
            <input type="text" name="txttwitter" value="<?php echo esc_attr($twitter); ?>">
        </div>
        <div class="inside">
            <div class="setting_text" id="slide_template_text"><?php esc_html_e('Instagram', 'modus-pt'); ?></div>
            <input type="text" name="txtinstagram" value="<?php echo esc_attr($instagram); ?>">
        </div>
        <div class="inside">
            <div class="setting_text" id="slide_template_text"><?php esc_html_e('Google plus', 'modus-pt'); ?></div>
            <input type="text" name="txtgpl" value="<?php echo esc_attr($gpl); ?>">
        </div>
        <div class="inside">
            <p class="description"><?php esc_html_e('Add link social for team', 'modus-pt') ?></p>
        </div>
        <?php
    }

    /*Metabox Portfolio*/
    function render_content_portfolio()
    {
        global $post;
        $client = get_post_meta($post->ID, 'client', true);
        $materials = get_post_meta($post->ID, 'materials', true);
        $website = get_post_meta($post->ID, 'website', true);
        $branding = get_post_meta($post->ID, 'branding', true);
        ?>
        <div class="inside">
            <div class="setting_text" id="slide_template_text"><?php esc_html_e('Client', 'modus-pt'); ?></div>
            <input type="text" name="txtclient" value="<?php echo esc_attr($client); ?>">
        </div>
        <div class="inside">
            <div class="setting_text" id="slide_template_text"><?php esc_html_e('Materials', 'modus-pt'); ?></div>
            <input type="text" name="txtmaterials" value="<?php echo esc_attr($materials); ?>">
        </div>
        <div class="inside">
            <div class="setting_text" id="slide_template_text"><?php esc_html_e('Website', 'modus-pt'); ?></div>
            <input type="text" name="txtwebsite" value="<?php echo esc_attr($website); ?>">
        </div>
        <div class="inside">
            <div class="setting_text" id="slide_template_text"><?php esc_html_e('Branding', 'modus-pt'); ?></div>
            <input type="text" name="txtbranding" value="<?php echo esc_attr($branding); ?>">
        </div>
        <div class="inside">
            <p class="description"><?php esc_html_e('Add infomation for portfolio', 'modus-pt') ?></p>
        </div>
        <?php
    }

    /*Save metabox*/
    function save_metabox_team($post_id)
    {
        $job = isset($_POST['txtbusiness']) ? $_POST['txtbusiness'] : '';
        $facebook = isset($_POST['txtfacebook']) ? $_POST['txtfacebook'] : '';
        $twitter = isset($_POST['txttwitter']) ? $_POST['txttwitter'] : '';
        $instagram = isset($_POST['txtinstagram']) ? $_POST['txtinstagram'] : '';
        $gpl = isset($_POST['txtgpl']) ? $_POST['txtgpl'] : '';
        $title_testi = isset($_POST['txttitle']) ? $_POST['txttitle'] : '';
        $client = isset($_POST['txtclient']) ? $_POST['txtclient'] : '';
        $materials = isset($_POST['txtmaterials']) ? $_POST['txtmaterials'] : '';
        $website = isset($_POST['txtwebsite']) ? $_POST['txtwebsite'] : '';
        $branding = isset($_POST['txtbranding']) ? $_POST['txtbranding'] : '';

        /**
         * Update info testimonial
         */
        update_post_meta($post_id, 'business', $job);
        /**
         * Update info team
         */
        update_post_meta($post_id, 'facebook', $facebook);
        update_post_meta($post_id, 'twitter', $twitter);
        update_post_meta($post_id, 'instagram', $instagram);
        update_post_meta($post_id, 'googleplus', $gpl);
        update_post_meta($post_id, 'testimonial-title', $title_testi);
        /**
         * Update info Portfolio
         */
        update_post_meta($post_id, 'client', $client);
        update_post_meta($post_id, 'materials', $materials);
        update_post_meta($post_id, 'website', $website);
        update_post_meta($post_id, 'branding', $branding);
    }
}

new ModusPostTypes();



