<?php
/**
 * The template for displaying top product content within loops
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div <?php post_class(); ?>>
	<?php
    if ( ! defined( 'ABSPATH' ) ) {
    	exit; // Exit if accessed directly
    }
    global $woocommerce,$product;
    if ( empty( $product ) || ! $product->is_visible() ) {
    	return;
    }
    ?>
    <div class="product-thumbnails">
    	<a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
		<?php echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . _n( '','', count( $product->get_category_ids() ), 'modus' ) . ' ', '</span>' ); ?>

        <?php the_post_thumbnail('modus-blog-3'); ?>
    </div>
    <div class="price-product"><?php echo woocommerce_template_loop_price();?>
        <?php
        $rating_count = $product->get_rating_count();
        $review_count = $product->get_review_count();
        $average      = $product->get_average_rating();
        if ( $rating_count > 0 ) : ?>
            <div class="rated">
                <div class="star-rating">
                    <span style="width:<?php echo ( ( $average / 5 ) * 100 ); ?>%"></span>
                </div>
            </div>
        <?php endif;
        if ( $rating_count == 0 ) :
            ?>
            <div class="rated">
                <div class="star-rating">
                </div>
            </div>
        <?php endif; ?>
    </div>
    <div class="btn-cart-in">
	    <ul>
	    	<li> <?php woocommerce_template_loop_add_to_cart();?></li>
        	<?php
                if (class_exists('YITH_WCWL')) {
                    echo '<li> <div class="btn-share btn-wishlist">';
                        echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                    echo '</div></li>';
                }
            ?>
    		<?php
    			if(class_exists( 'YITH_WOOCOMPARE' ) ) {
                    echo '<li><div class="btn-share btn-compare">';
                        printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-copy-file"></i></a></div>', modus_add_compare_action( get_the_ID() ), 'add_to_compare compare button', get_the_ID(), esc_html__('Compare', 'modus'));
                    echo '</div></li>';
                }
    		?>
    		<?php
    			 if(class_exists( 'YITH_WCQV')){
                    echo '<li><div class="btn-share btn-view">';
                    printf('<a onclick="" href="#" class="yith-wcqv-button" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-search"></i></a>', get_the_ID(), esc_html__('Quick View', 'modus'));
                    echo '</div></li>';
                }
    		?>
	    </ul>
	</div>
</div>
