<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $related_products ) : ?>

	<section class="related products">

		<h2><span><?php esc_html_e( 'Related products', 'modus' ); ?></span></h2>
		<div class="initSlide_product" data-columns="4" data-rows="1">
			<div class="beans-stepslider" data-rotate="true">
                <div class="beans-mask">
                    <div class="beans-slideset">
						<?php foreach ( $related_products as $related_product ) : ?>
							<div class="beans-slide">
							<?php
							 	$post_object = get_post( $related_product->get_id() );

								setup_postdata( $GLOBALS['post'] =& $post_object );

								wc_get_template_part( 'content', 'product-grid-2' ); ?>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
				<a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
                <a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
			</div>
		</div>
	</section>

<?php endif;

wp_reset_postdata();
