<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$shop_config = modus_settings();
$shop_single_show_breadcrum = '';
if ( isset( $shop_config['single_product_breadcrumb'] ) ) :
	$shop_single_show_breadcrum = $shop_config['single_product_breadcrumb'];
endif;
get_header();
?>
<div id="primary" class="content-area">
	<main id="main" class="site-main padding-top-30 padding-bottom-70">
		<div class="container">
			<?php if ( $shop_single_show_breadcrum == 'show' ) : ?>
				<div class="bread-crumb">
					<?php echo modus_breadcrumbs(); ?>
				</div>
			<?php endif; ?>
			<?php
				/**
				 * woocommerce_before_main_content hook.
				 *
				 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
				 * @hooked woocommerce_breadcrumb - 20
				 */
				do_action( 'woocommerce_before_main_content' );
			?>

				<?php while ( have_posts() ) : the_post(); ?>

					<?php wc_get_template_part( 'content', 'single-product' ); ?>

				<?php endwhile; // end of the loop. ?>

			<?php
				/**
				 * woocommerce_after_main_content hook.
				 *
				 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
				 */
				do_action( 'woocommerce_after_main_content' );
			?>
		</div>
	</main>
</div>
<?php get_footer(); ?>
