<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product;
$review_count = $product->get_review_count();
$rating_count = $product->get_rating_count();

$shop_config = modus_settings();
$sidebars = 'product_single_sidebar';
$sidebar_position = 'left-sidebar';

if(isset($shop_config['product_single_sidebar_position'])){
	$sidebar_position = $shop_config['product_single_sidebar_position'];
}
if(isset($shop_config['product_single_sidebar']) && $shop_config['product_single_sidebar']!=''){
	$sidebars = $shop_config['product_single_sidebar'];
}
if ( isset($_GET['sidebar']) && (in_array($_GET['sidebar'], array('left-sidebar','right-sidebar','none'))) ){
	$sidebar_position = $_GET['sidebar'];
}
$class_sidebar = "";
if( $sidebar_position == 'left-sidebar'){
	$class_sidebar = 'sidebar_left';
	$wrap_content = 'col-md-9 col-xs-12 col-sm-12 right';
} else if( $sidebar_position == 'right-sidebar'){
	$class_sidebar = 'sidebar_right';
	$wrap_content = 'col-md-9 col-xs-12 col-sm-12';
} else {
	$wrap_content = 'col-md-12 col-xs-12 col-sm-12';
}
?>

<?php
	/**
	 * woocommerce_before_single_product hook.
	 *
	 * @hooked wc_print_notices - 10
	 */
	 do_action( 'woocommerce_before_single_product' );

	 if ( post_password_required() ) {
	 	echo get_the_password_form();
	 	return;
	 }
?>
<?php  ?>
<div itemscope id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="row">
		<div class="<?php echo esc_attr($wrap_content); ?>">
			<div class="modus-single-product">
				<div class="row">
					<div class="col-md-5">
						<?php
							/**
							 * woocommerce_before_single_product_summary hook.
							 *
							 * @hooked woocommerce_show_product_sale_flash - 10
							 * @hooked woocommerce_show_product_images - 20
							 */
							do_action( 'woocommerce_before_single_product_summary' );
						?>
					</div>
					<div class="col-md-7">
						<div class="modus-block modus-border-bt">
							<div class="modus-block-left">
								<h1><?php the_title(); ?></h1>
								<div class="ct-product-right">
								    <?php
								    $rating_count = $product->get_rating_count();
									$review_count = $product->get_review_count();
									$average      = $product->get_average_rating();
									if ( $rating_count > 0 ) : ?>
										<div class="rated">
											<div class="star-rating">
												<span style="width:<?php echo ( ( $average / 5 ) * 100 ); ?>%"></span>
											</div>
										</div>
									<?php endif;
									if ( $rating_count == 0 ) :
										?>
										<div class="rated">
											<div class="star-rating">
											</div>
										</div>
										<?php
											if ( comments_open() ) : ?>
												<div class="md-single-review">
													<span>
														<?php
														if ($review_count == 1) {
															printf( _n( '%s review', '%s review', $review_count, 'modus' ), '<span itemprop="reviewCount" class="count">' . $review_count . '</span>' );
														} else {

														 printf( _n( '%s reviews', '%s reviews', $review_count, 'modus' ), '<span itemprop="reviewCount" class="count">' . $review_count . '</span>' ); }
														?>
												
													</span>
													<a href="#reviews" class="woocommerce-review-link" rel="nofollow">
													<?php printf( _n( 'Add a review', 'Add a review', $review_count, 'modus' ), '<span itemprop="reviewCount" class="count">' . $review_count . '</span>' ); ?></a>
												</div>
										<?php
											endif;
										?>
									<?php endif;
									if ( $rating_count > 0 ) :
										if ( comments_open() ) : ?>
											<div class="md-single-review">
												<span>
													<?php printf( _n( '%s review', '%s reviews', $review_count, 'modus' ), '<span itemprop="reviewCount" class="count">' . $review_count . '</span>' ); ?>
												</span>
												<a href="#reviews" class="woocommerce-review-link" rel="nofollow">
												<?php printf( _n( 'Add a review', 'Add a review', $review_count, 'modus' ), '<span itemprop="reviewCount" class="count">' . $review_count . '</span>' ); ?></a>
											</div>
									<?php
										endif;
									endif; ?>
								</div>
								<?php echo woocommerce_template_single_meta();?> 
								<?php modus_get_terms(get_the_ID()); ?>

							</div>  
							<?php echo woocommerce_template_single_excerpt();?> 
							 

							<div class="modus-block-left-1">
								<?php echo woocommerce_template_loop_price();?>
								<div class="uni-cpo-total"></div>
							</div>
						</div>
						<div class="buttons-block">
							<?php echo woocommerce_template_single_add_to_cart(); ?>
							<div class="list-bottom">
							    <div class="share-yith">
									<?php
					                if (class_exists('YITH_WCWL')) {
					                    echo ' <div class="btn-share btn-wishlist">';
					                        echo do_shortcode('[yith_wcwl_add_to_wishlist]');
					                    echo '</div>';
					                }
					                if(class_exists( 'YITH_WOOCOMPARE' ) ) {
					                    echo '<div class="btn-share btn-compare">';
					                        printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-copy-file"></i></a></div>', modus_add_compare_action( get_the_ID() ), 'add_to_compare compare button', get_the_ID(), esc_attr__('Compare', 'modus'));
					                    echo '</div>';
					                }
					                ?>
									<?php 
									if(isset($shop_config['product_single_share']) && $shop_config['product_single_share'] =='show'):
										if ( $shop_config['modus_mail'] != '' ) : ?> <div class="btn-share"><div class="add-to"><a href="mailto:<?php echo esc_attr($shop_config['modus_mail']); ?>" title="<?php esc_attr_e('Send Mail','modus'); ?>" class="button"><i class="Pe-icon-7-stroke-mail"></i></a></div></div>
									<?php endif; 
									endif;  
									?>
									
								</div>
							</div>
						</div> 
						<?php if(isset($shop_config['product_single_share']) && $shop_config['product_single_share'] =='show'):?>
						<div class="share-links">
							<div class="addthis_sharing_toolbox">
								<div class="f-social"><?php echo esc_html__('Share this','modus');?></div>
								<ul>
									<li><a href="http://www.facebook.com/sharer.php?u=<?php echo urlencode(get_the_permalink()); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
									<li><a href="https://twitter.com/share?url=<?php echo urlencode(get_the_permalink()); ?>&amp;text=<?php echo urlencode(get_the_title()); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
									<li><a href="https://plus.google.com/share?url=<?php the_permalink();?>" target="_blank"><i class="fa fa-google-plus"></i></a></li>
									<li><a href="http://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_the_permalink()); ?>&amp;title=<?php echo urlencode(get_the_title()); ?>" target="_blank"><i class="fa fa-pinterest"></i></a>
									<li><a href="http://www.linkedin.com/shareArticle?url=<?php echo urlencode(get_the_permalink()); ?>&amp;title=<?php echo urlencode(get_the_title()); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
									</li>
								</ul>

							</div>
						</div> 
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
		<?php
			if( $sidebar_position != 'none' ){ ?>
			<div class="col-md-3 col-xs-12 col-sm-12 single_product_sidebar <?php echo  $class_sidebar ; ?>">
				<div class="sidebar">
					<?php dynamic_sidebar($sidebars ); ?>
				</div>
			</div>
		<?php
			}
		?>
	</div>
	<?php
		/**
		 * woocommerce_after_single_product_summary hook.
		 *
		 * @hooked woocommerce_output_product_data_tabs - 10
		 * @hooked woocommerce_upsell_display - 15
		 * @hooked woocommerce_output_related_products - 20
		 */
		do_action( 'woocommerce_after_single_product_summary' );
	?>
	<meta itemprop="url" content="<?php the_permalink(); ?>" />

</div><!-- #product-<?php the_ID(); ?> -->

<?php //do_action( 'woocommerce_after_single_product' ); ?>
