<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<li <?php post_class(); ?>>
	<?php

    if ( ! defined( 'ABSPATH' ) ) {
    	exit; // Exit if accessed directly
    }

    global $woocommerce,$product;

    // Ensure visibility
    if ( empty( $product ) || ! $product->is_visible() ) {
    	return;
    }
    ?>
    <div class="product-thumbnails">
        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
        <div class="btn-cart-in">
            <div class="midle"> 
				<div class="share-yith">
					<div class="btn-share btn-addtocart">
						<?php woocommerce_template_loop_add_to_cart();?>
					</div> 
					<?php
					if (class_exists('YITH_WCWL')) {
						echo ' <div class="btn-share btn-wishlist">';
							echo do_shortcode('[yith_wcwl_add_to_wishlist]');
						echo '</div>';
					}
					if(class_exists( 'YITH_WOOCOMPARE' ) ) {
						echo '<div class="btn-share btn-compare">';
							printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s modus_tltp" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-copy-file"></i></a></div>', modus_add_compare_action( get_the_ID() ), 'add_to_compare compare button', get_the_ID(), esc_html__('Compare', 'modus'));
						echo '</div>';
					}
					if(class_exists( 'YITH_WCQV')){
						echo '<div class="btn-share btn-view">';
						printf('<a onclick="" href="#" class="yith-wcqv-button modus_tltp" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-look"></i></a>', get_the_ID(), esc_html__('Quick View', 'modus'));
						echo '</div>';
					}
					?>
				</div> 
			</div>
		</div>
    </div>
    <div class="info-bottom">
        <div class="ct-product-right">
            <a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
            <div class="price-product"><?php echo woocommerce_template_loop_price();?>
                <?php
                $rating_count = $product->get_rating_count();
                $review_count = $product->get_review_count();
                $average      = $product->get_average_rating();
                if ( $rating_count > 0 ) : ?>
                    <div class="rated">
                        <div class="star-rating">
                            <span style="width:<?php echo ( ( $average / 5 ) * 100 ); ?>%"></span>
                        </div>
                    </div>
                <?php endif;
                if ( $rating_count == 0 ) :
                    ?>
                    <div class="rated">
                        <div class="star-rating">
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</li>
