<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product,$post;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div <?php post_class(); ?>>
	<div class="row">
		<div class="col-xs-12 col-sm-3 col-md-3">
			<div class="product-thumbnails">
				<a href="<?php the_permalink();?>"><?php the_post_thumbnail( 'modus-image-product-list-layout' ); ?> </a>
				<?php 
					if(class_exists( 'YITH_WCQV')){
						echo '<div class="btn-share btn-view">';
						printf(' <a onclick="" href="#" class="yith-wcqv-button button" data-product_id="%d" >%s</a> ', get_the_ID(), esc_html__('Quick View', 'modus'));
						echo '</div>';
					}
				?>
			</div>
		</div>
		<div class="col-xs-12 col-sm-9 col-md-9">
			<a href="<?php the_permalink();?>" title="<?php the_title();?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
			<?php
            $rating_count = $product->get_rating_count();
            $review_count = $product->get_review_count();
            $average      = $product->get_average_rating();
            if ( $rating_count > 0 ) : ?>
                <div class="rated">
                    <div class="star-rating">
                        <span style="width:<?php echo ( ( $average / 5 ) * 100 ); ?>%"></span>
                    </div>
                </div>
            <?php endif;
            if ( $rating_count == 0 ) :
                ?>
                <div class="rated">
                    <div class="star-rating">
                    </div>
                </div>
            <?php endif; ?>
		    <div class="short-description">
		    	<?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ?>
		    </div>
		    <div class="format-price-addcart">
				<div class="price-product">
					<?php echo woocommerce_template_loop_price();?>
					<?php if(null!==get_post_meta( $product->get_id(), '_unit_price', true )&&get_post_meta( $product->get_id(), '_unit_price', true )!=''): ?>
					<span class="unit-price"><?php echo esc_html__('/', 'modus'); ?><?php echo esc_html(get_post_meta( $product->get_id(), '_unit_price', true ) );?></span>
					<?php endif; ?>
				</div>
			</div>
			<div class="list-bottom">
				<div class="btn-cart btn-share btn-addtocart"><?php woocommerce_template_loop_add_to_cart();?></div>
			    <div class="share-yith">
					<?php
	                if (class_exists('YITH_WCWL')) {
	                    echo ' <div class="btn-share btn-wishlist">';
	                        echo do_shortcode('[yith_wcwl_add_to_wishlist]');
	                    echo '</div>';
	                }
	                if(class_exists( 'YITH_WOOCOMPARE' ) ) {
	                    echo '<div class="btn-share btn-compare">';
	                        printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-copy-file"></i></a></div>', modus_add_compare_action( get_the_ID() ), 'add_to_compare compare button', get_the_ID(), esc_html__('Compare', 'modus'));
	                    echo '</div>';
	                }
	                ?>
				</div>
			</div>
		</div>
	</div>
</div>
