<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div class="item-list list-type1">
	<div <?php post_class(); ?>>
		<div class="row">
			<div class="col-md-5 col-xs-5 padding-right-0">
				<div class="product-thumbnails type-list">
					<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'modus-image-product-list' ); ?></a> 
					<?php
						if(class_exists( 'YITH_WCQV')){
							echo '<div class="btn-share btn-view">';
							printf('<div class="add-to"><a onclick="" href="#" class="yith-wcqv-button button" data-toggle="tooltip" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-look"></i></a></div>', get_the_ID(), esc_html__('Quick View', 'modus'));
							echo '</div>';
						}
	                ?>
				</div>
			</div>
			<div class="col-md-7 col-xs-7">
				<div class="ct-product-right">
					<a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
				    <div class="price-product">
						<?php echo woocommerce_template_loop_price();?>
						<?php if(null!==get_post_meta( $product->get_id(), '_unit_price', true )&&get_post_meta( $product->get_id(), '_unit_price', true )!=''): ?>
						<span class="unit-price"><?php echo esc_html__('/', 'modus'); ?><?php echo esc_html(get_post_meta( $product->get_id(), '_unit_price', true ) );?></span>
						<?php endif; ?>
					</div>
					<?php
				    $rating_count = $product->get_rating_count();
					$review_count = $product->get_review_count();
					$average      = $product->get_average_rating();
					if ( $rating_count > 0 ) : ?>
						<div class="rated">
							<div class="star-rating">
								<span style="width:<?php echo ( ( $average / 5 ) * 100 ); ?>%"></span>
							</div>
						</div>
					<?php endif;
					if ( $rating_count == 0 ) :
						?>
						<div class="rated">
							<div class="star-rating">
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>
