<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $woocommerce,$product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div class="item-grid grid-type9">
    <div <?php post_class(); ?>>
        <div class="product-thumbnails">
            <a href="<?php the_permalink(); ?>">
                <?php the_post_thumbnail('modus-blog-3'); ?>

            </a>
        </div>
        <div class="info-bottom">
            <a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
            <div class="price-product">
                <?php echo woocommerce_template_loop_price();?>
                <?php if(null!==get_post_meta( $product->get_id(), '_unit_price', true )&&get_post_meta( $product->get_id(), '_unit_price', true )!=''): ?>
                <span class="unit-price"><?php echo esc_html__('/', 'modus'); ?><?php echo esc_html(get_post_meta( $product->get_id(), '_unit_price', true ) );?></span>
                <?php endif; ?>
            </div>
            <a class="view-detail-bottom" href="<?php the_permalink(); ?>" ><?php echo esc_html__('View detail','modus');?><i class="fa fa-arrow-right"></i></a>
        </div>
    </div>
</div>