<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.7
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div class="item-grid grid-type8">
	<div <?php post_class(); ?>>
		<div class="product-thumbnails">
			<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'modus-blog-3' ); ?></a>
		</div>
		<div class="info-product">
			<div class="midle">

				<?php 
		            $item_width_2 = get_post_meta(get_the_ID(), 'product_column_width', true); 
		            $banner = get_post_meta(get_the_ID(), 'banner_link_url', true); 
		            $banner_title = get_post_meta(get_the_ID(), 'banner_link_title', true);
		        ?>
				
				 <?php if(($banner_title && $banner_title != '') && ($item_width_2 && $item_width_2 != '') ):?>
					<div class="banner-product">
						<?php if($banner && $banner != ''):?>
							<h2><a href="<?php echo esc_url($banner , 'modus');?>"><?php echo wp_kses($banner_title,array());?></a></h2>
							 <?php else: ?>
							 <h2><?php echo wp_kses($banner_title,array());?></h2>
						<?php endif; ?>  
					</div>
					<a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
				<?php else: ?>
				<a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
			    <div class="price-product">
					<?php echo woocommerce_template_loop_price();?>
					<?php if(null!==get_post_meta( $product->get_id(), '_unit_price', true )&&get_post_meta( $product->get_id(), '_unit_price', true )!=''): ?>
					<span class="unit-price"><?php echo esc_html__('/', 'modus'); ?><?php echo esc_html(get_post_meta( $product->get_id(), '_unit_price', true ) );?></span>
					<?php endif; ?>
				</div>
			    <?php woocommerce_template_loop_add_to_cart(); ?>
				
				<?php endif;?>
			</div>
		</div>
	</div>
</div>