<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $woocommerce,$product, $modus_settings;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div class="item-grid grid-type5">
    <div <?php post_class(); ?>>
        <div class="product-thumbnails">
            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('modus-blog-3'); ?></a>
            <a class="view-more" href="<?php the_permalink(); ?>"><span> <?php echo esc_html__('View detail','modus');?></span></a>
        </div>
        <div class="info-bottom">
            <a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
            <div class="price-product">
                <?php echo woocommerce_template_loop_price();?>
                <?php if(null!==get_post_meta( $product->get_id(), '_unit_price', true )&&get_post_meta( $product->get_id(), '_unit_price', true )!=''): ?>
                <span class="unit-price"><?php echo esc_html__('/', 'modus'); ?><?php echo esc_html(get_post_meta( $product->get_id(), '_unit_price', true ) );?></span>
                <?php endif; ?>
            </div>
            <?php if(isset($modus_settings['product-cart']) && $modus_settings['product-cart']):?>
            <a class="view-detail" href="<?php the_permalink(); ?>"><span><?php echo esc_html($product->add_to_cart_text()); ?></span></a>
            <?php endif;?>
        </div>
    </div>
</div>