<?php
/**
 * The template for displaying top product content within loops
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div class="item-grid grid-type-4">
    <div <?php post_class(); ?>>
    	<?php
        if ( ! defined( 'ABSPATH' ) ) {
        	exit; // Exit if accessed directly
        }
        global $woocommerce,$product;
        if ( empty( $product ) || ! $product->is_visible() ) {
        	return;
        }
        ?>
        <div class="product-thumbnails">
        	<a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
    		<?php echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . _n( '','', count( $product->get_category_ids() ), 'modus' ) . ' ', '</span>' ); ?>
            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('modus-blog-3'); ?></a>
        </div>
        <div class="price-product">
			<?php echo woocommerce_template_loop_price();?>
			<?php if(null!==get_post_meta( $product->get_id(), '_unit_price', true )&&get_post_meta( $product->get_id(), '_unit_price', true )!=''): ?>
			<span class="unit-price"><?php echo esc_html__('/', 'modus'); ?><?php echo esc_html(get_post_meta( $product->get_id(), '_unit_price', true ) );?></span>
			<?php endif; ?>
		</div>
        <div class="btn-cart-in">
    	    <ul>
    	    	<li class="modus-btn-cart-2 btn-share btn-addtocart"> 
					<?php woocommerce_template_loop_add_to_cart();?>
				</li>
            	<?php
                     if(class_exists('YITH_WCWL') || class_exists( 'YITH_WOOCOMPARE' ) || class_exists( 'YITH_WCQV')){ 
						if (class_exists('YITH_WCWL')) {
							echo ' <li class="btn-share btn-wishlist">';
								echo do_shortcode('[yith_wcwl_add_to_wishlist]');
							echo '</li>';
						}
						if(class_exists( 'YITH_WOOCOMPARE' ) ) {
							echo '<li class="btn-share btn-compare">';
								printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s" data-product_id="%d" title="%s"  data-placement="left"><i class="Pe-icon-7-stroke-copy-file"></i></a></div>', modus_add_compare_action( get_the_ID() ), 'add_to_compare compare button', get_the_ID(), esc_attr__('Compare', 'modus'));
							echo '</li>';
						}
						if(class_exists( 'YITH_WCQV')){
							echo '<li class="btn-share btn-view">';
							printf('<div class="add-to"><a onclick="" href="#" class="yith-wcqv-button button" data-toggle="tooltip" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-search"></i></a></div>', get_the_ID(), esc_attr__('Quick View', 'modus'));
							echo '</li>';
						}  
					}  
        		?>
    	    </ul>
    	</div>
    </div>
</div>
