<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $woocommerce,$product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div class="item-grid grid-type10">
    <div <?php post_class(); ?>>
        <div class="product-thumbnails">
            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('modus-blog-3'); ?></a>
            <div class="share-yith">
				<div class="btn-share btn-addtocart">
					<?php woocommerce_template_loop_add_to_cart();?>
				</div>
                <?php
					modus_share_yith();
                ?>
            </div>
        </div>
        <div class="info-bottom">
            <div class="ct-product-center">  
                <a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
                <div class="price-product">
					<?php echo woocommerce_template_loop_price();?>
					<?php if(null!==get_post_meta( $product->get_id(), '_unit_price', true )&&get_post_meta( $product->get_id(), '_unit_price', true )!=''): ?>
						<span class="unit-price"><?php echo esc_html__('/', 'modus'); ?><?php echo esc_html(get_post_meta( $product->get_id(), '_unit_price', true ) );?></span>
					<?php endif; ?>
                </div>
            </div>
             <a class="view-detail" href="<?php the_permalink(); ?>"><span><?php echo esc_html($product->add_to_cart_text()); ?></span></a>
        </div>
    </div>
</div>