<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

get_header( 'shop' );
global $product;
global $yith_woocompare;
$modus_sidebar_position = '';
$modus_sidebars_id = '';
$modus_cat_layout ='';
$modus_col = '';
$modus_item = '';
$cate_class = '';
$shop_config = modus_settings();
if ( isset( $_GET['shop_layout'] ) ){
    $modus_cat_layout = $_GET['shop_layout'];
}else{
    $modus_cat_layout = $shop_config['shop_layout'];
}
if ( isset($_GET['shop_sidebar_position']) && (in_array($_GET['shop_sidebar_position'], array('left-sidebar','right-sidebar','none'))) ){
    $modus_sidebar_position = $_GET['shop_sidebar_position'];
}else{
    $modus_sidebar_position = $shop_config['product_categories_sidebar_position'];
}
$modus_sidebars_id = $shop_config['product_categories_sidebar'];
$modus_sidebars_id_1 = $shop_config['product_categories_sidebar_1'];
$shop_sortby = $shop_config['shop_sortby'];
if($modus_sidebar_position == 'left-sidebar' ){
    $modus_class_sidebar = 'sidebar_left';
    $modus_wrap_content = 'col-xs-12 col-sm-12 col-md-9 right';
}else if( $modus_sidebar_position == 'right-sidebar' ){
    $modus_class_sidebar = 'sidebar_right';
    $modus_wrap_content = 'col-xs-12 col-sm-12 col-md-9';
}else{
    $modus_class_sidebar ='none';
    $modus_wrap_content='col-xs-12 col-sm-12 col-md-12';
}
if ( isset( $_GET['shop_col'] ) ){
    $modus_col = $_GET['shop_col'];
}else{
    $modus_col = $shop_config['column'];
}
if($modus_cat_layout=='metro') $modus_col =4;
if($modus_col == 2){
    $modus_class_col = 'column_2 ';
}elseif($modus_col == 3){
    $modus_class_col = 'column_3 ';
}elseif($modus_col == 4){
    $modus_class_col = 'column_4 ';
}elseif($modus_col == 5){
    $modus_class_col = 'column_5 ';
}elseif($modus_col == 6){
    $modus_class_col = 'column_6 ';
}
$shop_show_breadcrum = '';
if ( isset( $shop_config['archive_product_breadcrumb'] ) ) :
    $shop_show_breadcrum = $shop_config['archive_product_breadcrumb'];
endif;
if ( isset( $_GET['archive_width'] ) ){
    $modus_layout_site = $_GET['archive_width'];
}else{
    $modus_layout_site = $shop_config['archive_width'];
}

if ( isset( $_GET['shop_layout_item'] ) ){
    $modus_item = $_GET['shop_layout_item'];
}else{
    $modus_item = $shop_config['shop_layout_item'];
}
if ($modus_cat_layout == 'metro' ){
	 $modus_item = 'layout-8';
}
$modus_cate_layout = isset($shop_config['archive_product_sub'])?$shop_config['archive_product_sub']:'';
if ($modus_cate_layout == 'slide' ){
	$cate_class = 'category-slide';
}else{
	$cate_class = '';
}

$show_title = 'show';
?>
<div id="primary-shop" class="content-area">
	<?php if($show_title == 'show' && $shop_show_breadcrum == 'show' ):?>
		<div class="breadcrumb-container">
			<div class="bottom-breadcrumb">
				<div class=" container">
					<?php if($show_title == 'show'){ ?>
					<div class="page-title">
						<h1><?php woocommerce_page_title(); ?></h1>
					</div>
					<?php } ?>          
					<?php if ( $shop_show_breadcrum == 'show' ) : ?>                    
						<div class="bread-crumb">
							<?php echo modus_breadcrumbs(); ?>
						</div>
					<?php endif; ?>
				</div> 
			</div> 
		</div>  
	<?php endif;?>  
	<?php $display_type = woocommerce_get_loop_display_mode(); ?>
	<div id="main-shop" class="site-main padding-top-30 padding-bottom-70">
		<?php if ( $modus_sidebar_position == ""): ?>
		<div id="myModal" class="modal fade modal-archive" role="dialog">
		  <div class="modal-dialog">
			<!-- Modal content-->
			<div class="modal-content">
				<div class="modus-header-modal">
					<?php echo esc_html__( 'FILTER','modus' );?>
					 <a href="#" class="button-press Pe-icon-7-stroke-close" data-dismiss="modal"></a>
				</div>
				<div class="shop_sidebar">
					<div class="sidebar sidebarArea">
						<?php if( is_active_sidebar( $modus_sidebars_id_1 ) ){
							dynamic_sidebar($modus_sidebars_id_1 );
						} ?>
					</div>
				</div>
			</div>
		  </div>
		</div>
		<?php endif;?>    
		<?php
			if( $modus_layout_site == 'full-site' ) echo '<div class="container">';
			if( $modus_layout_site == 'full-width' ) echo '<div class="container-full-width">';
		?>
		  
			<div class="row">
				<div class="<?php echo esc_attr($modus_wrap_content); ?>">
					<?php if ( 'subcategories' === $display_type || 'both' === $display_type ) : ?>
						<div class="category <?php echo esc_attr($cate_class); ?>">
							<ul class="cate-archive clearfix">
								<?php woocommerce_show_subcategories(); ?>
							</ul>
						</div>
					<?php endif; ?>
					<?php if ( 'products' === $display_type || 'both' === $display_type ) : ?>
						<?php if( $modus_layout_site == 'full-site' ): ?>
							<?php
								/**
								 * Hook: woocommerce_archive_description.
								 *
								 * @hooked woocommerce_taxonomy_archive_description - 10
								 * @hooked woocommerce_product_archive_description - 10
								 */
								do_action( 'woocommerce_archive_description' );
							?>
							<?php if( ! is_product_category() ): ?>
							<div class="shop-title">
								<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
									<h2 class="page-title"><?php woocommerce_page_title(); ?></h2>
								<?php endif; ?>
								<?php   echo woocommerce_result_count(); ?>
							</div>
							<?php endif; ?>
						<?php endif; ?>
						<?php if( $modus_layout_site == 'full-width' ): ?>
							<?php
								do_action( 'woocommerce_before_main_content' );
							?>
						<?php endif; ?>
					<?php endif; ?>
					<?php if ( have_posts() ) :
						?>
						<?php if ( 'products' === $display_type || 'both' === $display_type ) : ?>
							<div class="show-all">
								<div class="row">
									<div class="col-md-12 col-sm-12 col-xs-12 show-left">
									   <?php if ( $modus_sidebar_position == ""): ?>
										<a class="btn-show-modal" href="#" data-toggle="modal" data-target="#myModal"><i class="Pe-icon-7-stroke-edit"></i><span><?php echo esc_html__('Filer Options','modus'); ?></span></a>
									<?php endif;?>
										<ul class="list-view-as">
											<li class="two-2"><a href="#" id="grid2" data-layout="layout-grid" data-column ="2" <?php if(($modus_cat_layout == 'grid' || $modus_cat_layout == 'metro') && ($modus_col == 2))  echo 'class="active"'; ?>><i class="modusicon-grid2"></i></a></li>
											<li class="three-2"><a href="#" id="grid3" data-layout="layout-grid" data-column ="3" <?php if(($modus_cat_layout == 'grid' || $modus_cat_layout == 'metro') && ($modus_col == 3 )){echo 'class="active"';}   ?>><i class="modusicon-grid3"></i></a></li>
											<li class="four-2"><a href="#" id="grid4" data-layout="layout-grid" data-column ="4" <?php if(($modus_cat_layout == 'grid' || $modus_cat_layout == 'metro') && ($modus_col == 4 ))  echo 'class="active"'; ?>><i class="modusicon-grid4"></i></a></li>
											<li class="list-last" ><a href="#" id="list1" data-layout="layout-list" <?php if($modus_cat_layout =='list') echo 'class="active"'; ?>><i class="modusicon-list"></i></a></li>
										</ul>
										<div class="soft-category">
											<?php echo esc_html__( 'Soft by','modus' );?>
											<?php if(isset($shop_sortby) && $shop_sortby == 'default'): ?>
												<?php echo woocommerce_catalog_ordering(); ?>
											<?php else: ?>
												<?php if (isset($shop_config['single_product_sort_by']) &&
														$shop_config['single_product_sort_by'] == 'default'):?>
													<ul class="select-default">
															<?php do_action('sort') ?>
													</ul>

													<?php else: ?>
													<a class="all" href="">--</a>
													<ul class="select-cateogry">
													<?php
														$terms = get_terms( 'product_cat' );
														if(is_array($terms)){
															foreach ($terms as $term) {
																$term_link = get_term_link( $term );
																echo '<li><a href="' . esc_url( $term_link ) .'" title="'.$term->name.'">'.esc_attr( $term->name ).'</a></li>';
															}
														}
												?>
												</ul>
												<?php endif; ?>
											<?php endif; ?>
											
										</div>
										<div class="lt-show">
											<p><?php  esc_html_e('Show','modus'); ?></p>
											<div class="custom_select">
												<?php $modus_perpage = get_query_var('posts_per_page');?>
												<div class="select_title"><?php echo esc_html($modus_perpage); ?></div>
												<ul class="select_list">
													<?php 
														$arr_num_shows = array('6','9','12','15','18','24','30');
														foreach($arr_num_shows as $arr_num_show){
															echo '<li class="tr_delay fs_medium"><a class="color_grey" href="'. esc_url( add_query_arg( 'modus_perpage', $arr_num_show ) ) .'">'. esc_html($arr_num_show) .'</a></li>';
														}
													?>
												</ul>
											</div>
											<p><?php  esc_html_e('per page','modus'); ?></p>
										</div>
									</div> 
								</div>
							</div>
							<div class="products <?php
								if($modus_cat_layout == 'grid') echo ' grid';
								else if ($modus_cat_layout == 'list') echo ' list';
								else if ($modus_cat_layout == 'metro') echo ' metro grid';
								?>">
								<div class="layout-grid layout-metro <?php echo esc_attr($modus_class_col) ; if( $modus_cat_layout == 'grid' || $modus_cat_layout == 'metro' )  echo ' active';?>">
									<div class="row">
										<?php if ($modus_cat_layout == 'metro' ) echo '<div class="icotop-holder">'; ?>
										
											<?php
											while ( have_posts() ) : the_post();
												global $product;
												$featured = "";
												if ($product->is_featured()) {
													$featured = " featured";
												}
												echo'<div class="modus-column-custom'. esc_attr($featured) .'">';
													switch ( $modus_item ) {
														case 'layout-1':
															wc_get_template_part( 'content', 'product-grid' );
															break;
														case 'layout-2':
															wc_get_template_part( 'content', 'product-grid-2' );
															break;
														case 'layout-3':
															wc_get_template_part( 'content', 'product-grid-3' );
															break;
														case 'layout-4':
															wc_get_template_part( 'content', 'product-grid-4' );
															break;
														case 'layout-5':
															wc_get_template_part( 'content', 'product-grid-5' );
															break;
														case 'layout-6':
															wc_get_template_part( 'content', 'product-grid-6' );
															break;
														case 'layout-7':
															wc_get_template_part( 'content', 'product-grid-7' );
															break;
														case 'layout-8':
															 wc_get_template_part( 'template-parts/content', 'product-metro' );
															break;
                                                        case 'layout-9':
                                                            wc_get_template_part( 'content', 'product-grid-9' );
                                                            break;
                                                        case 'layout-10':
                                                            wc_get_template_part( 'content', 'product-grid-10' );
                                                            break;
														default:
															wc_get_template_part( 'content', 'product-grid-2' );
															break;
													}
												echo '</div>';
											endwhile; // end of the loop.
											wp_reset_postdata();
										?>
										
										<?php if ($modus_cat_layout == 'metro' ) echo '</div>'; ?>
									</div>
								</div>
								<div class="layout-list <?php if( $modus_cat_layout == 'list' )  echo ' active';?>">
									<?php
									echo '<ul class="products-type">';
										while ( have_posts() ) : the_post();
											echo'<li>';
												wc_get_template_part( 'content', 'product-list-layout' );
											echo '</li>';
										endwhile; // end of the loop.
										wp_reset_postdata();
									echo '</ul>';
									?>
								</div>
								<div class="shop-bottom">
									<?php echo woocommerce_result_count();?>

									<?php
										/**
										 * woocommerce_after_shop_loop hook.
										 *
										 * @hooked woocommerce_pagination - 10
										 */
										do_action( 'woocommerce_after_shop_loop' );
									?>
								</div>
							</div>
						<?php endif; ?>
						<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

							<?php wc_get_template( 'loop/no-products-found.php' ); ?>

					<?php endif; ?>
					<?php if( $modus_sidebar_position == 'left-sidebar' || $modus_sidebar_position == 'right-sidebar' ): ?>
					<?php else: ?>
						<?php
							/**
							 * woocommerce_after_main_content hook.
							 *
							 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
							 */
							do_action( 'woocommerce_after_main_content' );
						?>
					<?php endif; ?>
				</div>
				<?php
				if( $modus_sidebar_position == 'left-sidebar' || $modus_sidebar_position == 'right-sidebar' ){ ?>
					<div class="col-md-3 col-xs-12 col-sm-12 shop_sidebar <?php echo esc_attr( $modus_class_sidebar ); ?>">
						<div class="sidebar sidebarArea">
							<?php if( is_active_sidebar( $modus_sidebars_id ) ){
								dynamic_sidebar($modus_sidebars_id );
							} ?>
						</div>
					</div>
				<?php
					}
				?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>
