<?php
/**
 * The template part for displaying single posts
 *
 * @package WordPress
 * @subpackage Modus
 * @since Modus 1.0
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="port-single layout_1">

        <div>
            <div class="padding-bottom-20">                
                <?php
                    $client = get_post_meta( get_the_ID(), 'client', true );
                    $materials = get_post_meta( get_the_ID(), 'materials', true );
                    $website = get_post_meta( get_the_ID(), 'website', true );
                    $branding = get_post_meta( get_the_ID(), 'branding', true );
                    $post_date = get_the_date( 'j F Y' );
                    $attachment_id = get_post_thumbnail_id();
                    $image_alt = modus_get_attachment($attachment_id, 'full');
                ?>              
                <div class="content_port">
                    <div class="row">                 
                        <div class="col-xs-12 col-sm-6 col-md-4 left_port">
                            <ul>                     
                                <?php                             
                                if  ($client != '') {

                                     echo '<li><span>' . esc_html__( 'Client: ', 'modus' ) . '</span>' . esc_attr( $client ) .'</li>';
                                }
                                echo '<li><span>' . esc_html__( 'Date: ', 'modus' ) . '</span>' . esc_attr( $post_date ) .'</li>';
                                if  ($materials != '') {
                                    echo '<li><span>' . esc_html__( 'Materials: ', 'modus' ) . '</span>' . esc_attr( $materials ) .'</li>';
                                }
                                ?>
                                <li><span><?php echo esc_html__( 'Author Name: ', 'modus' ) . '</span>' . get_the_author(); ?></li>
                                <?php   
                                if  ($website != '') {
                                    echo '<li><span>' . esc_html__( 'Website: ', 'modus' ) . '</span>' . esc_attr( $website ) .'</li>';
                                }                           
                                ?>                            
                            </ul>
                        </div> 
                        <div class="col-md-8 col-sm-6 col-xs-12 single-content">

                            <?php 
                            if  ($branding != '') {
                                 echo '<div class="md-color-1">'. esc_attr( $branding ) .'</div>';
                            }
                            echo '<h1 class="port-tt">' . get_the_title() . '</h1>'; 
                            the_content();
                            ?>
                        </div>
                    </div>
                    <div class="port-thumbnail">
                        <?php    
                          $modus_portfolio_gallery_id = get_post_meta( get_the_ID(), 'portfolio_gallery_id', true);
                            $modus_portfolio_gallery_id = explode (',',$modus_portfolio_gallery_id);
                            if ( is_array($modus_portfolio_gallery_id) && count($modus_portfolio_gallery_id) > 0 ):
                                $i = 0;
                                $j = count($modus_portfolio_gallery_id);
                                foreach( $modus_portfolio_gallery_id as $key => $value ) :
                                    $i++;                                   
                                    $image = wp_get_attachment_image_src( (int)$value, 'full' );
                                    if ( ($i == ($j - 1)) || ( $i == $j) ){
                                       $image = wp_get_attachment_image_src( (int)$value, 'modus-image-single-portfolio' );
                                       ?>
                                        <div class="col-md-6 col-sm-6 col-xs-6 list-1">
                                           <img class="image-preview" src="<?php echo esc_url( $image[0] ); ?>" alt="<?php echo esc_attr($image_alt['title']); ?>"/>
                                        </div>                                        
                                    <?php   
                                    }   
                                    else{
                                        ?>
                                        <img class="image-preview" src="<?php echo esc_url( $image[0] ); ?>" alt="<?php echo esc_attr($image_alt['title']); ?>"/>                                
                                    <?php   
                                    }       
                                endforeach;                        
                            endif;
                        ?>
                    </div>   
                </div>                
            </div>
        </div>
    </div>
</article><!-- #post-## -->
