<?php
/**
 * The template part for displaying content
 *
 * @package WordPress
 * @subpackage modus
 * @since modus 1.0
 */ 
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>> 
	<header class="entry-header"> 
		<?php if ( has_post_thumbnail( get_the_ID() ) ) : ?>
			<?php modus_get_post_media(); ?>
		<?php endif;  
			$modus_config = modus_settings();
			$meta_cat = $modus_config['meta_cat'];
			$categories = get_the_category();
			$modus_cat='';
			$i=1;
			if( ! empty( $categories ) &&  $meta_cat == 'show' ){
				echo '<div class="modus_categories">';
				foreach ($categories as $category) {
					if ( $i > 1 ){
						echo '<a href="'. esc_url( get_category_link( $category->term_id ) ) .'">,  '. esc_html($category->name) .'</a>';
					}else{
						echo '<a href="'. esc_url( get_category_link( $category->term_id ) ) .'">'. esc_html($category->name) .'</a>';
					}
					$i++;
				}
				echo '</div>';
			} 
		?>
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
		<?php echo modus_post_meta(); ?>
	</header><!-- .entry-header -->
	<?php if ( !empty( get_the_content() ) ) : ?>
		<div class="entry-content">
			<?php
				/* translators: %s: Name of current post */
				the_content();
				wp_link_pages( array(
					'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'modus' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
					'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'modus' ) . ' </span>%',
					'separator'   => '<span class="screen-reader-text">, </span>',
				) );
			?>
		</div><!-- .entry-content -->
	<?php endif; ?>
</article><!-- #post-## -->
