<?php
/**
 * The template part for displaying single posts
 *
 * @package WordPress
 * @subpackage modus
 * @since modus 1.0
 */
?>
<?php 
	if(isset($_GET['layout']) && $_GET['layout']=='layout2'){
		$layout = 'layout2';
	}else{
		$layout = 'layout1';
	}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header <?php echo esc_attr($layout);?>">
		<?php if ( has_post_thumbnail( get_the_ID() ) && $layout == 'layout1') : ?>
			<?php modus_get_post_media(); ?>
		<?php endif; ?>
		<?php
			$modus_config = modus_settings();
			$meta_cat = $modus_config['meta_cat'];
			$categories = get_the_category();
			$modus_cat='';
			$i=1;
			if( ! empty( $categories ) &&  $meta_cat == 'show' ){
				echo '<div class="modus_categories">';
				foreach ($categories as $category) {
					if ( $i > 1 ){
						echo '<a href="'. esc_url( get_category_link( $category->term_id ) ) .'">,  '. esc_html($category->name) .'</a>';
					}else{
						echo '<a href="'. esc_url( get_category_link( $category->term_id ) ) .'">'. esc_html($category->name) .'</a>';
					}
					$i++;
				}
				echo '</div>';
			}
		?>
		<?php the_title( sprintf( '<h1 class="entry-title">', esc_url( get_permalink() ) ), '</h1>' ); ?>
		<?php echo modus_post_meta(); ?>
		<?php if ( has_post_thumbnail( get_the_ID() ) && $layout == 'layout2') : ?>
			<div class="thumbnail-post">
				<?php
					$attachment_id = get_post_thumbnail_id();
					$image_single = modus_get_attachment($attachment_id, 'modus-blog'); 
				?>
                <a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><img width="<?php echo esc_attr($image_single['width']) ?>" height="<?php echo esc_attr($image_single['height']) ?>" src="<?php echo esc_url($image_single['src']) ?>" alt="<?php echo esc_attr($image_single['alt']) ?>" />
				</a>
			</div>
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			/* translators: %s: Name of current post */
			the_content();
			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'modus' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'modus' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
		?>
	</div><!-- .entry-content -->

	<?php if($modus_config['single_meta_share'] =='show' || $modus_config['single_meta_cat'] == 'show'):?>
	<footer class="entry-footer"> 
		<div class="post-bottom">
			<div class="row">
				<?php
				$modus_config = modus_settings();
				if( ($modus_config['single_meta_cat'] == 'show' || $modus_config['single_meta_tag'] == 'show') && $modus_config['single_meta_share']){
					$class = 'col-xs-12 col-sm-6 col-md-6';
				}else{
					$class = 'col-xs-12 col-sm-12 col-md-12';
				} 
				if($modus_config['single_meta_cat'] == 'show' || $modus_config['single_meta_tag'] == 'show'){
				?>
				<div class="<?php echo esc_attr($class); ?> ">
					<?php if($modus_config['single_meta_cat'] == 'show') { ?>
					<div class="tagcloud">
						<?php
							$postcats = get_the_category();
							if ($postcats) {
								$space = true;
								echo '<span class="tag_label">'. esc_html__('Categories: ','modus') .'</span>';
								foreach($postcats as $cat) {
									if($space){ echo '<a href="'.get_category_link($cat->term_id).'">'.$cat->name.'</a>'; $space=false; }
									else{ echo ',&#32;<a href="'.get_category_link($cat->term_id).'">'.$cat->name.'</a>'; }
								}
							}
						?>
					</div>
					<?php } ?>
					<?php if($modus_config['single_meta_tag'] == 'show') { ?>
					<div class="tagcloud">
						<?php
							$posttags = get_the_tags();
							if ($posttags) {
								$space = true;
								echo '<span class="tag_label">'. esc_html__('Tags: ','modus') .'</span>';
								foreach($posttags as $tag) {
									if($space){ echo '<a href="'.get_tag_link($tag->term_id).'">'.$tag->name.'</a>'; $space=false; }
									else{ echo ',&#32;<a href="'.get_tag_link($tag->term_id).'">'.$tag->name.'</a>'; }
								}
							}
						?>
					</div>
					<?php } ?>
				</div>
				<?php }  
				if($modus_config['single_meta_share'] =='show'){
				?>
				<div class="<?php echo esc_attr($class); ?>">
					<div class="social-share f_right">
						<?php 
						if($modus_config['single_share']){
							echo '<span class="social_share_label">'. esc_html__('Share this post:','modus') .'</span>';
							foreach($modus_config['single_share'] as $share){
								modus_share(get_the_ID(),$share); 
							}
						}
						?>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>
	</footer><!-- .entry-footer -->
	<?php endif;?>
</article><!-- #post-## -->
<?php
if(modus_post_comment()){
	if($modus_config['single_meta_author_des']=='show'){
?>
	<div class="post-author-box">
		<div class="img-author">
			<a href="<?php echo get_author_posts_url( get_the_author_meta('ID') ) ?>">
				<?php $author_id = get_the_author_meta('ID');
				echo get_avatar( $author_id, 165 ) ?>
			</a>
		</div>
		<div class="author-social">
			<div>
			<?php if( get_the_author_meta('facebook',get_query_var('author') ) ) ?>
				<a class="author_facebook" href="<?php echo esc_url( get_the_author_meta( 'facebook' ) ); ?>" target="_blank"><i class="pe-icon-social pe-so-facebook"></i></a>
			<?php if( get_the_author_meta('twitter',get_query_var('author') ) ) ?>
				<a class="author_twitter" href="<?php echo esc_url( get_the_author_meta( 'twitter' ) );?>" target="_blank"><i class="pe-icon-social pe-so-twitter"></i></a>
			<?php if( get_the_author_meta('dribbble',get_query_var('author') ) ) ?>
				<a class="author_dribbble" href="<?php echo esc_url( get_the_author_meta( 'dribbble' ) ); ?>" target="_blank"><i class="pe-icon-social pe-so-dribbble"></i></a>
			<?php if( get_the_author_meta('google_plus',get_query_var('author') ) ) ?>
				<a class="author_googleplus" href="<?php echo esc_url( get_the_author_meta( 'google_plus' ) ); ?>" target="_blank"><i class="pe-icon-social pe-so-google-plus" aria-hidden="true"></i></a>
			</div>
		</div>
		<div class="dsc-author">
			<a class="name-author" href="<?php
				echo get_author_posts_url( get_the_author_meta('ID') ) ?>"><?php echo get_the_author_meta('display_name'); ?>
			</a>
			<div class="job-author"><?php if( get_the_author_meta('job',get_query_var('author') ) ) ?> <?php echo esc_html( get_the_author_meta( 'job' ) );?> </div>
			<div class="info-author"><p><?php echo esc_html( get_the_author_meta('user_description',get_query_var('author'))) ; ?></p></div>
			
		</div>
	</div>
	<?php } 
	// If comments are open or we have at least one comment, load up the comment template.
		comments_template();
	// End of the loop.
}