<?php
/**
 * The template part for displaying results in search pages
 *
 * @package WordPress
 * @subpackage modus
 * @since modus 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
	</header><!-- .entry-header -->

	<?php if ( 'post' === get_post_type() ) : ?>

		<footer class="entry-footer">
			<?php edit_post_link( esc_html__( 'Edit', 'modus' ), '<footer class="entry-footer"><span class="edit-link">', '</span></footer><!-- .entry-footer -->' ); ?> 
		</footer><!-- .entry-footer -->

	<?php else : ?>

		<?php edit_post_link( esc_html__( 'Edit', 'modus' ), '<footer class="entry-footer"><span class="edit-link">', '</span></footer><!-- .entry-footer -->' ); ?> 

	<?php endif; ?>
</article><!-- #post-## -->

