<?php
/**
 * The template part for displaying content
 *
 * @package WordPress
 * @subpackage modus
 * @since modus 1.0
 */ 
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>> 
	<?php  
		$archive_month = get_the_time('M');
        $archive_day   = get_the_time('d');
        $archive_year  = get_the_time('Y');
		$have_thumb = '';
		if ( has_post_thumbnail( get_the_ID() ) ) {$have_thumb = ' have_thumb';}
		?>
		<div class="blog-type2">
			<header class="entry-header<?php echo esc_attr($have_thumb);?>"> 
				<?php if ( has_post_thumbnail( get_the_ID() ) ) : ?>
					<div class="thumbnail-post">
						<?php modus_get_post_media(); ?>
						<div class="post-time">
	                        <p><span class="date"><?php echo esc_html( $archive_day ); ?></span>
	                        <span class="month"><?php echo esc_html( $archive_month ); ?></span></p>
	                    </div>
					</div>
				<?php endif;  
					$modus_config = modus_settings();
					$meta_cat = $modus_config['meta_cat'];
					$categories = get_the_category();
					$modus_cat='';
					$i=1;
					if( ! empty( $categories ) &&  $meta_cat == 'show' ){
						echo '<div class="modus_categories">';
						foreach ($categories as $category) {
							if ( $i > 1 ){
								echo '<a href="'. esc_url( get_category_link( $category->term_id ) ) .'">,  '. esc_html($category->name) .'</a>';
							}else{
								echo '<a href="'. esc_url( get_category_link( $category->term_id ) ) .'">'. esc_html($category->name) .'</a>';
							}
							$i++;
						}
						echo '</div>';
					} 
				?>
				<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
				<?php echo modus_post_meta(); ?>
			</header><!-- .entry-header -->
			<div class="entry-content">
				<?php
					/* translators: %s: Name of current post */
					echo wp_trim_words( get_the_content(), 25  );
					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'modus' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'modus' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					) );
				?>
			</div><!-- .entry-content -->
			<footer class="entry-footer">
				<div class="post-bottom">
					<a class="read-more hvr-rectangle-out" href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php echo esc_html__( 'View more','modus'); ?></a>
				</div>
			</footer><!-- .entry-footer -->
		</div> 
</article><!-- #post-## -->
