<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage modus
 */

get_header();
$show_title = 'show';
$page_show_breadcrumb = 'show'; 
?>
	<div id="primary" class="content-area">
		<main id="main" class="team-single site-main<?php if ( $page_show_breadcrumb == 'hide' ) echo ' padding-top-70'; ?>" role="main">
			<?php if($show_title == 'show' && $page_show_breadcrumb == 'show' ):?>
				<div class="breadcrumb-container">
					<div class="bottom-breadcrumb">
						<div class=" container">
							<?php if($show_title == 'show'){ ?>
							<div class="page-title">
								<h2><?php echo get_the_title(); ?></h2>
							</div>
							<?php } ?>			
							<?php if ( $page_show_breadcrumb == 'show' ) : ?>					
								<div class="bread-crumb">
									<?php echo modus_breadcrumbs(); ?>
								</div>
							<?php endif; ?>
						</div>
					</div>	
				</div>	
			<?php endif;?>	
			<div class="container">
				<div class="row">
					<div class="col-md-12 col-sm-12 col-xs-12">
						<?php if ( have_posts() ) : ?>
							<?php
							// Start the Loop.
							while ( have_posts() ) : the_post();
								// Include the single post content template.
			                    get_template_part( 'template-parts/content', 'team' );
			                    
			                    ?>
			                <?php
							endwhile;	
						endif;
						?>
					</div>
				</div>
			</div>
		</main><!-- .site-main -->
	</div><!-- .content-area -->
<?php get_footer(); ?>
