<?php
/**
 * The template for displaying search results pages
 *
 * @package WordPress
 * @subpackage modus
 * @since modus 1.0
 */

get_header();
$modus_sidebar_position = 'left'; 
$padding_top = '';
$padding_bottom = '';
$modus_config = modus_settings();
if(isset($modus_config['post_sidebar_position'])){
	$modus_sidebar_position = $modus_config['post_sidebar_position'];
}
if(isset($modus_config['post_sidebar'])){
	$modus_sidebars = $modus_config['post_sidebar'];
	if(!is_active_sidebar($modus_sidebars)){
		$modus_sidebar_position = 'none'; 
	}
}
if ( get_post_meta(get_the_ID(), 'no_padding_top', true) != ''){

	$padding_top = get_post_meta(get_the_ID(), 'no_padding_top', true);
}
if ( get_post_meta(get_the_ID(), 'no_padding_bottom', true) != ''){
	$padding_bottom = get_post_meta(get_the_ID(), 'no_padding_bottom', true);
}

if($modus_sidebar_position == 'left-sidebar' ){
	$modus_class_sidebar = 'sidebar_left';
	$modus_wrap_content = 'col-xs-12 col-sm-12 col-md-9 right';
}else if( $modus_sidebar_position == 'right-sidebar' ){
	$modus_class_sidebar = 'sidebar_right';
	$modus_wrap_content = 'col-xs-12 col-sm-12 col-md-9';
}else{
	$modus_wrap_content='col-xs-12 col-sm-12 col-md-12';
}
$blog_show_breadcrum = '';
if( isset( $modus_config['archive_blog_banner'] )) :
	$blog_show_breadcrum = $modus_config['archive_blog_banner'];
endif;
?>
<div id="primary" class="content-area">
	<main id="main" class="site-main blog show" role="main">
		<?php if ( $blog_show_breadcrum == 'show' ) : ?>
			<div class="breadcrumb-container">
				<div class="bottom-breadcrumb">
					<div class="container">
						<div class="bread-crumb">
							<?php echo modus_breadcrumbs(); ?>
						</div> 
					</div>	
				</div>
			</div>	
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="<?php echo esc_attr($modus_wrap_content); ?>">
					<?php if ( have_posts() ) : ?>

						<header class="page-header">
							<h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'modus' ), '<span>' . esc_html( get_search_query() ) . '</span>' ); ?></h1>
						</header><!-- .page-header -->

						<?php
						// Start the loop.
						while ( have_posts() ) : the_post();
							get_template_part( 'template-parts/content', get_post_format() );
						// End the loop.
						endwhile;

						// Previous/next page navigation.
						$older_posts = esc_html__('Older posts','modus');
						$newer_posts = esc_html__('Newer posts','modus');
						// Previous/next page navigation.
						the_posts_pagination( array(
							'prev_text'          => '<i class="Pe-icon-7-stroke-angle-left"></i> '. $newer_posts .'',
							'next_text'          => ''. $older_posts .'<i class="Pe-icon-7-stroke-angle-right"></i>',
							'before_page_number' => '<span class="meta-nav screen-reader-text"></span>',
						) );

					// If no content, include the "No posts found" template.
					else :
						get_template_part( 'template-parts/content', 'none' );

					endif;
					?>
					</div>
					<?php
					if( $modus_sidebar_position != 'none' && $modus_sidebar_position != '' ){ ?>
						<div class="col-md-3 col-xs-12 col-sm-12 <?php echo esc_attr($modus_class_sidebar ); ?>">
							<div class="sidebar sidebarArea sidebar-blog">
								<?php dynamic_sidebar($modus_sidebars ); ?>
							</div>
						</div>
					<?php
						}
					?>
				</div>
			</div>
		</main><!-- .site-main -->
	</div><!-- .content-area -->
<?php get_footer(); ?>
