<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage modus
 * @since modus 1.0
 */

get_header();
$modus_config = modus_settings();
$modus_sidebar_position = 'none';
$padding_top = 'padding-top-25';
$padding_bottom = 'padding-bottom-60';
$modus_class_sidebar = '';
$page_show_breadcrumb = '';
$modus_content_width = '';
if (get_post_meta(get_the_ID(), 'content_width', true)) {
    $modus_content_width = 'content_width';
}
$sidebar_positon = get_post_meta(get_the_ID(), 'sidebar_position', true);
if (!empty($sidebar_positon) && $sidebar_positon != 'default') {
    $modus_sidebar_position = get_post_meta(get_the_ID(), 'sidebar_position', true);
}
if (isset($modus_config['page_sidebar_position']) && $modus_sidebar_position == 'default') {
    $modus_sidebar_position = $modus_config['page_sidebar_position'];
}

$sidebar = get_post_meta(get_the_ID(), 'sidebar', true);
$modus_sidebars_content = '';
if (!empty($sidebar) && $sidebar != 'default') {
	$modus_sidebars_content = '"'.$sidebar.'"';
}

$modus_sidebars = '';
if (isset($modus_config['page_sidebar_ct']) && $modus_config['page_sidebar_ct'] != '') {
    $modus_sidebars = $modus_config['page_sidebar_ct'];
	$modus_sidebars_content= '"'.$modus_sidebars.'"';
    if (!is_active_sidebar($modus_sidebars_content)) {
        $modus_sidebar_position = 'none';
    }
}

if (get_post_meta(get_the_ID(), 'no_padding_top', true)) {
    $padding_top = 'no_padding_top';
}
if (get_post_meta(get_the_ID(), 'no_padding_bottom', true)) {
    $padding_bottom = 'no_padding_bottom';
}
$show_title = 'show';
if (isset($modus_config['page_title']) && $modus_config['page_title'] != '') {
    $show_title = $modus_config['page_title'];
}
if (get_post_meta(get_the_ID(), 'show_title_page', true) != '' && get_post_meta(get_the_ID(), 'show_title_page', true) != 'default') {
    $show_title = get_post_meta(get_the_ID(), 'show_title_page', true);
}

if ($modus_sidebar_position == 'left-sidebar') {
    $modus_class_sidebar = 'sidebar_left';
    $modus_wrap_content = 'col-xs-12 col-sm-12 col-md-9 right';
} else if ($modus_sidebar_position == 'right-sidebar') {
    $modus_class_sidebar = 'sidebar_right';
    $modus_wrap_content = 'col-xs-12 col-sm-12 col-md-9';
} else {
    $modus_wrap_content = 'col-xs-12 col-sm-12 col-md-12';
}
$page_show_breadcrumb = 'hide';
if (isset($modus_config['page_bread_crumb']) && $modus_config['page_bread_crumb'] != '') {
    $page_show_breadcrumb = $modus_config['page_bread_crumb'];
}
if (get_post_meta(get_the_ID(), 'show_breadcrumb', true) != '' && get_post_meta(get_the_ID(), 'show_breadcrumb', true) != 'default') {
    $page_show_breadcrumb = get_post_meta(get_the_ID(), 'show_breadcrumb', true);
}
$main_class = '';
if (get_post_meta(get_the_ID(), 'page_background', true)) {
    $main_class = get_post_meta(get_the_ID(), 'page_background', true);
}

?>

<div id="primary" class="content-area <?php echo esc_attr($modus_content_width); ?>">
    <main id="main" class="site-main <?php echo esc_attr($main_class); ?>">
        <?php if ($show_title == 'show' && $page_show_breadcrumb == 'show'): ?>
            <div class="breadcrumb-container breadcrumb-page">
                <div class="bottom-breadcrumb">
                    <div class=" container">
                        <?php if ($page_show_breadcrumb == 'show') { ?>
                            <div class="bread-crumb">
                                <?php echo modus_breadcrumbs(); ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="page-title-container">
                <div class=" container">
                    <?php if ($show_title == 'show') { ?>
                        <div class="page-title">
                            <h1><?php the_title(); ?></h1>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php endif; ?>
        <?php
        if (modus_layout_page() == 'type1') echo '<div class="container ' . $padding_top . ' ' . $padding_bottom . '">';
        elseif (modus_layout_page() == 'type2') echo '<div class="container-fluid modus_inbox_wrap ' . $padding_top . ' ' . $padding_bottom . '">' ?>
        <div class="row">
            <div class="<?php echo esc_attr($modus_wrap_content); ?>">
                <?php
                // Start the loop.
                while (have_posts()) : the_post();
                    // Include the page content template.
                    get_template_part('template-parts/content', 'page');
                    // End of the loop.
                endwhile;
                ?>
            </div>
            <?php
            if ($modus_sidebar_position != 'none' && $modus_sidebar_position != '') { ?>
                <div class="col-md-3 col-xs-12 col-sm-12 <?php echo esc_attr($modus_class_sidebar); ?>">
                    <div class="sidebar sidebarArea">
                        <?php dynamic_sidebar($modus_sidebars_content); ?>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
</div>
</main><!-- .site-main -->
</div><!-- .content-area -->
<?php get_footer(); ?>
