<?php
/**
 * The template for displaying archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each one. For example, tag.php (Tag archives),
 * category.php (Category archives), author.php (Author archives), etc.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage modus
 */

get_header();
$modus_sidebar_position = 'default';
$padding_top = '';
$padding_bottom = '';
$modus_config = modus_settings();
if(isset($modus_config['post_sidebar_position'])){
	$modus_sidebar_position = $modus_config['post_sidebar_position'];
}  
if(isset($modus_config['post_sidebar'])){
	$modus_sidebars = $modus_config['post_sidebar'];
	if(!is_active_sidebar($modus_sidebars)){
		$modus_sidebar_position = 'none'; 
	}
}
if(isset($_GET['modus_sidebar_position']) && $_GET['modus_sidebar_position']=='none'){
	$modus_sidebar_position='none';
}
if ( get_post_meta(get_the_ID(), 'no_padding_top', true) != ''){ 
	$padding_top = get_post_meta(get_the_ID(), 'no_padding_top', true);
}
if ( get_post_meta(get_the_ID(), 'no_padding_bottom', true) != ''){
	$padding_bottom = get_post_meta(get_the_ID(), 'no_padding_bottom', true);
}
if($modus_sidebar_position == 'left-sidebar' ){
	$modus_class_sidebar = 'sidebar_left';
	$modus_wrap_content = 'col-xs-12 col-sm-12 col-md-8 col-lg-9 right';
}else if( $modus_sidebar_position == 'right-sidebar' ){
	$modus_class_sidebar = 'sidebar_right';
	$modus_wrap_content = 'col-xs-12 col-sm-12 col-md-8 col-lg-9';
}else{
	$modus_wrap_content='col-xs-12 col-sm-12 col-md-12';
} 
$blog_show_breadcrum = '';
if( isset( $modus_config['archive_blog_banner'] )) :
	$blog_show_breadcrum = $modus_config['archive_blog_banner'];
endif;
if( is_front_page()) :
	$blog_show_breadcrum = 'hide';
endif; 
if ( isset( $_GET['layout']) && $_GET['layout'] == '3' ) {
	$layout_cl = ' blog-type-3';
}else{
	$layout_cl ='';
}
$layout ='';
if(isset($modus_config['blog-layout'])){
	if($modus_config['blog-layout'] =='default'){
		$layout = '';
	}else{
		$layout = $modus_config['blog-layout'];
	}
}
if ( isset( $_GET['layout'])){
	if($_GET['layout'] == '2') $layout ='layout2';
	elseif($_GET['layout'] == '3') $layout ='layout3';
	elseif($_GET['layout'] == '4') $layout ='layout4'; 
}
$show_title = 'show';
?>
	<div id="primary" class="content-area">
		<main id="main" class="blog site-main<?php if ( $blog_show_breadcrum == 'hide' ) echo ' padding-top-60'; ?>" role="main">

		<?php if($show_title == 'show' && $blog_show_breadcrum == 'show' ):?>
			<div class="breadcrumb-container">
				<div class="bottom-breadcrumb">
					<div class=" container">
						<?php if($show_title == 'show'){ ?>
						<div class="page-title">
							<?php $page_for_posts = get_option( 'page_for_posts' );?> 
							<h1><?php echo get_the_title( $page_for_posts ); ?></h1>
						</div>
						<?php } ?>			
						<?php if ( $blog_show_breadcrum == 'show' ) : ?>					
							<div class="bread-crumb">
								<?php echo modus_breadcrumbs(); ?>
							</div>
						<?php endif; ?>
					</div>	
				</div>
			</div>	
		<?php endif;?>			
			<div class="container"> 
				<div class="row">
					<div class="<?php echo esc_attr($modus_wrap_content); ?>">
						<div class="blog-list<?php echo esc_attr($layout_cl);?>">
							<?php if ( have_posts() ) : ?>
								<?php
								// Start the Loop.  
								while ( have_posts() ) : the_post();
									if ( $layout == 'layout2') {
										echo '<div class="sfc wow fadeInUp blog-type-2" data-wow-duration="300ms" data-wow-delay="100ms">';
											get_template_part( 'template-parts/content', $layout );
										echo '</div>';
									}else{
										echo '<div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">';
											get_template_part( 'template-parts/content', $layout );
										echo '</div>';
									}
								// End the loop.
								endwhile;

								// Previous/next page navigation.
								the_posts_pagination( array(
									'prev_text'          => '<i class="Pe-icon-7-stroke-angle-left"></i> Newer posts',
									'next_text'          => 'Older posts <i class="Pe-icon-7-stroke-angle-right"></i>',
									'before_page_number' => '<span class="meta-nav screen-reader-text"></span>',
								) );
							// If no content, include the "No posts found" template.
							else :
								get_template_part( 'template-parts/content', 'none' ); 
							endif;
							?>
						</div>
					</div>
					<?php
					if( $modus_sidebar_position != 'none' && $modus_sidebar_position != '' ){ ?>
						<div class="col-lg-3 col-md-4 col-xs-12 col-sm-12 <?php echo esc_attr( $modus_class_sidebar ); ?>">
							<div class="sidebar sidebarArea sidebar-blog">
								<?php dynamic_sidebar($modus_sidebars ); ?>
							</div>
						</div>
					<?php
						}
					?>
				</div>   
			</div>
		</main><!-- .site-main -->
	</div><!-- .content-area -->
<?php get_footer(); ?>
