<?php
/**
 * Social Widget
 */

class WP_Modus_Widget_Social extends WP_Widget
{

    function __construct()
    {
        $widget_ops = array( 'classname' => 'modus_widget_social', 'description' => esc_html__( "modus social option.", "modus") );
        parent::__construct( 'modus-social', esc_html__( '[Modus] Social', 'modus' ), $widget_ops );
        $this->alt_option_name = 'modus_widget_social';
    }
    public function widget( $args, $instance ){
		$modus_config = modus_settings();
		global $modus_social_array;
		$modus_socials = $modus_social_array;
		echo wp_kses_post($args['before_widget']);
			if ( $instance['title'] ) {
                echo wp_kses_post($args['before_title'] . esc_html($instance['title']) . $args['after_title']);
            }
			if (count($modus_social_array)>0) :
				echo '<div class="social-login-options">';
				foreach( $modus_socials as $key => $value):
					if(isset($instance['show_'.$key]) && $instance['show_'.$key] == 'show' && isset($modus_config['social_'.$key.'_link']) ){
						echo '<div class="social"> <a href="'.esc_url($modus_config['social_'.$key.'_link']).'" target="_blank"><i class="fa fa-'.$key.'"></i></a></div>';
					}
				endforeach;
				echo '</div>';
			endif; // End modus_social_array
		echo wp_kses_post($args['after_widget']);
    }
    public function update( $new_instance, $old_instance){
        $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		global $modus_social_array;
		$modus_socials = $modus_social_array;
		if (count($modus_social_array)>0) :
			foreach( $modus_socials as $key => $value):
				$instance['show_'.$key] = $new_instance['show_'.$key];
			endforeach;
		endif; // End modus_social_array
        return $instance;
    }
    public function form( $instance){
		global $modus_social_array;
		$modus_socials = $modus_social_array;
		$title	 = isset( $instance['title'] ) ? esc_html($instance['title']) : esc_html__('Connect Us','modus');
		?>
		<p><label for="<?php echo  esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','modus' ); ?></label>
        <input class="widefat" id="<?php echo  esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo  esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo  esc_attr($title); ?>" /></p>
		<?php
		if (count($modus_social_array)>0) :
			foreach( $modus_socials as $key => $value):
				$show_social  = isset( $instance['show_'.$key] ) ? esc_attr( $instance['show_'.$key] ) : '';
        ?>
				<p>
					<input type="checkbox" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'show_'.$key)); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_'.$key)); ?>" value="show" <?php checked( $show_social, 'show' ); ?>/>
					<label for="<?php echo esc_attr($this->get_field_id( 'show_'.$key)); ?>"><?php  echo esc_html__( 'Show','modus' ).' '. esc_html($value); ?></label>
				</p>
        <?php
			endforeach;
		endif; // End modus_social_array
    }
}