<?php
/**
 * top rate widget
 * @package modus
 */
defined( 'ABSPATH' ) || exit;
class WP_Modus_Widget_Top_Sellers extends WC_Widget {
    /**
     * Constructor.
     */
    public function __construct() {
        $this->widget_cssclass    = 'woocommerce widget_top_sellers_products';
        $this->widget_description = __( 'Display a list of your top sellers products on your site.', 'modus' );
        $this->widget_id          = 'woocommerce_top_sellers_products';
        $this->widget_name        = __( '[Modus] Top Sellers', 'modus' );
        $this->settings           = array(
            'title'  => array(
                'type'  => 'text',
                'std'   => __( 'Top Sellers Products', 'modus' ),
                'label' => __( 'Title', 'modus' )
            ),
            'number' => array(
                'type'  => 'number',
                'step'  => 1,
                'min'   => 1,
                'max'   => '',
                'std'   => 5,
                'label' => __( 'Number of products to show', 'modus' )
            )
        );

        parent::__construct();
    }

    /**
     * Output widget.
     *
     * @see WP_Widget
     *
     * @param array $args
     * @param array $instance
     */
    public function widget( $args, $instance ) {
		if ( $this->get_cached_widget( $args ) ) {
			return;
		}

		ob_start();
        $number = ! empty( $instance['number'] ) ? absint( $instance['number'] ) : $this->settings['number']['std'];
        
        $args_query = array(
            'post_type' => 'product',
            'posts_per_page' =>  $number,
            'ignore_sticky_posts' => 1,
            'meta_key' => 'total_sales',
            'orderby' => 'meta_value_num',
        );
        $top_product_loop = new WP_Query( $args_query );
        if ( $top_product_loop->have_posts() ) {
			$this->widget_start( $args, $instance );
			?>
				<div class="slide-product-widget slide-product-list" data-columns="1" data-rows="4">
					 <div class="beans-stepslider" data-rotate="true">
						<div class="beans-mask">
							<div class="beans-slideset">
							<?php
								while ( $top_product_loop->have_posts() ) : $top_product_loop->the_post();
									$id_post = get_the_ID();
							 ?>
									<div class="beans-slide">
										<div class="widget-list-slide">
											   <?php wc_get_template_part( 'content', 'product-list-widget' );  ?>
										</div>
									</div>
							 <?php endwhile;  ?>
							</div>
						</div>
						<a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
						<a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
					</div>
				</div>
			<?php
			$this->widget_end( $args );
			
        }
		wp_reset_postdata();

		echo $this->cache_widget( $args, ob_get_clean() ); // WPCS: XSS ok.
    }
}
