<?php
/**
 * Recent post widget
 * @package modus
 */

class WP_Modus_Widget_Recent_Posts extends WP_Widget {

    public function __construct() {
        $widget_ops = array( 'classname' => 'modus_widget_recent_posts', 'description' => esc_html__( "Your site&#8217;s most recent Posts.", "modus") );
        parent::__construct( 'modus-recent-posts', esc_html__( '[Modus] Recent Posts', 'modus' ), $widget_ops );
        $this->alt_option_name = 'modus_widget_recent_posts';
    }

    public function widget( $args, $instance ) {
        $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 3;
        if ( ! $number )
            $number = 3;
		$r = new WP_Query( apply_filters( 'modus_widget_posts_args', array(
            'posts_per_page'      => $number,
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true
        ) ) );

        if ($r->have_posts()) : 
			echo wp_kses_post($args['before_widget']);
		?>
			<div class="recents-post">
				<?php if ( $instance['title'] ) {
					echo wp_kses_post($args['before_title'] . esc_html($instance['title']) . $args['after_title']);
				} ?>
				<div class="modus-recent-posts clearfix">
					<?php
					$i = 0;
					while ( $r->have_posts() ) : $r->the_post();
						$i++;
						if ( $i == 1 ) :    
							?>
							<div class="item-news first">
								<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
								<div class="txt">
									<div class="modus-date">
										<span class="item-time"><?php echo get_the_time( 'M d, Y',get_the_ID() ); ?></span>
									</div>
									<a href="<?php the_permalink(); ?>">
										<?php the_title(); ?>
									</a>
								</div>
							</div>
							<?php
						else:
							?>
							<div class="item-news">
								<div class="recent-post-thumbnail">
									<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('modus-image-recent-post'); ?></a>
								</div>
								<div class="txt">
									<div class="modus-date">
										<span class="item-time"><?php echo get_the_time( 'M d, Y',get_the_ID() ); ?></span>
									</div>
									<a href="<?php the_permalink(); ?>">
										<?php the_title(); ?>
									</a>
								</div>
							</div>
							<?php
						endif;
					endwhile;
					wp_reset_postdata();
				 ?>
				</div>
			</div>
        <?php 
			echo wp_kses_post($args['after_widget']);  
        endif;
    }

    /*Update data widget*/
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        $instance['number'] = (int) $new_instance['number'];
        $instance['layout'] = strip_tags($new_instance['layout']);
        return $instance;
    }

    /*Layout admin widget*/
    public function form( $instance ) {
        $title              = isset( $instance['title'] ) ? wp_kses($instance['title'],array('span'=>array('class'=>array()))) : '';
        $number             = isset( $instance['number'] ) ? absint( $instance['number'] ) : 2;
        $layout          = isset( $instance['layout'] ) ?  esc_html( $instance['layout'] ) : '1';
        ?>
        <p><label for="<?php echo  esc_html($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','modus' ); ?></label>
        <input class="widefat" id="<?php echo  esc_html($this->get_field_id( 'title' )); ?>" name="<?php echo  esc_html($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

        <p><label for="<?php echo  esc_html($this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number of posts to show:', 'modus' ); ?></label>
        <input id="<?php echo  esc_html($this->get_field_id( 'number' )); ?>" name="<?php echo  esc_html($this->get_field_name( 'number' )); ?>" type="text" value="<?php echo  esc_attr($number); ?>" size="3" /></p>
        <?php
    }
}