<?php
/**
 * Logo Widget
 */

class WP_Modus_Widget_Logo extends WP_Widget
{

    function __construct()
    {
        $widget_ops = array( 'classname' => 'modus_widget_logo', 'description' => esc_html__( "modus logo option.", "modus") );
        parent::__construct( 'modus-logo', esc_html__( '[Modus] Logo', 'modus' ), $widget_ops );
        $this->alt_option_name = 'modus_widget_logo';
    }
    public function widget( $args, $instance ){
		$config = modus_settings();
		$modus_name=get_option('blogname');
		$modus_description=get_option('blogdescription');
        $des_site = ( ! empty( $instance['des_site'] ) ) ? $instance['des_site'] : '';
        echo wp_kses_post($args['before_widget']);
			echo '<div class="footer-logo logo">';
				echo '<a href="'.esc_url( home_url( '/' ) ).'">';
					if($config['logo_type']=='logo_image' && isset($config['logo_image'])){
						echo '<img src="'. esc_url(str_replace(array('http:', 'https:'), '', $config['logo_image']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '">';
					}else{
						echo '<span class="site-title">'. esc_html($modus_name) .'</span>';
					}
				echo '</a>';
                if ( $des_site !='' ) {
                    echo '<span class="text">'. esc_html($des_site) .'</span>';
                }
			echo '</div>';
		echo wp_kses_post($args['after_widget']);
    }
    public function update( $new_instance, $old_instance){
        $instance = $old_instance;
        $instance['show_logo'] = $new_instance['show_logo'];
        $instance['show_des'] = $new_instance['show_des'];
        $instance['des_site'] = $new_instance['des_site'];
        return $instance;
    }
    public function form( $instance){
        $show_logo  = isset( $instance['show_logo'] ) ? esc_attr( $instance['show_logo'] ) : '';
        $show_des  = isset( $instance['show_des'] ) ? esc_attr( $instance['show_des'] ) : '';
        $des_site  = isset( $instance['des_site'] ) ? esc_attr( $instance['des_site'] ) : '';
        ?>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'show_logo' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_logo' )); ?>" value="show" <?php checked( $show_logo, 'show' ); ?>/>
			<label for="<?php echo esc_attr($this->get_field_id( 'show_logo' )); ?>"><?php  esc_html_e( 'Show Logo','modus' ); ?></label>
		</p>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'show_des' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_des' )); ?>" value="show" <?php checked( $show_des, 'show' ); ?>/>
			<label for="<?php echo esc_attr($this->get_field_id( 'show_des' )); ?>"><?php  esc_html_e( 'Show Description Site','modus' ); ?></label>
		</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'des_site' )); ?>"><?php  esc_html_e( 'Text Description','modus' ); ?></label>
            <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'des_site' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'des_site' )); ?>" value="<?php echo  esc_attr($des_site); ?>"/>

        </p>
        <?php
    }
}