<?php
/**
 * Special product
 */

class WP_Modus_Widget_Contact extends WP_Widget
{

    function __construct()
    {
        $widget_ops = array( 'classname' => 'modus_widget_contact', 'description' => esc_html__( "Modus contact option.", "modus") );
        parent::__construct( 'modus-contact', esc_html__( '[Modus] Contact', 'modus' ), $widget_ops );
        $this->alt_option_name = 'modus_widget_contact';
    }
    public function widget( $args, $instance ){
		$modus_config = modus_settings();

		echo wp_kses_post($args['before_widget']);
        if ( $instance['title'] ) {
            echo wp_kses_post($args['before_title'] . esc_html($instance['title']) . $args['after_title']);
        }
	?>
		<div class="footer-info-v1">
			<div class="links">
				<ul>
					<?php if ( $instance['address']=='show' && isset($modus_config['modus_address']) && $modus_config['modus_address']!='' ): ?>
					<li>
						<em class="Pe-icon-7-stroke-map-marker"></em>
						<span class="text"><?php echo wp_kses_post($modus_config['modus_address'])?></span>
					</li>
					<?php endif; ?>
					<?php if ( $instance['phone']=='show' && isset($modus_config['modus_phone']) && $modus_config['modus_phone']!='' ): ?>
					<li>
						<em class="Pe-icon-7-stroke-call"></em>
						<span class="text-label"><?php  esc_html_e( 'Tel','modus' ); ?>.</span><a href="callto:<?php echo wp_kses($modus_config['modus_phone'],array())?>"> <span class="text"><?php echo wp_kses($modus_config['modus_phone'],array())?></span></a>
					</li>
					<?php endif; ?>
					<?php if ( $instance['email']=='show' && isset($modus_config['modus_mail']) && $modus_config['modus_mail']!='' ): ?>
					<li>
						<em class="Pe-icon-7-stroke-mail"></em>
						<span class="text-label"><?php  esc_html_e( 'Mail','modus' ); ?>.</span><a href="mailto:<?php echo wp_kses($modus_config['modus_mail'],array())?>"> <span class="text"><?php echo wp_kses($modus_config['modus_mail'],array())?></span></a>
					</li>
					<?php endif; ?>
					<?php if ( $instance['clock']=='show' && isset($modus_config['modus_time']) && $modus_config['modus_time']!='' ): ?>
					<li>
						<em class="Pe-icon-7-stroke-clock"></em>
						<span class="text"><?php echo wp_kses($modus_config['modus_time'],array(
								'span' => array(),
							))?></span>
					</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	<?php
		echo wp_kses_post($args['after_widget']);
    }
    public function update( $new_instance, $old_instance){
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        $instance['address'] = $new_instance['address'];
        $instance['phone'] = $new_instance['phone'];
        $instance['email'] = $new_instance['email'];
        $instance['clock'] = $new_instance['clock'];

        return $instance;
    }
    public function form( $instance){
        $show_address  = isset( $instance['address'] ) ? esc_attr( $instance['address'] ) : '';
        $show_phone  = isset( $instance['phone'] ) ? esc_attr( $instance['phone'] ) : '';
        $show_email  = isset( $instance['email'] ) ? esc_attr( $instance['email'] ) : '';
        $show_clock  = isset( $instance['clock'] ) ? esc_attr( $instance['clock'] ) : '';
        $title   = isset( $instance['title'] ) ? esc_html($instance['title']) : esc_html__('Connect Us','modus');
        ?>
        <p><label for="<?php echo  esc_html($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','modus' ); ?></label>
        <input class="widefat" id="<?php echo  esc_html($this->get_field_id( 'title' )); ?>" name="<?php echo  esc_html($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'address' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'address' )); ?>" value="show" <?php checked( $show_address, 'show' ); ?>/>
			<label for="<?php echo esc_attr($this->get_field_id( 'show_address' )); ?>"><?php  esc_html_e( 'Show Address','modus' ); ?></label>
		</p>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'email' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'email' )); ?>" value="show" <?php checked( $show_email, 'show' ); ?>/>
			<label for="<?php echo esc_attr($this->get_field_id( 'email' )); ?>"><?php  esc_html_e( 'Show Email','modus' ); ?></label>
		</p>
        <p>
			<input type="checkbox" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'phone' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'phone' )); ?>" value="show" <?php checked( $show_phone, 'show' ); ?>/>
			<label for="<?php echo esc_attr($this->get_field_id( 'phone' )); ?>"><?php  esc_html_e( 'Show Phone','modus' ); ?></label>
		</p>
		<p>
			<input type="checkbox" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'clock' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'clock' )); ?>" value="show" <?php checked( $show_clock, 'show' ); ?>/>
			<label for="<?php echo esc_attr($this->get_field_id( 'clock' )); ?>"><?php  esc_html_e( 'Show Time','modus' ); ?></label>
		</p>
        <?php
    }
}