<?php
/**
 * modus theme setup functions
 */
if (!defined('ABSPATH')) {
    die('Cheatin\' huh?');
}

/**
 * Resize Image
 */
add_image_size('modus-image-product-thumnail', 150, 150, true);
add_image_size( 'modus-image-product-small', 120, 120, true);
add_image_size( 'modus-image-product-grid', 420, 460, true);
add_image_size( 'modus-image-product-list', 100, 100, true);
add_image_size( 'modus-image-80', 80, 80, true); 
add_image_size( 'modus-image-blog-slide', 340, 180, true);
add_image_size( 'modus-image-recent-post', 70, 70, true);
add_image_size( 'modus-image-product-list-widget', 80, 100, true);
add_image_size( 'modus-blog', 848, 300, true);
add_image_size( 'modus-blog-2', 555, 359, true);
add_image_size( 'modus-blog-3', 555, 555, true);
add_image_size( 'modus-glass-thumnail', 360, 360, true);
add_image_size( 'modus-our-best', 394, 432, true);
add_image_size( 'modus-image-product-list-layout', 394, 394, true);

add_image_size( 'modus-image-blog-1', 651, 557, true);
add_image_size( 'modus-image-blog-2', 555, 300, true);
add_image_size( 'modus-image-blog-3', 600, 400, true);
add_image_size( 'modus-image-blog-4', 458, 300, true);
add_image_size( 'modus-image-blog-7', 370, 260, true);
add_image_size( 'modus-image-blog-9', 555, 375, true);
add_image_size( 'modus-image-blog-10', 269, 240, true);
add_image_size( 'modus-image-blog-11', 540, 420, true);

add_image_size( 'modus-image-single-portfolio', 555, 400, true); 
add_image_size( 'modus-service-4', 555, 255, true); 
add_image_size( 'modus-service-1', 555, 466, true); 
add_image_size( 'modus-service-2', 540, 500, true); 
add_image_size( 'modus-service-3', 379, 200, true); 
add_image_size( 'modus-shop-single', 600, 600, true);
/**
 * Enqueue scripts
 */
add_action('admin_enqueue_scripts', 'modus_admin_scripts');
function modus_admin_scripts()
{
    wp_enqueue_style('modus_admin_css', MODUS_CSS . '/admin.css', false);
    wp_register_script('modus_admin_js', MODUS_JS . '/admin.js', array('common', 'jquery', 'media-upload', 'thickbox'), MODUS_VERSION, true);
    wp_enqueue_script('modus_admin_js');
}

add_action('admin_enqueue_scripts', 'modus_admin_css');
function modus_admin_css()
{
    wp_enqueue_style('modus_admin_css', MODUS_CSS . '/admin.css', true);
}

function modus_fonts_url()
{
    $font_url = '';
    $font_families = array();
    $roboto = _x('on', 'Roboto font: on or off', 'modus');
    $reem_kufi = _x('on', 'Reem Kufi font: on or off', 'modus');
    $lato = _x('on', 'Lato font: on or off', 'modus');
    $ropa_sans = _x('on', 'Ropa+Sans font: on or off', 'modus');
    $open_sans = _x('on', 'Open Sans font: on or off', 'modus');
    if ('off' !== $roboto) {
        $font_families[] = 'Roboto:300,300i,400,400i,600,600i,700,700i,800,800i';
    }
    if ('off' !== $reem_kufi) {
        $font_families[] = 'Reem Kufi';
    }
    if ('off' !== $lato) {
        $font_families[] = 'Lato:100,100i,300,300i,400,400i,700,700i,900,900i';
    }
    if ('off' !== $ropa_sans) {
        $font_families[] = 'Ropa Sans:400,400i';
    }
    if ('off' !== $open_sans) {
        $font_families[] = 'Open Sans:300,300i,400,400i,600,600i,700,700i';
    }
    $query_args = array(
        'family' => urlencode(implode('|', $font_families)),
        'subset' => urlencode('latin,latin-ext'),
    );
    $fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
    return esc_url_raw($fonts_url);
}

add_action('wp_enqueue_scripts', 'modus_enqueue_scripts', 1000);
function modus_enqueue_scripts()
{
	global $modus_settings;
    $modus_settings = modus_settings();
    $modus__styles = modus_theme_styles();
    $modus__scripts = modus_theme_scripts();
    $modus_rtl='';
    $modus_text_day = (isset($modus_settings['under-contr-day']) && $modus_settings['under-contr-day'] != '') ? $modus_settings['under-contr-day'] : 'Days';
    $modus_text_hour = (isset($modus_settings['under-contr-hour']) && $modus_settings['under-contr-hour'] != '') ? $modus_settings['under-contr-hour'] : 'Hours';
    $modus_text_min = (isset($modus_settings['under-contr-min']) && $modus_settings['under-contr-min'] != '') ? $modus_settings['under-contr-min'] : 'Mins';
    $modus_text_sec = (isset($modus_settings['under-contr-sec']) && $modus_settings['under-contr-sec'] != '') ? $modus_settings['under-contr-sec'] : 'Secs';

    // comment reply
    if (is_singular() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
    wp_dequeue_script('cost-handle');
    if(is_rtl()){
        $modus_rtl = 'yes';
    }
    wp_enqueue_style('modus-fonts', modus_fonts_url(), array(), MODUS_VERSION);
    wp_enqueue_style('bootstrap', $modus__styles['bootstrap'], array(), MODUS_VERSION);
    wp_enqueue_style('font-awesome', $modus__styles['font-awesome'], array(), MODUS_VERSION);
    wp_enqueue_style('pe-icon-7-stroke', $modus__styles['pe-icon'], array(), MODUS_VERSION);
    wp_enqueue_style('pe-icon-7-filled', $modus__styles['pe-filled'], array(), MODUS_VERSION);
    wp_enqueue_style('pe-icon-social', $modus__styles['pe-icon-social'], array(), MODUS_VERSION);
    wp_enqueue_style('flexslider', $modus__styles['flexslider'], array(), MODUS_VERSION);
    wp_enqueue_style('fancybox', $modus__styles['fancybox'], array(), MODUS_VERSION);
    wp_enqueue_style('modus-icon', $modus__styles['modus-icon'], array(), MODUS_VERSION);
    if (is_rtl()) {
        wp_enqueue_style('modus-theme', $modus__styles['theme-rtl'], array(), MODUS_VERSION);
        $modus_custom_css = modus_custom_css();
        wp_add_inline_style('modus-theme', $modus_custom_css);
    }else{
        wp_enqueue_style('modus-theme', $modus__styles['theme'], array(), MODUS_VERSION);
        $modus_custom_css = modus_custom_css();
        wp_add_inline_style('modus-theme', $modus_custom_css);
    }
    
    wp_enqueue_style('modus-styles', get_stylesheet_uri());

    wp_enqueue_script('bootstrap', $modus__scripts['bootstrap'], array('jquery'), '1.0', true);
    wp_enqueue_script('modus-js-countdownTimer', $modus__scripts['countdownTimer'], array('jquery'), '1.0', true);
    wp_enqueue_script('jquery-slick', $modus__scripts['slick'], array('jquery'), '1.0', true);
    wp_enqueue_script('jquery-animate', $modus__scripts['animate'], array('jquery'), '1.0', true);
    wp_enqueue_script('jquery-isotop', $modus__scripts['isotop'], array('jquery'), '1.0', true);
    wp_enqueue_script('jquery-flexslider', $modus__scripts['jquery-flexslider'], array('jquery'), '1.0', true);
    wp_enqueue_script('jquery-fancybox', $modus__scripts['fancybox'], array('jquery'), '1.0', true);
    wp_enqueue_script('modus-js-main', $modus__scripts['main'], array('jquery'), '1.0', true);
    wp_enqueue_script('modus-js-customs', $modus__scripts['custom'], array('jquery', 'jquery-masonry', 'masonry'), '1.0', true);
    wp_enqueue_script('jquery-carousel', $modus__scripts['carousel'], array('jquery'), '1.0', true);
    wp_localize_script('modus-js-customs', 'modus_ajax_load_more', array(
        'ajaxurl' => admin_url('admin-ajax.php')
    ));
    wp_localize_script('modus-js-main', 'modus_ajax_product', array(
        'ajaxurl' => admin_url('admin-ajax.php')
    ));
    if (isset($modus_settings['js-code'])){
        wp_add_inline_script( 'modus-js-customs', $modus_settings['js-code'] ); 
    }  
	wp_localize_script('modus-js-customs', 'modus_params', array(
		'modus_sticky_menu' => $modus_settings['modus_sticky'],
        'modus_rtl' => esc_js($modus_rtl),
        'modus_text_day' => esc_js($modus_text_day),
        'modus_text_hour' => esc_js($modus_text_hour),
        'modus_text_min' => esc_js($modus_text_min),
        'modus_text_sec' => esc_js($modus_text_sec),
	));
}

update_option('wpb_js_content_types', array('page', 'block', 'arr_megamenu'));
update_option('ultimate_css', 'disable');
update_option('ultimate_js', 'enable');