<div class=" header_5 <?php echo esc_attr(modus_header_fixed())?>">
<?php 
	$modus_config = modus_settings(); 
	if( $modus_config['topbar_txt'] !=''){
		if(get_option('topbar_txt')){
			$topbar_txt = get_option('topbar_txt');
		}else{
			$topbar_txt = $modus_config['topbar_txt'];
		}
	}
?>
<?php if( isset($modus_config['header_5_topbar_show']) && $modus_config['header_5_topbar_show'] =='show'){?>
	<div class="header-top header5-top">
		<div class="container">
			<div class="row">
				<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 col-left">
					<?php
						$myaccount_page_id = get_option('woocommerce_myaccount_page_id');
						$logout_url = wp_logout_url(get_permalink($myaccount_page_id));
						if (get_option('woocommerce_force_ssl_checkout') == 'yes') {
							$logout_url = str_replace('http:', 'https:', $logout_url);
						}
					?>
					<div class="register-link">
						<?php if (is_user_logged_in()): ?>                  
							<p>
								<a href="<?php echo esc_url(get_permalink($myaccount_page_id)); ?>"><?php echo esc_html__('My Account', 'modus') ?></a> | 
								<a href="<?php echo esc_url($logout_url) ?>"><?php echo esc_html__('Logout', 'modus') ?></a>
							</p>
						<?php else: ?>
							<?php echo wp_kses_post($topbar_txt); ?>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 col-right">

					<ul class="nav-social">
						<?php
						$modus_social_array=array(
							'facebook' 			=>'fa-facebook',
							'twitter' 			=>'fa-twitter',
							'google-plus' 		=>'fa-google-plus',
							'pinterest' 		=>'fa-pinterest-p',
							'instagram' 		=>'fa-instagram',
							'dribbble' 			=>'fa-dribbble',
							'flickr' 			=>'fa-flickr',
							'linkedin' 			=>'fa-linkedin',
							'behance' 			=>'fa-behance',
						);
						foreach($modus_social_array as $key => $value){
							if ( $modus_config['social_'.$key.'_link'] != '' ) :
								echo '<li><a href="'.$modus_config['social_'.$key.'_link'].'"><i class="fa '.$value.'" aria-hidden="true"></i></a></li>';
							endif;
						}
						?>
					</ul>
				</div>
			</div>
		</div>
	</div>
<?php } ?>
	<div id="header_v5" class="header header-v5">
		<div class="container">
			<div class="header_wrap">
				<div class="row header-center">
					<div class="col-lg-3 col-md-2 col-sm-3 col-xs-6">
						<div class="logo align-left">
							<?php $is_home_page = get_post_meta( get_the_ID(),'is_home_page',true); ?>
							<?php if ( is_front_page()  || $is_home_page  ) : ?>
								<h1 class="logo_home">
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
										<?php modus_logo(); ?>
									</a>
								</h1>
							<?php else:?>
								<a class="logo-page" href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<?php modus_logo(); ?>
								</a>
							<?php endif;?>
						</div>
					</div>
					<div class="col-lg-9 col-md-10 col-sm-9 col-xs-6 col-menu">
						<div class="line-1">
							<div class="left">
								<div class="main-nav">
									<div class="close-menu"><i class="fa fa-close"></i></div>
									<div class="main-navigation">
										<?php
											if ( $modus_config['header_5_menu'] != '' ){
												$menu_id = $modus_config['header_5_menu'];
											}else{
												$menu_id = '';
											}
											if ( $menu_id == '' ) :
												if ( has_nav_menu( 'primary' ) ) :
													wp_nav_menu( array(
														'theme_location' => 'primary',
														'menu_class'     => 'primary-menu',
													) );
												endif;
											else:
												wp_nav_menu( array(
													'menu'    => $menu_id,
													'title_li'          => '',
													'menu_class'        => 'primary-menu',
												) );
											endif;
										?>
									</div>
								</div>
							</div>
							<div class="right">
								<div class="menu-button">
									<button class="btn-responsive-nav"><i class="fa fa-bars fa-lg"></i></button>
								</div>
								<div class="close-menu"></div>
								<div class="mini-cart">
									<div class="inline icon-search">
										<div class="dropdown">
											<button class="dropdown-toggle" type="button" data-toggle="dropdown" >
												<i class="icon-search3"></i>
											</button>
											<div class="dropdown-menu">
												<div class="search-popup">
													<?php echo get_search_form();?>
												</div>
											</div>
										</div>
									</div>
									<?php if( isset($modus_config['header_5_cart']) && $modus_config['header_5_cart'] =='show'){?>
										<?php
											if(function_exists('modus_header_minicart')) modus_header_minicart();
										?>
									<?php } ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div><!-- #header_v1-->
</div>
