<?php
/*add filter*/
add_filter( 'loop_shop_per_page', 'modus_num_product', 20 );
 
remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display'); 
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40); 
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 5);
remove_action( 'woocommerce_catalog_ordering','woocommerce_before_shop_loop',30 );
add_action( 'sort','woocommerce_catalog_ordering', 40 );
add_filter( 'woocommerce_checkout_fields' , 'modus_custom_override_default_address_fields' );
add_action( 'wp_loaded', 'modus_page_width_function');
add_filter( 'woocommerce_show_subcategories', 'woocommerce_maybe_show_product_subcategories' );

//menu_order, popularity, rating, date, price, price-desc 
function modus_customize_fields_name_woocommerce_catalog_orderby( $orderby ) {
    $orderby["date"] = __('Newness', 'modus');
    $orderby["popularity"] = __('Popularity', 'modus');
    $orderby["rating"] = __('Average rating', 'modus');
    $orderby["price"] = __('Price: low to high', 'modus');
    $orderby["price-desc"] = __('Price: high to low', 'modus');
    return $orderby;
}
add_filter( "woocommerce_catalog_orderby", "modus_customize_fields_name_woocommerce_catalog_orderby", 40 );
if ( ! function_exists( 'woocommerce_show_subcategories' ) ) {

	/**
	 * Output the start of a product loop. By default this is a UL.
	 *
	 * @param bool $echo Should echo?.
	 * @return string
	 */
	function woocommerce_show_subcategories( $echo = true ) {
		ob_start();

		if ( $echo ) {
			echo apply_filters( 'woocommerce_show_subcategories', ob_get_clean() );
		} else {
			return apply_filters( 'woocommerce_show_subcategories', ob_get_clean() );
		}
	}
}
function modus_page_width_function() { 
	if(get_post_meta(get_option( 'woocommerce_shop_page_id' ), 'content_width', true)){}else{
		add_post_meta(get_option( 'woocommerce_shop_page_id' ), 'content_width', 'content_width');
	}
	if(get_post_meta(get_option( 'woocommerce_cart_page_id' ), 'content_width', true)){}else{
		add_post_meta(get_option( 'woocommerce_cart_page_id' ), 'content_width', 'content_width');
	} 
	if(get_post_meta(get_option( 'woocommerce_checkout_page_id' ), 'content_width', true)){}else{
		add_post_meta(get_option( 'woocommerce_checkout_page_id' ), 'content_width', 'content_width');
	}   
	if(get_post_meta(get_option( 'woocommerce_pay_page_id' ), 'content_width', true)){}else{
		add_post_meta(get_option( 'woocommerce_pay_page_id' ), 'content_width', 'content_width');
	}    
	if(get_post_meta(get_option( 'woocommerce_thanks_page_id' ), 'content_width', true)){}else{
		add_post_meta(get_option( 'woocommerce_thanks_page_id' ), 'content_width', 'content_width');
	}   
	if(get_post_meta(get_option( 'woocommerce_myaccount_page_id' ), 'content_width', true)){}else{
		add_post_meta(get_option( 'woocommerce_myaccount_page_id' ), 'content_width', 'content_width');
	}    
	if(get_post_meta(get_option( 'woocommerce_edit_address_page_id' ), 'content_width', true)){}else{
		add_post_meta(get_option( 'woocommerce_edit_address_page_id' ), 'content_width', 'content_width');
	}    
	if(get_post_meta(get_option( 'woocommerce_view_order_page_id' ), 'content_width', true)){}else{
		add_post_meta(get_option( 'woocommerce_view_order_page_id' ), 'content_width', 'content_width');
	}    
	if(get_post_meta(get_option( 'woocommerce_terms_page_id' ), 'content_width', true)){}else{
		add_post_meta(get_option( 'woocommerce_terms_page_id' ), 'content_width', 'content_width');
	}       
}
add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function( $size ) {
return array(
	'width' => 150,
	'height' => 150,
	'crop' => 1,
	);
} );
// Our hooked in function - $address_fields is passed via the filter!
function modus_custom_override_default_address_fields( $fields  ) {
     $fields ['billing']['billing_email']['class'] = array('form-row-first'); 
     $fields ['billing']['billing_phone']['class'] = array('form-row-last');  
     return $fields;
}
function modus_product_view() {
	if ( ! is_singular( 'product' ) ) {
		return;
	}
	global $post;
	if ( empty( $_COOKIE['woocommerce_recently_viewed'] ) )
		$viewed_products = array();
	else
		$viewed_products = (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] );

	if ( ! in_array( $post->ID, $viewed_products ) ) {
		$viewed_products[] = $post->ID;
	}
	if ( sizeof( $viewed_products ) > 15 ) {
		array_shift( $viewed_products );
	}
	wc_setcookie( 'woocommerce_recently_viewed', implode( '|', $viewed_products ) );
}
add_action( 'template_redirect', 'modus_product_view', 20 );
function modus_num_product(){
    global $modus_settings;
		if(isset($_GET['modus_perpage'])){
        return (int)$_GET['modus_perpage'];
    }else{
		if ( isset( $_GET['column']) ){
				$column = $_GET['column'];
		}else{
				$column = $modus_settings['column'];
		}
		switch ( $column ) {
			case '2':
				return (int)$modus_settings['archive_product_num_item_2'];
				break;
			case '3':
				return (int)$modus_settings['archive_product_num_item_3'];
				break;
			case '4':
				return (int)$modus_settings['archive_product_num_item_4'];
				break;
			case '5':
				return (int)$modus_settings['archive_product_num_item_5'];
				break;
			default:
				return (int)get_option('posts_per_page');
				# code...
				break;
		}
	}
}
function modus_header_minicart(){
	if ( ! WC()->cart->is_empty() ) :
		$modus_cart_num = WC()->cart->get_cart_contents_count();
	else: $modus_cart_num =0;
	endif;
	?>
	<div class="modus-cart"> 
		<button class="dropdown-toggle" type="button">
			<i class="icon-bag"></i><span class="cart-num"><?php echo esc_html($modus_cart_num); ?></span>
			<span class="modus_total"><?php echo WC()->cart->get_cart_subtotal(); ?></span>
		</button>
		<div class="modus-cart-lightbox"> 
		<div class="widget-heading">
			<h3 class="widget-title"><?php echo esc_html__('Shopping cart','modus'); ?></h3>
			<a href="#" class="widget-close"><?php echo esc_html__('close','modus'); ?></a>
		</div>
		<?php modus_minicart() ?> 
		</div> 
	</div> 
	<div class="modus-close-cart"></div>
<?php
}
function modus_minicart(){
	ob_start();
	echo '<div class="widget_shopping_cart_content">';
	get_template_part( 'woocommerce/cart/mini-cart' );
	echo '</div>';
	echo ob_get_clean();
}
// Remove product in the cart using ajax
function warp_ajax_product_remove(){ 
    // Get mini cart
    ob_start(); 
    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item)
    {
        if($cart_item['product_id'] == $_POST['product_id'] && $cart_item_key == $_POST['cart_item_key'] )
        {
            WC()->cart->remove_cart_item($cart_item_key);
        }
    } 
    WC()->cart->calculate_totals();
    WC()->cart->maybe_set_cart_cookies(); 
    modus_minicart(); 
    $mini_cart = ob_get_clean(); 
    // Fragments and mini cart are returned
    $data = array(
        'fragments' => apply_filters( 'woocommerce_add_to_cart_fragments', array(
                'div.widget_shopping_cart_content' => '<div class="widget_shopping_cart_content">' . $mini_cart . '</div>'
            )
        ),
        'cart_hash' => apply_filters( 'woocommerce_add_to_cart_hash', WC()->cart->get_cart_for_session() ? md5( json_encode( WC()->cart->get_cart_for_session() ) ) : '', WC()->cart->get_cart_for_session() )
    ); 
    wp_send_json( $data ); 
    die();
} 
add_action( 'wp_ajax_product_remove', 'warp_ajax_product_remove' );
add_action( 'wp_ajax_nopriv_product_remove', 'warp_ajax_product_remove' );
function modus_add_compare_action($product_id){
    $action = 'yith-woocompare-add-product';
    $url_args = array('action' => $action, 'id' => $product_id);
    return wp_nonce_url(add_query_arg($url_args), $action);
}
// Remove default WooCommerce breadcrumbs and add Yoast ones instead
remove_action( 'woocommerce_before_main_content','woocommerce_breadcrumb', 20, 0);

function modus_product_search_form( $form ) {
    $form = '<form role="search" method="get" class="search-form" action="'. esc_url( home_url( '/' ) ) .'">
		<label>
			<input type="search" class="search-field" placeholder="'.esc_attr__('Search for products','modus').'" value="" name="s">
		</label>
		<button type="submit" class="search-submit"><span class="Pe-icon-7-stroke color_333"></span></button>
		<input type="hidden" name="post_type" value="product">
	</form>';
    return $form;
}
add_filter( 'get_product_search_form', 'modus_product_search_form' );
function modus_product_stock( $_product ) {
  if($_product->get_stock_quantity() !=''){
		if(get_post_meta( $_product->id, 'total_sales', true )){
			$units_sold = get_post_meta( $_product->id, 'total_sales', true );
		}else{
			$units_sold = 0;
		}
		$units_stock = $_product->get_stock_quantity();
		$_atomatic_width = 0;
		if($_product->get_stock_quantity() !=0 ){
			$_atomatic_count_stock = (int)$units_stock + (int)$units_sold;
			$_atomatic_width = ((int)$units_stock / $_atomatic_count_stock) * 100;
		}
		echo '<div class="stock_number"><div class="already_sold">Already Sold: <b>'.$units_sold.'</b></div><div class="available">Avaiable: <b>'.$units_stock.'</b></div></div>';
		echo'<div class="stock_scroll"><div class="avaiable" style="width: '.$_atomatic_width.'%"></div></div>';
	}
}
add_filter( 'get_product_search_form', 'modus_product_search_form' );


function modus_order_billing_fields($fields) {
    $order = array(
        "billing_country",
        "billing_first_name",
        "billing_last_name",
        "billing_company",
        "billing_address_1",
        "billing_address_2",
        "billing_city",
        "billing_state",
        "billing_postcode",
        "billing_email",
        "billing_phone"
    );
    foreach($order as $field)
    {
        $ordered_fields[$field] = $fields["billing"][$field];
    }

    $fields["billing"] = $ordered_fields;
    return $fields;

}
function modus_order_shipping_fields($fields) {
    $order = array(
        "shipping_country",
        "shipping_first_name",
        "shipping_last_name",
        "shipping_company",
        "shipping_address_1",
        "shipping_address_2",
        "shipping_city",
        "shipping_state",
        "shipping_postcode",
        "shipping_email",
        "shipping_phone"

    );
    foreach($order as $field)
    {
        $ordered_fields[$field] = $fields["shipping"][$field];
    }

    $fields["shipping"] = $ordered_fields;
    return $fields;

}
function modus_override_billing_fields( $fields ) {
  $fields['billing_first_name'] = array(
        'label' => esc_html__('First Name','modus'),
        'placeholder' => _x('First Name *', 'placeholder', 'modus'),
        'required' => true,
    );
    $fields['billing_last_name'] = array(
        'label' => esc_html__('Last Name','modus'),
        'placeholder' => _x('Last Name *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['billing_company'] = array(
        'label' => esc_html__('Company name','modus'),
        'placeholder' => _x('Company Name', 'placeholder', 'modus'),
        'required' => false,
    );
  $fields['billing_email'] = array(
        'label' => 'Email',
        'placeholder' => _x('E-mail *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['billing_phone'] = array(
        'label' => 'Phone',
        'placeholder' => _x('Phone *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['billing_address_1'] = array(
        'label' => 'Address',
        'placeholder' => _x('Street Address *', 'placeholder', 'modus'),
        'required' => false,
    );
  $fields['billing_address_2'] = array(
        'label' => esc_html__('Apartment, suite, unit etc. (optional)','modus'),
        'placeholder' => _x('Apartment, suite, unit etc. (optional)', 'placeholder', 'modus'),
        'required' => false,
    );
  $fields['billing_postcode'] = array(
        'label' => esc_html__('Postcode / Zip','modus'),
        'placeholder' => _x('Postcode / Zip *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['billing_city'] = array(
        'label' => esc_html__('Town / City','modus'),
        'placeholder' => _x('Town / City *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['billing_phone'] = array(
        'label' => esc_html__('Phone','modus'),
        'placeholder' => _x('Phone *', 'placeholder', 'modus'),
        'required' => true,
    );
  return $fields;
}
function modus_override_shipping_fields( $fields ) {
  $fields['shipping_first_name'] = array(
        'label' => esc_html__('First Name','modus'),
        'placeholder' => _x('First Name *', 'placeholder', 'modus'),
        'required' => true,
    );
    $fields['shipping_last_name'] = array(
        'label' => esc_html__('Last Name','modus'),
        'placeholder' => _x('Last Name *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['shipping_company'] = array(
        'label' => esc_html__('Company name','modus'),
        'placeholder' => _x('Company Name', 'placeholder', 'modus'),
        'required' => false,
    );
  $fields['shipping_email'] = array(
        'label' => 'Email',
        'placeholder' => _x('E-mail *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['shipping_phone'] = array(
        'label' => 'Phone',
        'placeholder' => _x('Phone *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['shipping_address_1'] = array(
        'label' => 'Address',
        'placeholder' => _x('Street Address *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['shipping_address_2'] = array(
        'label' => esc_html__('Apartment, suite, unit etc. (optional)','modus'),
        'placeholder' => _x('Apartment, suite, unit etc. (optional)', 'placeholder', 'modus'),
        'required' => false,
    );
  $fields['shipping_postcode'] = array(
        'label' => esc_html__('Postcode / Zip','modus'),
        'placeholder' => _x('Postcode / Zip *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['shipping_city'] = array(
        'label' => esc_html__('Town / City','modus'),
        'placeholder' => _x('Town / City *', 'placeholder', 'modus'),
        'required' => true,
    );
  $fields['shipping_phone'] = array(
        'label' => esc_html__('Phone','modus'),
        'placeholder' => _x('Phone *', 'placeholder', 'modus'),
        'required' => true,
    );
  return $fields;
}
function modus_custom_override_checkout_fields($fields) {
	 
	$fields['billing']['billing_phone'] = array(
			'label' => esc_html__('Phone','modus'), 
			'required' => true,
			'class'     => array('form-row-first'),
	);
	$fields['billing']['billing_email'] = array(
			'label' => esc_html__('Email Address','modus'), 
			'required' => true,
			'class'     => array('form-row-last'),
	); 
	return $fields;
} 
$wc_admin_report = WC()->plugin_path() . '/includes/admin/reports/class-wc-admin-report.php';
require_once $wc_admin_report;
class WC_Bestseller extends WC_Admin_Report{
    public function list_product_bestseller(){
        $args_bestseller = array(
            'data'         => array(
                '_product_id' => array(
                    'type'            => 'order_item_meta',
                    'order_item_type' => 'line_item',
                    'function'        => '',
                    'name'            => 'product_id'
                ),
                '_qty'        => array(
                    'type'            => 'order_item_meta',
                    'order_item_type' => 'line_item',
                    'function'        => 'SUM',
                    'name'            => 'order_item_qty'
                )
            ),
            'where_meta'   => array(
                array(
                    'type'       => 'order_item_meta',
                    'meta_key'   => '_line_subtotal',
                    'meta_value' => '0',
                    'operator'   => '>'
                )
            ),
            'order_by'     => 'order_item_qty DESC',
            'group_by'     => 'product_id',
            'limit'        => '',
            'query_type'   => 'get_results',
        );
        $best_sellers = WC_Admin_Report::get_order_report_data( $args_bestseller );
        return $best_sellers;
    }
} 
add_filter( 'woocommerce_output_related_products_args', 'jk_related_products_args' );
function jk_related_products_args( $args ) {
	global $modus_settings;
	$args['posts_per_page'] = $modus_settings['single_product_num_item_related']; // 4 related products
	return $args;
}
function modus_woocommerce_price_html( $price, $product ){
    return preg_replace('@(<del>.*?</del>).*?(<ins>.*?</ins>)@misx', '$2 $1', $price);
}
add_filter( 'woocommerce_get_price_html', 'modus_woocommerce_price_html', 100, 2 );

function modus_get_terms( $id) {
    $pa_reference = modus_get_the_terms( $id, 'pa_reference' );
    $pa_condition = modus_get_the_terms( $id, 'pa_condition' );
    if($pa_reference || $pa_condition){
    ?>
    <div class="attribute">
        <ul>
            <?php if($pa_reference) echo '<li>'. esc_html__( 'Reference', 'modus' ) .': '. $pa_reference.'</li>'; ?>
            <?php if($pa_condition) echo '<li>'. esc_html__( 'Condition', 'modus' ) .': '. $pa_condition.'</li>'; ?>
        </ul>
    </div>
    <?php
    }
}
function modus_get_the_terms( $id, $taxonomy ) {
    $terms= get_the_terms( $id, $taxonomy );
    if ( ! empty( $terms ) && ! is_wp_error( $terms ) && count( $terms )!= 0 ) {
        $count = count( $terms );
        $i = 0;
        $term_list = '';
        foreach ( $terms as $term ) {
            $i++;
            $term_list .= '<a href="' . esc_url( get_term_link( $term ) ) . '" alt="' . esc_attr( sprintf( esc_html__( 'View all post filed under %s', 'modus' ), $term->name ) ) . '">' . $term->name . '</a>';
            if ( $count != $i ) {
                $term_list .= '&sbquo; ';
            }
            else {
                $term_list .= '';
            }
        }
        return $term_list;
    }else{
        return false;
    }
}

function modus_addShortcodesCustomCss( $id = null ) {
	if (is_shop()){
		$id = get_option( 'woocommerce_shop_page_id' );
	}
	if ( $id ) {
		$shortcodes_custom_css = get_post_meta( $id, '_wpb_shortcodes_custom_css', true );
		if ( ! empty( $shortcodes_custom_css ) ) { 
			echo '<style type="text/css" data-type="vc_shortcodes-custom-css">';
			echo strip_tags( $shortcodes_custom_css );
			echo '</style>';
		}
	}
}
function modus_addPageCustomCss( $id = null ) {
	if (is_shop()){
		$id=get_option( 'woocommerce_shop_page_id' );
	}
	if ( $id ) {
		$post_custom_css = get_post_meta( $id, '_wpb_post_custom_css', true );
		if ( ! empty( $post_custom_css ) ) { 
			echo '<style type="text/css" data-type="vc_custom-css">';
			echo strip_tags( $post_custom_css );
			echo '</style>';
		}
	}
}
function modus_addShopCss() {
	modus_addPageCustomCss();
	modus_addShortcodesCustomCss();
}
add_action( 'wp_footer', 'modus_addShopCss', 1000 );
function modus_share_yith(){
	if(class_exists('YITH_WCWL') || class_exists( 'YITH_WOOCOMPARE' ) || class_exists( 'YITH_WCQV')){ 
		if(class_exists( 'YITH_WCQV')){
            echo '<div class="btn-share btn-view">';
            printf('<div class="add-to"><a onclick="" href="#" class="yith-wcqv-button button" data-toggle="tooltip" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-search"></i></a></div>', get_the_ID(), esc_attr__('Quick View', 'modus'));
            echo '</div>';
        }
        if (class_exists('YITH_WCWL')) {
			echo ' <div class="btn-share btn-wishlist">';
				echo do_shortcode('[yith_wcwl_add_to_wishlist]');
			echo '</div>';
		}
		if(class_exists( 'YITH_WOOCOMPARE' ) ) {
			echo '<div class="btn-share btn-compare">';
				printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s" data-product_id="%d" title="%s"><i class="Pe-icon-7-stroke-copy-file"></i></a></div>', modus_add_compare_action( get_the_ID() ), 'add_to_compare compare button', get_the_ID(), esc_attr__('Compare', 'modus'));
			echo '</div>';
		} 
		
	}  
} 
add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );
