<?php 
require_once(MODUS_FUNCTIONS . '/ajax.php'); 
if (class_exists('Woocommerce')) {
    require_once(MODUS_FUNCTIONS . '/woocommerce.php');
}
function modus_check_theme_options() {
    // check default options
    global $modus_settings;
    if(!get_option('modus_settings')) {
        ob_start();
        include(MODUS_PLUGINS . '/theme_options.php');
        $options = ob_get_clean();
        $modus_default_settings = json_decode($options, true);
        if (is_array($modus_default_settings) || is_object($modus_default_settings))
        {
            foreach ($modus_default_settings as $key => $value) {
                if (is_array($value)) {
                    foreach ($value as $key1 => $value1) {
                        if (!isset($modus_settings[$key][$key1]) || !$modus_settings[$key][$key1]) {
                            $modus_settings[$key][$key1] = $modus_default_settings[$key][$key1];
                        }
                    }
                } else {
                    if (!isset($modus_settings[$key])) {
                        $modus_settings[$key] = $modus_default_settings[$key];
                    }
                }
            }
        }
    }

    return $modus_settings;
}
if(!class_exists('ReduxFramework')) {
     modus_check_theme_options();
}
if (!isset($content_width)) {
    $content_width = 1140;
}
if (!function_exists('modus_setup')) {
	function modus_setup() {
		load_theme_textdomain('modus', get_template_directory() . '/languages');
		add_editor_style(array('styles.css'));
		add_theme_support( 'post-formats', array(
				'image', 'video', 'audio', 'quote', 'link', 'gallery',
		) );
		add_theme_support('automatic-feed-links');
		register_nav_menu('primary', esc_html__('Primary Menu', 'modus'));
		register_nav_menu( 'quickly', esc_html__( 'Quickly Menu', 'modus' ) ); 
		add_theme_support( 'custom-header' );
		add_theme_support( 'custom-background' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support('woocommerce'); 
	}
}
add_action('after_setup_theme', 'modus_setup');

function modus_get_post_media(){
	global $modus_settings;
	$modus_post_layout = '';
	$blog_config = modus_settings();
	if(isset($blog_config['blog-layout'])){
		if($blog_config['blog-layout'] =='default'){
			$modus_post_layout = '';
		}else{
			$modus_post_layout = $blog_config['blog-layout'];
		}
	}
	if ( isset( $_GET['layout'])){
		if($_GET['layout'] == '2') $modus_post_layout ='layout2';
		elseif($_GET['layout'] == '3') $modus_post_layout ='layout3';
		elseif($_GET['layout'] == '4') $modus_post_layout ='layout4'; 
	}
	$gallery = get_post_meta(get_the_ID(), 'images_gallery', true);
	$attachment_id = get_post_thumbnail_id(); 
	$image_list = modus_get_attachment($attachment_id, 'modus-blog');
	$image_grid = modus_get_attachment($attachment_id, 'modus-blog-2');
	$image_grid3 = modus_get_attachment($attachment_id, 'modus-blog-3');
	$image_alt = modus_get_attachment($attachment_id, 'full');
	$blog_id =  'blog_id-'.wp_rand();
	?>
	<?php if ( get_post_format() == 'video') : ?>
		<?php $video = get_post_meta(get_the_ID(), 'post_video_url', true); ?>
		<?php if ($video && $video != ''): ?>
			<?php if(is_singular()): ?>
				<div class="thumbnail-post blog-video">
					<a data-fancybox href="<?php echo esc_url($video); ?>"><img width="<?php echo esc_attr($image_list['width']) ?>" height="<?php echo esc_attr($image_list['height']) ?>" src="<?php echo esc_url($image_list['src']) ?>" alt="<?php echo esc_attr($image_list['alt']) ?>" /> <i class="fa fa-play-circle-o"></i></a>
				</div>
			<?php else: ?>
				<div class="blog-video">
					<?php if ($modus_post_layout == 'layout2'): ?>
						<div class="thumbnail-post">
							<a data-fancybox href="<?php echo esc_url($video); ?>"><img width="<?php echo esc_attr($image_grid['width']) ?>" height="<?php echo esc_attr($image_grid['height']) ?>" src="<?php echo esc_url($image_grid['src']) ?>" alt="<?php echo esc_attr($image_grid['alt']) ?>" /> <i class="fa fa-play-circle-o"></i></a>
						</div>
					<?php elseif ($modus_post_layout == 'layout3'): ?>
						<a data-fancybox href="<?php echo esc_url($video); ?>"><img width="<?php echo esc_attr($image_grid3['width']) ?>" height="<?php echo esc_attr($image_grid3['height']) ?>" src="<?php echo esc_url($image_grid3['src']) ?>" alt="<?php echo esc_attr($image_grid3['alt']) ?>" /> <i class="fa fa-play-circle-o"></i></a>
					<?php else: ?>
						<div class="thumbnail-post">
							<a data-fancybox href="<?php echo esc_url($video); ?>"><img width="<?php echo esc_attr($image_list['width']) ?>" height="<?php echo esc_attr($image_list['height']) ?>" src="<?php echo esc_url($image_list['src']) ?>" alt="<?php echo esc_attr($image_list['alt']) ?>" /> <i class="fa fa-play-circle-o"></i></a>
						</div>
				<?php endif; ?>
				</div>
			<?php endif; ?>
		<?php endif; ?>
	<?php elseif ( get_post_format() == 'audio') : ?>
		<?php $video = get_post_meta(get_the_ID(), 'post_audio_url', true); ?>
		<?php if ($video && $video != ''): ?>
			<?php if ($modus_post_layout == 'layout2'): ?>
				<div class="thumbnail-post">
					<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid['width']) ?>" height="<?php echo esc_attr($image_grid['height']) ?>" src="<?php echo esc_url($image_grid['src']) ?>" alt="<?php echo esc_attr($image_grid['alt']) ?>" /></a>
				</div>
			<?php else: ?>
				<div class="blog-audio">                    
					<?php if (strpos($video,'iframe') !== false):?>
						<?php echo wp_kses($video,array(
						  'iframe' => array(
							'height' => array(),
							'style' => array(),
							'src' => array(),
							'allowfullscreen' => array(),
							)
						)); ?>                            
					<?php else: ?>
						<iframe src="<?php echo esc_url(is_ssl() ? str_replace( 'http://', 'https://', $video ) : $video); ?> " width="100%" <?php if(get_post_format() == 'audio'){echo 'height="400"';}?>></iframe>
					<?php endif;?>               
				</div>
			<?php endif; ?>
		<?php endif; ?>
	<?php elseif(has_post_format('link')):?>
		<?php 
            $link = get_post_meta(get_the_ID(), 'post_link_url', true); 
            $link_title = get_post_meta(get_the_ID(), 'post_link_title', true);
        ?>
        <?php if($link && $link != ''):?>
			<?php if ($modus_post_layout == 'layout2'): ?>
				<div class="thumbnail-post">
					<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid['width']) ?>" height="<?php echo esc_attr($image_grid['height']) ?>" src="<?php echo esc_url($image_grid['src']) ?>" alt="<?php echo esc_attr($image_grid['alt']) ?>" /></a>
				</div>
			<?php elseif ($modus_post_layout == 'layout4'): ?>
				<div class="blog-images">
					<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_list['width']) ?>" height="<?php echo esc_attr($image_list['height']) ?>" src="<?php echo esc_url($image_list['src']) ?>" alt="<?php echo esc_attr($image_list['alt']) ?>" /></a>
				</div>
			<?php else: ?>
				<figure class="quote link">
					<div class="quote_section clearfix">
						<div class="link-icon">
							<i class="fa fa-link"></i>
						</div>
						<div class="link-post">
							<a class="post_link" href="<?php echo esc_url(is_ssl() ? str_replace( 'http://', 'https://', $link ) : $link);?>">
								<?php if($link_title && $link_title != ''):?>
									<span><?php echo wp_kses($link_title,array());?></span>
								<?php endif;?> 
							</a>
						</div>
					</div>
				</figure>
			<?php endif;?> 
		<?php endif;?> 
	<?php elseif(has_post_format('quote')):?>
        <?php 
            $quote = get_post_meta(get_the_ID(), 'post_quote_content', true); 
            $quote_author = get_post_meta(get_the_ID(), 'post_quote_by', true); 
        ?>
        <?php if(is_singular()):?>
			<div class="thumbnail-post">
				<img width="<?php echo esc_attr($image_list['width']) ?>" height="<?php echo esc_attr($image_list['height']) ?>" src="<?php echo esc_url($image_list['src']) ?>" alt="<?php echo esc_attr($image_list['alt']) ?>" />
			</div>
            <?php if($quote && $quote != ''):?>
                <figure class="quote">
                    <div class="quote_section">
						<div class="quote-icon">
							<i class="fa fa-quote-left" aria-hidden="true"></i>
						</div>
						<blockquote class="var3">
                            <?php echo wp_kses($quote,array());?>
							<?php if($quote_author && $quote_author != ''):?>
								<div class="author_info"><span><?php echo esc_html__('By','modus'); ?></span> - <?php echo  wp_kses($quote_author,array());?></div>
							<?php endif;?> 
                        </blockquote>
                    </div>
                </figure>
            <?php endif;?>  
        <?php else: ?>
            <?php if ($modus_post_layout == "layout2"): ?>
                <div class="thumbnail-post">
					<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid['width']) ?>" height="<?php echo esc_attr($image_grid['height']) ?>" src="<?php echo esc_url($image_grid['src']) ?>" alt="<?php echo esc_attr($image_grid['alt']) ?>" /></a>
				</div>
			<?php elseif ($modus_post_layout == "layout4"): ?>
				<div class="blog-image">
					<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_list['width']) ?>" height="<?php echo esc_attr($image_list['height']) ?>" src="<?php echo esc_url($image_list['src']) ?>" alt="<?php echo esc_attr($image_list['alt']) ?>" /></a>
				</div>
		   <?php else: ?>
                <?php if($quote && $quote != ''):?>
                    <figure class="quote">
                        <div class="quote_section">
							<div class="quote-icon">
								<i class="fa fa-quote-left" aria-hidden="true"></i>
							</div>
							<blockquote class="var3">
                                <?php echo wp_kses($quote,array());?>
								<?php if($quote_author && $quote_author != ''):?>
									<div class="author_info"><span><?php echo esc_html__('By','modus'); ?></span> - <?php echo  wp_kses($quote_author,array());?></div>
								<?php endif;?> 
                            </blockquote> 
                        </div>
                    </figure>
                <?php endif;?>  
            <?php endif; ?>  
        <?php endif; ?>  
	<?php elseif(has_post_format('gallery')): ?>
		<?php
			global $post;
			$gallery = get_post_meta($post->ID, 'post_gallery_id', true);
            $gallery = explode (',',$gallery);
		?>
        <?php if (is_array($gallery) && count($gallery) > 1) : ?>   
            <?php if(is_singular()):?>
                <div  id="<?php echo esc_attr($blog_id); ?>" class="blog-gallery thumbnail-post"> 
                    <?php
                    $index = 0;
                    foreach ($gallery as $key => $value) :
                        $image_list = wp_get_attachment_image_src($value, 'modus-blog');
								echo '<div class="img-gallery">
									<div class="img">
										<img src="' . esc_url($image_list[0]) . '" alt="' . esc_attr($image_alt['title']) . '" class="gallery-img" />
									</div>
								</div>';
                        $index++;
                    endforeach;
                    ?>
                </div> 
            <?php else: ?>   
                <div  id="<?php echo esc_attr($blog_id); ?>" class="blog-gallery thumbnail-post"> 
                    <?php
                    $index = 0;
                    foreach ($gallery as $key => $value) :
                        $image_grid = wp_get_attachment_image_src($value, 'modus-blog-2');
                        $image_list = wp_get_attachment_image_src($value, 'modus-blog');
						$image_grid3 = wp_get_attachment_image_src($value, 'modus-blog-3'); 
                        if ($modus_post_layout == "layout3"){
							echo '<div class="img-gallery">
								<div class="img">
									<img src="' . esc_url($image_grid3[0]) . '" alt="' . esc_attr($image_alt['title']) . '" class="gallery-img" />
								</div>
							</div>';
                        }elseif ($modus_post_layout == "layout2"){
							echo '<div class="img-gallery">
								<div class="img">
									<img src="' . esc_url($image_grid[0]) . '" alt="' . esc_attr($image_alt['title']) . '" class="gallery-img" />
								</div>
							</div>';
                        }else{
							echo '<div class="img-gallery">
								<div class="img">
								   <img src="' . esc_url($image_list[0]) . '" alt="' . esc_attr($image_alt['title']) . '" class="gallery-img" />
								</div>
							</div>';
                        }
                        
                        $index++;
                    endforeach;
                    ?>
                </div>
            <?php endif; ?> 
        <?php else: ?>
            <?php if (has_post_thumbnail()): ?>
				<?php if ($modus_post_layout == 'layout2'): ?>
					<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid['width']) ?>" height="<?php echo esc_attr($image_grid['height']) ?>" src="<?php echo esc_url($image_grid['src']) ?>" alt="<?php echo esc_attr($image_grid['alt']) ?>" /></a>
				<?php elseif ($modus_post_layout == 'layout3'): ?>
					<div class="thumbnail-post">
						<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid3['width']) ?>" height="<?php echo esc_attr($image_grid3['height']) ?>" src="<?php echo esc_url($image_grid3['src']) ?>" alt="<?php echo esc_attr($image_grid3['alt']) ?>" /></a>
					</div>
				<?php else: ?>
					<div class="thumbnail-post">
						<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_list['width']) ?>" height="<?php echo esc_attr($image_list['height']) ?>" src="<?php echo esc_url($image_list['src']) ?>" alt="<?php echo esc_attr($image_list['alt']) ?>" /></a>
					</div>
				<?php endif; ?>
            <?php endif;?>
        <?php endif; ?>
	<?php else: ?>
		<?php if (has_post_thumbnail()): ?>
            <?php if(is_singular()): ?>
				<div class="thumbnail-post">
					<img width="<?php echo esc_attr($image_list['width']) ?>" height="<?php echo esc_attr($image_list['height']) ?>" src="<?php echo esc_url($image_list['src']) ?>" alt="<?php echo esc_attr($image_list['alt']) ?>" />
				</div>
			<?php else: ?>
				<?php if ($modus_post_layout == 'layout2'): ?>
					<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid['width']) ?>" height="<?php echo esc_attr($image_grid['height']) ?>" src="<?php echo esc_url($image_grid['src']) ?>" alt="<?php echo esc_attr($image_grid['alt']) ?>" /></a>
				<?php elseif ($modus_post_layout == 'layout3'): ?>
					<div class="thumbnail-post">
						<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid3['width']) ?>" height="<?php echo esc_attr($image_grid3['height']) ?>" src="<?php echo esc_url($image_grid3['src']) ?>" alt="<?php echo esc_attr($image_grid3['alt']) ?>" /></a>
					</div>
				<?php else: ?>
					<div class="thumbnail-post">
						<a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_list['width']) ?>" height="<?php echo esc_attr($image_list['height']) ?>" src="<?php echo esc_url($image_list['src']) ?>" alt="<?php echo esc_attr($image_list['alt']) ?>" /></a>
					</div>
				<?php endif; ?>
			<?php endif; ?>
        <?php endif;?>
	<?php endif;
}

function modus_page_id(){
	if(is_page() || is_home() || (class_exists( 'WooCommerce' ) && is_shop())){
		if(is_page()){
			$post_id = get_the_ID();
		}elseif(is_home()){
			if(get_option('page_for_posts')){
				$post_id = get_option( 'page_for_posts');
			}else{
				return false;
			}
		}else{
			if(get_option( 'woocommerce_shop_page_id' ))
				$post_id = get_option( 'woocommerce_shop_page_id' );
			else return false;
		}
	}else{
		return false;
	}
	return $post_id;
}
function modus_header_fixed(){
	$return ='';
	$modus_config = modus_settings();
		if(isset($modus_config['header_fixed']) && $modus_config['header_fixed'] == 'show') $return.= 'header_fixed';
	return $return;
}
function modus_header_fixed_2(){
	$return ='';
	$modus_config = modus_settings();
		if(isset($modus_config['header_fixed']) && $modus_config['header_fixed'] == 'show') $return.= 'header-fixed';
	return $return;
}
function modus_header_over(){
	$return ='';
	if(modus_page_id()){
		$post_id = modus_page_id();
		if(get_post_meta($post_id, 'header_over', true)){
			$return.= ' header_over';
		}
	}else{
		$modus_config = modus_settings();
		if(isset($modus_config['header_over']) && $modus_config['header_over'] == 'show') $return.= ' header_over';
	}
	return $return;
}
if ( class_exists( 'Modus_Sublevel_Walker' ) ) {
	$menus = get_terms('nav_menu');
	if(count( $menus)>0){
		add_filter( 'wp_nav_menu_args' , 'modus_menu_mega' );
		function modus_menu_mega( $args ) {
			 $args['walker'] = new modus_Sublevel_Walker; 
			return $args; 
		}
	}
}
function modus_get_attachment( $attachment_id, $size = 'full' ) {
    if (!$attachment_id)
        return false;
    $attachment = get_post( $attachment_id );
    $image = wp_get_attachment_image_src($attachment_id, $size);

    if (!$attachment)
        return false;

    return array(
        'alt' => esc_attr(get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true )),
        'caption' => esc_attr($attachment->post_excerpt),
        'description' => esc_html($attachment->post_content),
        'href' => get_permalink( $attachment->ID ),
        'src' => esc_url($image[0]),
        'title' => esc_attr($attachment->post_title),
        'width' => esc_attr($image[1]),
        'height' => esc_attr($image[2])
    );
}
function modus_header_search(){
	if (!class_exists('Woocommerce')){?>
		<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>"> 
			<input type="search" autocomplete="off" class="search-field search_default" placeholder="<?php esc_html_e('What are you looking for ...','modus')?>" value="" name="s" title="<?php esc_html_e('Enter your keywords','modus')?>">
			<div class="search-submit">
				<button type="submit"><i class="icon-search3"></i></button>
			</div>
		</form>
	<?php }else{
		$modus_terms = get_terms( 'product_cat');
	?>
		<form role="search" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/' ) ); ?>">

			<input type="search" autocomplete="off" id="woocommerce-product-search-field" class="search-field" placeholder="<?php esc_html_e('What are you looking for ...','modus')?>" value="" name="s" title="<?php esc_html_e('Enter your keywords','modus')?>">
			<div class="search-submit">
				<button type="submit"><i class="icon-search3"></i></button>
			<?php
				if ( ! empty( $modus_terms ) && ! is_wp_error( $modus_terms ) ){
					echo '<div class="dropdown category_dropdown">';
					echo '<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown"><span>'. esc_html__('All Categories','modus').'</span><i class="fa fa-angle-down"></i></button>';
					echo '<ul class="dropdown-menu">';
						echo '<li class="animate-hover" data-val=all>' . esc_html__('All Categories','modus') . '</li>';
						foreach ( $modus_terms as $term ) {
							echo '<li class="animate-hover" data-val='. $term->slug .'>' . $term->name . '</li>';
						}
					echo '</ul>';
					echo '</div>';
				}
			?>
			</div>
			<input type="hidden" name="post_type" value="product">
			<input type="hidden" name="product_cat" value="">
			<div class="auto_ajax_search"></div>
		</form>
	<?php
	}
}
function modus_layout_page() {
    if(is_page()){
        if(get_post_meta(get_the_ID(), 'page_fullwidth', true))
            return 'type2';
    }
    return 'type1';
}
function modus_post_meta(){
    $modus_config = modus_settings();
    $comments = get_comments_number();
    if ( $comments == 1 ) {
        $comments = $comments.' '.esc_html__('Comment','modus');
    }else{
        $comments = $comments.' '.esc_html__('Comments','modus');
    }
    $archive_month = get_the_time('m');
    $archive_day   = get_the_time('d');
    $archive_year  = get_the_time('Y');
    $archive_month_1 = get_the_time('m');
    //format
    $format = get_post_format();
    $modus_format = '';
    if ( current_theme_supports( 'post-formats', $format ) ) {
        if ( $format == 'link' ) {
            $class_format = 'fa fa-link';
        } else if ( $format == 'video' ){
            $class_format = 'fa fa-video-camera';
        } else if ( $format == 'audio' ) {
            $class_format = 'fa fa-volume-down';
        } else if ( $format == 'quote' ) {
            $class_format = 'fa fa-quote-left';
        }else if ( $format == 'gallery' ) {
            $class_format = 'fa fa-file-photo';
        }else if ( $format == 'aside' ) {
            $class_format = 'fa fa-file-text';
        }else if ( $format == 'image' ) {
            $class_format = 'fa fa-picture';
        }else{
            $class_format = 'standar';
        }
        $modus_format = '<a class="" href="'. esc_url( get_post_format_link( $format ) ) .'">'. get_post_format_string( $format ) .'</a>';
    }
    // category
    $categories = get_the_category();
    $modus_cat='';
    $i=1;
    if( ! empty( $categories ) ){
        $modus_cat='<div class="inline">';
        foreach ($categories as $category) {
            if ( $i > 1 ){
                $modus_cat.=',  <a href="'. esc_url( get_category_link( $category->term_id ) ) .'">'. esc_html($category->name) .'</a>';
            }else{
                $modus_cat.='<a href="'. esc_url( get_category_link( $category->term_id ) ) .'">'. esc_html($category->name) .'</a>';
            }
            $i++;
        }
        $modus_cat.='</div>';
    }
    // tags
    $args_tag = get_the_tags();
    $modus_tags = '';
    if($args_tag){
        $modus_tags='<div class="inline"><i class="fa fa-tags"></i>';
        $i=1;
        foreach ($args_tag as $key => $value) {
            if ( $i > 1 ){
                $modus_tags .= ',  <a href="'. get_tag_link($value->term_id) .'">'. esc_attr($value->name) .'</a>';
            }else{
                $modus_tags .= '<a href="'. get_tag_link($value->term_id) .'">'. esc_attr($value->name) .'</a>';
            }
            $i++;
        }
        $modus_tags .='</div>';
    }
	if(is_single()){
		$meta_date = $modus_config['single_meta_date'];
		$meta_author = $modus_config['single_meta_author'];
		$meta_comment = $modus_config['single_meta_comment'];
		$meta_tag = $modus_config['single_meta_tag'];
		$meta_cat = 'hide';
		$meta_format = $modus_config['single_meta_format'];
	}else{
		$meta_date = $modus_config['meta_date'];
		$meta_author = $modus_config['meta_author'];
		$meta_comment = $modus_config['meta_comment'];
		$meta_cat = 'hide';
		$meta_tag = $modus_config['meta_tag'];
		$meta_format = $modus_config['meta_format'];
	}
	?>
    <div class="postTitle">
        <div class="post-meta">
			<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
				 <div class="inline"><i class="modusicon-pin"></i><?php esc_html_e( 'Sticky', 'modus' ); ?></div>
			<?php endif;
			if( $meta_date=='show' ):?>
					<div class="inline meta_date"><i class="fa fa-calendar"></i><a href="<?php echo get_month_link( $archive_year, $archive_month_1 ); ?>"><span><?php echo get_the_date(); ?></span></a></div>
			<?php endif; ?>
			<?php if( $meta_author=='show' ):?>
					<div class="inline meta_author"><i class="fa fa-user"></i><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author();?></a></div>
			<?php endif; ?>
			<?php
			if( $meta_comment =='show' ): 
				if(modus_post_comment()){ ?>
						<div class="inline"><i class="fa fa-comments"></i><a href="<?php echo esc_url( get_permalink() ) . '#comments'; ?>"><?php echo esc_attr( $comments . ' '); ?>
						</a></div>
				<?php }
			endif;
			if( $meta_cat=='show') echo esc_attr($modus_cat);
			if( $meta_tag=='show') echo wp_kses_post($modus_tags);
			if( $meta_format=='show') echo wp_kses_post($modus_format);
			?>
        </div>
    </div>
<?php
}
function modus_theme_comments( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment;
    switch( $comment->comment_type ) :
        case 'pingback' :
        case 'trackback' : ?>
            <li <?php comment_class(); ?> id="comment<?php comment_ID(); ?>">
            <div class="back-link"><?php comment_author_link(); ?></div>
            </li>
        <?php break;
        default : ?>
            <li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
                <div class="post-author-box">
                    <div class="img-author">
                        <?php echo get_avatar( $comment, $args['avatar_size'] ); ?>
                    </div>
                    <div class="dsc-author">
                        <div class="info-author"><?php comment_text(); ?></div>
                        <div class="meta-comment">
                            <span class="name-author"><?php comment_author(); ?></span>
                            <div class="f_right">
<!--                                <div class="date-comment" datetime="--><?php //comment_time( 'c' ); ?><!--">--><?php //comment_date();  ?><!--</div>-->
                                <div class="date-comment"><?php comment_date();  ?></div>
                                <?php
                                    comment_reply_link( array_merge( $args, array(
                                        'reply_text' => '<span class="txt-over">'.esc_html('Reply','modus').'</span>',
                                        'before' => '',
                                        'depth' => $depth,
                                    ) ) );
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </li>
        <?php // End the default styling of comment
        break;
    endswitch;
}
function modus_content_limit($limit) {
  $content = explode(' ', get_the_content(), $limit);
  if (count($content)>=$limit) {
    array_pop($content);
    $content = implode(" ",$content).'...';
  } else {
    $content = implode(" ",$content);
  }
  $content = preg_replace('/\[.+\]/','', $content);
  $content = apply_filters('the_content', $content);
  $content = str_replace(']]>', ']]&gt;', $content);
  return $content;
}
function modus_custom_excerpt_length( $length ) {
    return 22;
}
add_filter( 'excerpt_length', 'modus_custom_excerpt_length', 999 );

function modus_remove_query_strings_1( $src ){	
	$rqs = explode( '?ver', $src );
        return $rqs[0];
} 
 
function modus_remove_query_strings_2( $src ){
	$rqs = explode( '&ver', $src );
        return $rqs[0];
} 

function modus_share($id , $share){ 
	if($share == 'Digg'){?>
		<!-- Digg -->
		<a class="share_digg" href="<?php printf( esc_url( 'http://www.digg.com/submit?url=%s' ), get_the_permalink($id) ) ?>" target="_blank">
			<i class="pe-icon-social pe-so-digg"></i>
		</a> 
<?php	
	
	}elseif($share == 'Facebook'){?>
		<!-- Facebook -->
		<a class="share_facebook" href="<?php printf( esc_url( 'http://www.facebook.com/sharer.php?u=%s' ), get_the_permalink($id) ) ?>" target="_blank">
			<i class="pe-icon-social pe-so-facebook"></i>
		</a> 
<?php	 
	}elseif($share == 'Google'){?>
		<!-- Google -->
		<a class="share_googleplus" href="<?php printf( esc_url( 'https://plus.google.com/share?url=%s' ), get_the_permalink($id) ) ?>" target="_blank">
			<i class="pe-icon-social pe-so-google-plus"></i>
		</a> 
<?php	 
	}elseif($share == 'LinkedIn'){?>
		<!-- LinkedIn -->
		<a class="share_linkedin" href="<?php printf( esc_url( 'http://www.linkedin.com/shareArticle?mini=true&amp;url=%s' ), get_the_permalink($id) ) ?>" target="_blank">
			<i class="pe-icon-social pe-so-linkedin"></i>
		</a> 
<?php		 
	}elseif($share == 'Reddit'){?> 
		<!-- Reddit -->
		<a class="share_reddit" href="<?php printf( esc_url( 'http://reddit.com/submit?url=%s' ), get_the_permalink($id) ) ?>" target="_blank">
			<i class="pe-icon-social pe-so-reddit"></i>
		</a> 
<?php	 
	}elseif($share == 'StumbleUpon'){?> 
		<!-- StumbleUpon -->
		<a class="share_stubleupon" href="<?php printf( esc_url( 'http://www.stumbleupon.com/submit?url=%s' ), get_the_permalink($id) ) ?>" target="_blank">
			<i class="pe-icon-social pe-so-stumbleupon"></i>
		</a> 
<?php	 
	}elseif($share == 'Tumblr'){?> 
		<!-- Tumblr -->
		<a class="share_tumblr" href="<?php printf( esc_url( 'http://www.tumblr.com/share/link?url=%s' ), get_the_permalink($id) ) ?>" target="_blank">
			<i class="pe-icon-social pe-so-tumblr"></i>
		</a> 
<?php	 
	}elseif($share == 'Twitter'){?> 
		<!-- Twitter -->
		<a class="share_twitter" href="<?php printf( esc_url( 'https://twitter.com/share?url=%s' ), get_the_permalink($id) ) ?>" target="_blank">
			<i class="pe-icon-social pe-so-twitter"></i>
		</a> 
<?php	 
	}elseif($share == 'VK'){?> 
		<!-- VK -->
		<a class="share_vk" href="<?php printf( esc_url( 'http://vkontakte.ru/share.php?url=%s' ), get_the_permalink($id) ) ?>" target="_blank">
			<i class="pe-icon-social pe-so-vk"></i>
		</a> 
<?php	 
	}
}